/* $Id: png.c,v 1.1.1.1 2003/01/30 12:22:26 hito Exp $ */
#include <stdio.h>
#include <png.h>
#include "stimg.h"

#ifndef png_jmpbuf
#  define png_jmpbuf(png_ptr) ((png_ptr)->jmpbuf)
#endif

#define PNG_BYTES_TO_CHECK 4

STIMG *load_png(char *file_name, int check);

STIMG_ANIMATION *
load_animation_png(char *file, int check)
{
  STIMG_ANIMATION *animation;
  STIMG *image;

  image = load_png(file, check);
  if (image == NULL)
    return NULL;

  animation = stimg_animation_new();
  if (animation == NULL) {
    stimg_delete(image);
    return NULL;
  }

  stimg_animation_add_frame(animation, image, 0, 0, 0, 0);
  return animation;
}

STIMG *
load_png(char *file_name, int check)
{
   png_structp png_ptr;
   png_infop info_ptr;
   unsigned int sig_read = 0;
   png_uint_32 i, j, row_size;
   FILE *fp;
   STIMG *image;
   png_bytep *row_pointers;
   int alpha;
   unsigned char buf[PNG_BYTES_TO_CHECK];
   unsigned char *data;

   if ((fp = fopen(file_name, "rb")) == NULL)
      return NULL;

   if (fread(buf, 1, PNG_BYTES_TO_CHECK, fp) != PNG_BYTES_TO_CHECK) {
      fclose(fp);
      return NULL;
   }

   if (png_sig_cmp(buf, (png_size_t)0, PNG_BYTES_TO_CHECK)) {
     fclose(fp);
     return NULL;
   }

   rewind(fp);

   png_ptr = png_create_read_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);

   if (png_ptr == NULL) {
      fclose(fp);
      return NULL;
   }

   info_ptr = png_create_info_struct(png_ptr);
   if (info_ptr == NULL) {
      fclose(fp);
      png_destroy_read_struct(&png_ptr, (png_infopp)NULL, (png_infopp)NULL);
      return NULL;
   }

   if (setjmp(png_jmpbuf(png_ptr))) {
      png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);
      fclose(fp);
      return NULL;
   }

   png_init_io(png_ptr, fp);
   png_set_sig_bytes(png_ptr, sig_read);


   if (check) {
     png_uint_32 width, height;
     int depth, color;
     png_read_info(png_ptr, info_ptr);
     png_get_IHDR(png_ptr, info_ptr, &width, &height, &depth, &color,
		  NULL, NULL, NULL);

     png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);
     fclose(fp);
     return stimg_new(width, height, 0);
   }     

   png_read_png(png_ptr, info_ptr,
		PNG_TRANSFORM_EXPAND|
 		PNG_TRANSFORM_STRIP_16|
		0x00,
		NULL);

   alpha = (info_ptr->channels == 4 || info_ptr->channels == 2) ? 1: 0;
   image = stimg_new(info_ptr->width, info_ptr->height, alpha);

   if (image == NULL) {
      png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);
      fclose(fp);
      return NULL;
   }     

   row_pointers = png_get_rows(png_ptr, info_ptr);
   row_size = info_ptr->width * (3 + alpha);
   data = stimg_get_data(image);
   if (info_ptr->channels > 2) {
     for (i = 0; i < info_ptr->height; i++) {
       memcpy(data + row_size * i, row_pointers[i], row_size);
     }
   } else {
     unsigned char *buf = data;
     int x;
     for (i = 0; i < info_ptr->height; i++) {
       x = 0;
       for (j = 0; j < info_ptr->width; j++) {
	 buf[0] = buf[1] = buf[2] = row_pointers[i][x];
	 if (alpha) {
	   buf[3] = row_pointers[i][++x];
	   buf++;
	 }
	 buf += 3;
	 x++;
       }
     }
   }
   png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);
   fclose(fp);
   return image;
}

