package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSQLPlan invokes the adb.DescribeSQLPlan API synchronously
func (client *Client) DescribeSQLPlan(request *DescribeSQLPlanRequest) (response *DescribeSQLPlanResponse, err error) {
	response = CreateDescribeSQLPlanResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSQLPlanWithChan invokes the adb.DescribeSQLPlan API asynchronously
func (client *Client) DescribeSQLPlanWithChan(request *DescribeSQLPlanRequest) (<-chan *DescribeSQLPlanResponse, <-chan error) {
	responseChan := make(chan *DescribeSQLPlanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSQLPlan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSQLPlanWithCallback invokes the adb.DescribeSQLPlan API asynchronously
func (client *Client) DescribeSQLPlanWithCallback(request *DescribeSQLPlanRequest, callback func(response *DescribeSQLPlanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSQLPlanResponse
		var err error
		defer close(result)
		response, err = client.DescribeSQLPlan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSQLPlanRequest is the request struct for api DescribeSQLPlan
type DescribeSQLPlanRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ProcessId            string           `position:"Query" name:"ProcessId"`
}

// DescribeSQLPlanResponse is the response struct for api DescribeSQLPlan
type DescribeSQLPlanResponse struct {
	*responses.BaseResponse
	RequestId  string         `json:"RequestId" xml:"RequestId"`
	OriginInfo string         `json:"OriginInfo" xml:"OriginInfo"`
	Detail     Detail         `json:"Detail" xml:"Detail"`
	StageList  []SqlPlanStage `json:"StageList" xml:"StageList"`
}

// CreateDescribeSQLPlanRequest creates a request to invoke DescribeSQLPlan API
func CreateDescribeSQLPlanRequest() (request *DescribeSQLPlanRequest) {
	request = &DescribeSQLPlanRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "DescribeSQLPlan", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSQLPlanResponse creates a response to parse from DescribeSQLPlan response
func CreateDescribeSQLPlanResponse() (response *DescribeSQLPlanResponse) {
	response = &DescribeSQLPlanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
