package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLogInfo invokes the aegis.DescribeLogInfo API synchronously
// api document: https://help.aliyun.com/api/aegis/describeloginfo.html
func (client *Client) DescribeLogInfo(request *DescribeLogInfoRequest) (response *DescribeLogInfoResponse, err error) {
	response = CreateDescribeLogInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLogInfoWithChan invokes the aegis.DescribeLogInfo API asynchronously
// api document: https://help.aliyun.com/api/aegis/describeloginfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLogInfoWithChan(request *DescribeLogInfoRequest) (<-chan *DescribeLogInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeLogInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLogInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLogInfoWithCallback invokes the aegis.DescribeLogInfo API asynchronously
// api document: https://help.aliyun.com/api/aegis/describeloginfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLogInfoWithCallback(request *DescribeLogInfoRequest, callback func(response *DescribeLogInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLogInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeLogInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLogInfoRequest is the request struct for api DescribeLogInfo
type DescribeLogInfoRequest struct {
	*requests.RpcRequest
	SourceIp    string `position:"Query" name:"SourceIp"`
	Query       string `position:"Query" name:"Query"`
	PageSize    string `position:"Query" name:"PageSize"`
	EndTime     string `position:"Query" name:"EndTime"`
	CurrentPage string `position:"Query" name:"CurrentPage"`
	StartTime   string `position:"Query" name:"StartTime"`
}

// DescribeLogInfoResponse is the response struct for api DescribeLogInfo
type DescribeLogInfoResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	TotalCount   int    `json:"TotalCount" xml:"TotalCount"`
	LogInfoItems []Item `json:"LogInfoItems" xml:"LogInfoItems"`
}

// CreateDescribeLogInfoRequest creates a request to invoke DescribeLogInfo API
func CreateDescribeLogInfoRequest() (request *DescribeLogInfoRequest) {
	request = &DescribeLogInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeLogInfo", "vipaegis", "openAPI")
	return
}

// CreateDescribeLogInfoResponse creates a response to parse from DescribeLogInfo response
func CreateDescribeLogInfoResponse() (response *DescribeLogInfoResponse) {
	response = &DescribeLogInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
