package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveTraceAppConfig invokes the arms.SaveTraceAppConfig API synchronously
func (client *Client) SaveTraceAppConfig(request *SaveTraceAppConfigRequest) (response *SaveTraceAppConfigResponse, err error) {
	response = CreateSaveTraceAppConfigResponse()
	err = client.DoAction(request, response)
	return
}

// SaveTraceAppConfigWithChan invokes the arms.SaveTraceAppConfig API asynchronously
func (client *Client) SaveTraceAppConfigWithChan(request *SaveTraceAppConfigRequest) (<-chan *SaveTraceAppConfigResponse, <-chan error) {
	responseChan := make(chan *SaveTraceAppConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveTraceAppConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveTraceAppConfigWithCallback invokes the arms.SaveTraceAppConfig API asynchronously
func (client *Client) SaveTraceAppConfigWithCallback(request *SaveTraceAppConfigRequest, callback func(response *SaveTraceAppConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveTraceAppConfigResponse
		var err error
		defer close(result)
		response, err = client.SaveTraceAppConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveTraceAppConfigRequest is the request struct for api SaveTraceAppConfig
type SaveTraceAppConfigRequest struct {
	*requests.RpcRequest
	Settings *[]SaveTraceAppConfigSettings `position:"Query" name:"Settings"  type:"Repeated"`
	Pid      string                        `position:"Query" name:"Pid"`
}

// SaveTraceAppConfigSettings is a repeated param struct in SaveTraceAppConfigRequest
type SaveTraceAppConfigSettings struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// SaveTraceAppConfigResponse is the response struct for api SaveTraceAppConfig
type SaveTraceAppConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateSaveTraceAppConfigRequest creates a request to invoke SaveTraceAppConfig API
func CreateSaveTraceAppConfigRequest() (request *SaveTraceAppConfigRequest) {
	request = &SaveTraceAppConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "SaveTraceAppConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateSaveTraceAppConfigResponse creates a response to parse from SaveTraceAppConfig response
func CreateSaveTraceAppConfigResponse() (response *SaveTraceAppConfigResponse) {
	response = &SaveTraceAppConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
