package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListInstancesEx invokes the cloudcallcenter.ListInstancesEx API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listinstancesex.html
func (client *Client) ListInstancesEx(request *ListInstancesExRequest) (response *ListInstancesExResponse, err error) {
	response = CreateListInstancesExResponse()
	err = client.DoAction(request, response)
	return
}

// ListInstancesExWithChan invokes the cloudcallcenter.ListInstancesEx API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listinstancesex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListInstancesExWithChan(request *ListInstancesExRequest) (<-chan *ListInstancesExResponse, <-chan error) {
	responseChan := make(chan *ListInstancesExResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListInstancesEx(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListInstancesExWithCallback invokes the cloudcallcenter.ListInstancesEx API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listinstancesex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListInstancesExWithCallback(request *ListInstancesExRequest, callback func(response *ListInstancesExResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListInstancesExResponse
		var err error
		defer close(result)
		response, err = client.ListInstancesEx(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListInstancesExRequest is the request struct for api ListInstancesEx
type ListInstancesExRequest struct {
	*requests.RpcRequest
}

// ListInstancesExResponse is the response struct for api ListInstancesEx
type ListInstancesExResponse struct {
	*responses.BaseResponse
	RequestId      string                     `json:"RequestId" xml:"RequestId"`
	Success        bool                       `json:"Success" xml:"Success"`
	Code           string                     `json:"Code" xml:"Code"`
	Message        string                     `json:"Message" xml:"Message"`
	HttpStatusCode int                        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Instances      InstancesInListInstancesEx `json:"Instances" xml:"Instances"`
}

// CreateListInstancesExRequest creates a request to invoke ListInstancesEx API
func CreateListInstancesExRequest() (request *ListInstancesExRequest) {
	request = &ListInstancesExRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListInstancesEx", "", "")
	request.Method = requests.POST
	return
}

// CreateListInstancesExResponse creates a response to parse from ListInstancesEx response
func CreateListInstancesExResponse() (response *ListInstancesExResponse) {
	response = &ListInstancesExResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
