package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnbindPrivacyNumber invokes the cloudcallcenter.UnbindPrivacyNumber API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/unbindprivacynumber.html
func (client *Client) UnbindPrivacyNumber(request *UnbindPrivacyNumberRequest) (response *UnbindPrivacyNumberResponse, err error) {
	response = CreateUnbindPrivacyNumberResponse()
	err = client.DoAction(request, response)
	return
}

// UnbindPrivacyNumberWithChan invokes the cloudcallcenter.UnbindPrivacyNumber API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/unbindprivacynumber.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UnbindPrivacyNumberWithChan(request *UnbindPrivacyNumberRequest) (<-chan *UnbindPrivacyNumberResponse, <-chan error) {
	responseChan := make(chan *UnbindPrivacyNumberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnbindPrivacyNumber(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnbindPrivacyNumberWithCallback invokes the cloudcallcenter.UnbindPrivacyNumber API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/unbindprivacynumber.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UnbindPrivacyNumberWithCallback(request *UnbindPrivacyNumberRequest, callback func(response *UnbindPrivacyNumberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnbindPrivacyNumberResponse
		var err error
		defer close(result)
		response, err = client.UnbindPrivacyNumber(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnbindPrivacyNumberRequest is the request struct for api UnbindPrivacyNumber
type UnbindPrivacyNumberRequest struct {
	*requests.RpcRequest
	SubId       string `position:"Query" name:"SubId"`
	ProviderId  string `position:"Query" name:"ProviderId"`
	PhoneNumber string `position:"Query" name:"PhoneNumber"`
	BizId       string `position:"Query" name:"BizId"`
	Type        string `position:"Query" name:"Type"`
}

// UnbindPrivacyNumberResponse is the response struct for api UnbindPrivacyNumber
type UnbindPrivacyNumberResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateUnbindPrivacyNumberRequest creates a request to invoke UnbindPrivacyNumber API
func CreateUnbindPrivacyNumberRequest() (request *UnbindPrivacyNumberRequest) {
	request = &UnbindPrivacyNumberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "UnbindPrivacyNumber", "", "")
	request.Method = requests.POST
	return
}

// CreateUnbindPrivacyNumberResponse creates a response to parse from UnbindPrivacyNumber response
func CreateUnbindPrivacyNumberResponse() (response *UnbindPrivacyNumberResponse) {
	response = &UnbindPrivacyNumberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
