package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfigureSubscriptionInstanceAlert invokes the dts.ConfigureSubscriptionInstanceAlert API synchronously
func (client *Client) ConfigureSubscriptionInstanceAlert(request *ConfigureSubscriptionInstanceAlertRequest) (response *ConfigureSubscriptionInstanceAlertResponse, err error) {
	response = CreateConfigureSubscriptionInstanceAlertResponse()
	err = client.DoAction(request, response)
	return
}

// ConfigureSubscriptionInstanceAlertWithChan invokes the dts.ConfigureSubscriptionInstanceAlert API asynchronously
func (client *Client) ConfigureSubscriptionInstanceAlertWithChan(request *ConfigureSubscriptionInstanceAlertRequest) (<-chan *ConfigureSubscriptionInstanceAlertResponse, <-chan error) {
	responseChan := make(chan *ConfigureSubscriptionInstanceAlertResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfigureSubscriptionInstanceAlert(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfigureSubscriptionInstanceAlertWithCallback invokes the dts.ConfigureSubscriptionInstanceAlert API asynchronously
func (client *Client) ConfigureSubscriptionInstanceAlertWithCallback(request *ConfigureSubscriptionInstanceAlertRequest, callback func(response *ConfigureSubscriptionInstanceAlertResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfigureSubscriptionInstanceAlertResponse
		var err error
		defer close(result)
		response, err = client.ConfigureSubscriptionInstanceAlert(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfigureSubscriptionInstanceAlertRequest is the request struct for api ConfigureSubscriptionInstanceAlert
type ConfigureSubscriptionInstanceAlertRequest struct {
	*requests.RpcRequest
	DelayOverSeconds       string `position:"Query" name:"DelayOverSeconds"`
	DelayAlertStatus       string `position:"Query" name:"DelayAlertStatus"`
	SubscriptionInstanceId string `position:"Query" name:"SubscriptionInstanceId"`
	OwnerId                string `position:"Query" name:"OwnerId"`
	AccountId              string `position:"Query" name:"AccountId"`
	ErrorAlertPhone        string `position:"Query" name:"ErrorAlertPhone"`
	DelayAlertPhone        string `position:"Query" name:"DelayAlertPhone"`
	ErrorAlertStatus       string `position:"Query" name:"ErrorAlertStatus"`
}

// ConfigureSubscriptionInstanceAlertResponse is the response struct for api ConfigureSubscriptionInstanceAlert
type ConfigureSubscriptionInstanceAlertResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	ErrCode    string `json:"ErrCode" xml:"ErrCode"`
	Success    string `json:"Success" xml:"Success"`
	ErrMessage string `json:"ErrMessage" xml:"ErrMessage"`
}

// CreateConfigureSubscriptionInstanceAlertRequest creates a request to invoke ConfigureSubscriptionInstanceAlert API
func CreateConfigureSubscriptionInstanceAlertRequest() (request *ConfigureSubscriptionInstanceAlertRequest) {
	request = &ConfigureSubscriptionInstanceAlertRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "ConfigureSubscriptionInstanceAlert", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateConfigureSubscriptionInstanceAlertResponse creates a response to parse from ConfigureSubscriptionInstanceAlert response
func CreateConfigureSubscriptionInstanceAlertResponse() (response *ConfigureSubscriptionInstanceAlertResponse) {
	response = &ConfigureSubscriptionInstanceAlertResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
