package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDsReports invokes the outboundbot.DescribeDsReports API synchronously
func (client *Client) DescribeDsReports(request *DescribeDsReportsRequest) (response *DescribeDsReportsResponse, err error) {
	response = CreateDescribeDsReportsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDsReportsWithChan invokes the outboundbot.DescribeDsReports API asynchronously
func (client *Client) DescribeDsReportsWithChan(request *DescribeDsReportsRequest) (<-chan *DescribeDsReportsResponse, <-chan error) {
	responseChan := make(chan *DescribeDsReportsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDsReports(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDsReportsWithCallback invokes the outboundbot.DescribeDsReports API asynchronously
func (client *Client) DescribeDsReportsWithCallback(request *DescribeDsReportsRequest, callback func(response *DescribeDsReportsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDsReportsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDsReports(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDsReportsRequest is the request struct for api DescribeDsReports
type DescribeDsReportsRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	JobGroupId string `position:"Query" name:"JobGroupId"`
}

// DescribeDsReportsResponse is the response struct for api DescribeDsReports
type DescribeDsReportsResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	DsReports      string `json:"DsReports" xml:"DsReports"`
}

// CreateDescribeDsReportsRequest creates a request to invoke DescribeDsReports API
func CreateDescribeDsReportsRequest() (request *DescribeDsReportsRequest) {
	request = &DescribeDsReportsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "DescribeDsReports", "outboundbot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDsReportsResponse creates a response to parse from DescribeDsReports response
func CreateDescribeDsReportsResponse() (response *DescribeDsReportsResponse) {
	response = &DescribeDsReportsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
