package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryRingDetailList invokes the scsp.QueryRingDetailList API synchronously
func (client *Client) QueryRingDetailList(request *QueryRingDetailListRequest) (response *QueryRingDetailListResponse, err error) {
	response = CreateQueryRingDetailListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryRingDetailListWithChan invokes the scsp.QueryRingDetailList API asynchronously
func (client *Client) QueryRingDetailListWithChan(request *QueryRingDetailListRequest) (<-chan *QueryRingDetailListResponse, <-chan error) {
	responseChan := make(chan *QueryRingDetailListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryRingDetailList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryRingDetailListWithCallback invokes the scsp.QueryRingDetailList API asynchronously
func (client *Client) QueryRingDetailListWithCallback(request *QueryRingDetailListRequest, callback func(response *QueryRingDetailListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryRingDetailListResponse
		var err error
		defer close(result)
		response, err = client.QueryRingDetailList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryRingDetailListRequest is the request struct for api QueryRingDetailList
type QueryRingDetailListRequest struct {
	*requests.RpcRequest
	FromPhoneNumList string           `position:"Body"`
	CallOutStatus    string           `position:"Body"`
	StartDate        requests.Integer `position:"Body"`
	EndDate          requests.Integer `position:"Body"`
	InstanceId       string           `position:"Body"`
	PageNo           requests.Integer `position:"Body"`
	Extra            string           `position:"Body"`
	PageSize         requests.Integer `position:"Body"`
	ToPhoneNumList   string           `position:"Body"`
}

// QueryRingDetailListResponse is the response struct for api QueryRingDetailList
type QueryRingDetailListResponse struct {
	*responses.BaseResponse
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           string `json:"Data" xml:"Data"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	HttpStatusCode int64  `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateQueryRingDetailListRequest creates a request to invoke QueryRingDetailList API
func CreateQueryRingDetailListRequest() (request *QueryRingDetailListRequest) {
	request = &QueryRingDetailListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "QueryRingDetailList", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryRingDetailListResponse creates a response to parse from QueryRingDetailList response
func CreateQueryRingDetailListResponse() (response *QueryRingDetailListResponse) {
	response = &QueryRingDetailListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
