package sddp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeConfigs invokes the sddp.DescribeConfigs API synchronously
func (client *Client) DescribeConfigs(request *DescribeConfigsRequest) (response *DescribeConfigsResponse, err error) {
	response = CreateDescribeConfigsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeConfigsWithChan invokes the sddp.DescribeConfigs API asynchronously
func (client *Client) DescribeConfigsWithChan(request *DescribeConfigsRequest) (<-chan *DescribeConfigsResponse, <-chan error) {
	responseChan := make(chan *DescribeConfigsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeConfigs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeConfigsWithCallback invokes the sddp.DescribeConfigs API asynchronously
func (client *Client) DescribeConfigsWithCallback(request *DescribeConfigsRequest, callback func(response *DescribeConfigsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeConfigsResponse
		var err error
		defer close(result)
		response, err = client.DescribeConfigs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeConfigsRequest is the request struct for api DescribeConfigs
type DescribeConfigsRequest struct {
	*requests.RpcRequest
	FeatureType requests.Integer `position:"Query" name:"FeatureType"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	Lang        string           `position:"Query" name:"Lang"`
}

// DescribeConfigsResponse is the response struct for api DescribeConfigs
type DescribeConfigsResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	ConfigList []Config `json:"ConfigList" xml:"ConfigList"`
}

// CreateDescribeConfigsRequest creates a request to invoke DescribeConfigs API
func CreateDescribeConfigsRequest() (request *DescribeConfigsRequest) {
	request = &DescribeConfigsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sddp", "2019-01-03", "DescribeConfigs", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeConfigsResponse creates a response to parse from DescribeConfigs response
func CreateDescribeConfigsResponse() (response *DescribeConfigsResponse) {
	response = &DescribeConfigsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
