package snsuapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MobileStopSpeedUp invokes the snsuapi.MobileStopSpeedUp API synchronously
// api document: https://help.aliyun.com/api/snsuapi/mobilestopspeedup.html
func (client *Client) MobileStopSpeedUp(request *MobileStopSpeedUpRequest) (response *MobileStopSpeedUpResponse, err error) {
	response = CreateMobileStopSpeedUpResponse()
	err = client.DoAction(request, response)
	return
}

// MobileStopSpeedUpWithChan invokes the snsuapi.MobileStopSpeedUp API asynchronously
// api document: https://help.aliyun.com/api/snsuapi/mobilestopspeedup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MobileStopSpeedUpWithChan(request *MobileStopSpeedUpRequest) (<-chan *MobileStopSpeedUpResponse, <-chan error) {
	responseChan := make(chan *MobileStopSpeedUpResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MobileStopSpeedUp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MobileStopSpeedUpWithCallback invokes the snsuapi.MobileStopSpeedUp API asynchronously
// api document: https://help.aliyun.com/api/snsuapi/mobilestopspeedup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MobileStopSpeedUpWithCallback(request *MobileStopSpeedUpRequest, callback func(response *MobileStopSpeedUpResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MobileStopSpeedUpResponse
		var err error
		defer close(result)
		response, err = client.MobileStopSpeedUp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MobileStopSpeedUpRequest is the request struct for api MobileStopSpeedUp
type MobileStopSpeedUpRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	CorrelationId        string           `position:"Query" name:"CorrelationId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// MobileStopSpeedUpResponse is the response struct for api MobileStopSpeedUp
type MobileStopSpeedUpResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	ResultCode    string `json:"ResultCode" xml:"ResultCode"`
	ResultMessage string `json:"ResultMessage" xml:"ResultMessage"`
	ResultModule  bool   `json:"ResultModule" xml:"ResultModule"`
}

// CreateMobileStopSpeedUpRequest creates a request to invoke MobileStopSpeedUp API
func CreateMobileStopSpeedUpRequest() (request *MobileStopSpeedUpRequest) {
	request = &MobileStopSpeedUpRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Snsuapi", "2018-07-09", "MobileStopSpeedUp", "snsuapi", "openAPI")
	return
}

// CreateMobileStopSpeedUpResponse creates a response to parse from MobileStopSpeedUp response
func CreateMobileStopSpeedUpResponse() (response *MobileStopSpeedUpResponse) {
	response = &MobileStopSpeedUpResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
