package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UploadMediaByURL invokes the vod.UploadMediaByURL API synchronously
func (client *Client) UploadMediaByURL(request *UploadMediaByURLRequest) (response *UploadMediaByURLResponse, err error) {
	response = CreateUploadMediaByURLResponse()
	err = client.DoAction(request, response)
	return
}

// UploadMediaByURLWithChan invokes the vod.UploadMediaByURL API asynchronously
func (client *Client) UploadMediaByURLWithChan(request *UploadMediaByURLRequest) (<-chan *UploadMediaByURLResponse, <-chan error) {
	responseChan := make(chan *UploadMediaByURLResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UploadMediaByURL(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UploadMediaByURLWithCallback invokes the vod.UploadMediaByURL API asynchronously
func (client *Client) UploadMediaByURLWithCallback(request *UploadMediaByURLRequest, callback func(response *UploadMediaByURLResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UploadMediaByURLResponse
		var err error
		defer close(result)
		response, err = client.UploadMediaByURL(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UploadMediaByURLRequest is the request struct for api UploadMediaByURL
type UploadMediaByURLRequest struct {
	*requests.RpcRequest
	MessageCallback string `position:"Query" name:"MessageCallback"`
	StorageLocation string `position:"Query" name:"StorageLocation"`
	UserData        string `position:"Query" name:"UserData"`
	WorkflowId      string `position:"Query" name:"WorkflowId"`
	S3UploadInfo    string `position:"Query" name:"S3UploadInfo"`
	Priority        string `position:"Query" name:"Priority"`
	TemplateGroupId string `position:"Query" name:"TemplateGroupId"`
	UploadMetadatas string `position:"Query" name:"UploadMetadatas"`
	UploadURLs      string `position:"Query" name:"UploadURLs"`
	AppId           string `position:"Query" name:"AppId"`
}

// UploadMediaByURLResponse is the response struct for api UploadMediaByURL
type UploadMediaByURLResponse struct {
	*responses.BaseResponse
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	UploadJobs []UploadJob `json:"UploadJobs" xml:"UploadJobs"`
}

// CreateUploadMediaByURLRequest creates a request to invoke UploadMediaByURL API
func CreateUploadMediaByURLRequest() (request *UploadMediaByURLRequest) {
	request = &UploadMediaByURLRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "UploadMediaByURL", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUploadMediaByURLResponse creates a response to parse from UploadMediaByURL response
func CreateUploadMediaByURLResponse() (response *UploadMediaByURLResponse) {
	response = &UploadMediaByURLResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
