package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReleaseEipSegmentAddress invokes the vpc.ReleaseEipSegmentAddress API synchronously
func (client *Client) ReleaseEipSegmentAddress(request *ReleaseEipSegmentAddressRequest) (response *ReleaseEipSegmentAddressResponse, err error) {
	response = CreateReleaseEipSegmentAddressResponse()
	err = client.DoAction(request, response)
	return
}

// ReleaseEipSegmentAddressWithChan invokes the vpc.ReleaseEipSegmentAddress API asynchronously
func (client *Client) ReleaseEipSegmentAddressWithChan(request *ReleaseEipSegmentAddressRequest) (<-chan *ReleaseEipSegmentAddressResponse, <-chan error) {
	responseChan := make(chan *ReleaseEipSegmentAddressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReleaseEipSegmentAddress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReleaseEipSegmentAddressWithCallback invokes the vpc.ReleaseEipSegmentAddress API asynchronously
func (client *Client) ReleaseEipSegmentAddressWithCallback(request *ReleaseEipSegmentAddressRequest, callback func(response *ReleaseEipSegmentAddressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReleaseEipSegmentAddressResponse
		var err error
		defer close(result)
		response, err = client.ReleaseEipSegmentAddress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReleaseEipSegmentAddressRequest is the request struct for api ReleaseEipSegmentAddress
type ReleaseEipSegmentAddressRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	SegmentInstanceId    string           `position:"Query" name:"SegmentInstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ReleaseEipSegmentAddressResponse is the response struct for api ReleaseEipSegmentAddress
type ReleaseEipSegmentAddressResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateReleaseEipSegmentAddressRequest creates a request to invoke ReleaseEipSegmentAddress API
func CreateReleaseEipSegmentAddressRequest() (request *ReleaseEipSegmentAddressRequest) {
	request = &ReleaseEipSegmentAddressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ReleaseEipSegmentAddress", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateReleaseEipSegmentAddressResponse creates a response to parse from ReleaseEipSegmentAddress response
func CreateReleaseEipSegmentAddressResponse() (response *ReleaseEipSegmentAddressResponse) {
	response = &ReleaseEipSegmentAddressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
