# Awesome Remote Job [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

A curated list of awesome [remote working](https://en.wikipedia.org/wiki/Telecommuting) resources.

*To contribute, click README.md and then the pencil icon. Make your changes and click the "Propose file change" button to submit a pull request. Make sure to follow [the contributions guidelines](CONTRIBUTING.md).*

## Table of Contents

<!-- MarkdownTOC depth=4 -->

- [Articles & Posts](#articles--posts)
- [Videos](#videos)
- [Books](#books)
- [Comics](#comics)
- [Job boards](#job-boards)
- [Job boards aggregators](#job-boards-aggregators)
- [Housing](#housing)
- [Interviewing](#interviewing)
- [Events](#events)
- [Newsletters](#newsletters)
- [Podcasts](#podcasts)
- [Companies with "remote DNA"](#companies-with-remote-dna)
- [Q&A](#qa)
- [Communities](#communities)
- [Conferences](#conferences)
- [Tools](#tools)
  - [Communication](#communication)
  - [Project Management](#project-management)
  - [Others](#others)
- [Law & Finance](#law--finance)
- [Others](#others-1)

<!-- /MarkdownTOC -->

## Articles & Posts
  1. [10 Lessons from 4 Years Working Remotely at Automattic](https://whenihavetime.com/2014/07/08/10-lessons-from-4-years-working-remotely/)
  1. [10 Secrets to Becoming a Great Remote Developer](https://x-team.com/blog/10-secrets-to-becoming-a-great-remote-developer/)
  1. [30 Tips for Successful Communication as a Remote Worker](http://www.hanselman.com/blog/30TipsForSuccessfulCommunicationAsARemoteWorker.aspx)
  1. [4 Little-Known Hacks for Finding Remote Work](http://blog.hubstaff.com/hacks-find-remote-jobs/)
  1. [5 Tricks to Get More Done While Working Remotely](https://medium.com/@rdutel/working-remotely-getting-things-done-38dcd0413733)
  1. [Acceptance of Telecommuting Project Management Grows](http://www.amanet.org/training/articles/Acceptance-of-Telecommuting-Project-Management-Grows.aspx?pcode=XCRP)
  1. [Andreessen-Incubated Teleport Aims To Make Location Irrelevant For Mobile Workers](https://techcrunch.com/2014/05/19/teleport/)
  1. [Bosses without borders: Essential tools for managing remote workers](http://www.pcworld.com/article/2045737/bosses-without-borders-essential-tools-for-managing-remote-workers.html)
  1. [Communication for Distributed Teams](https://www.lullabot.com/articles/communication-for-distributed-teams)
  1. [Death of the office and rise of the telecommuter](http://www.zdnet.com/article/death-of-the-office-and-rise-of-the-telecommuter/)
  1. [For Some, Home=Office](http://www.wsj.com/news/articles/SB10001424127887324677204578185180450152760)
  1. [Give people the freedom of where to work](https://www.virgin.com/richard-branson/give-people-the-freedom-of-where-to-work)
  1. [Hiring Secrets Of A Distributed Company](https://www.lullabot.com/articles/hiring-secrets-of-a-distributed-company)
  1. [How GitHub Works](https://zachholman.com/posts/how-github-works/)
  1. [How many companies are 100% distributed? (Research Summary)](http://scottberkun.com/2013/how-many-companies-are-100-distributed/)
  1. [How many people really work from home? (research summary)](http://scottberkun.com/2013/how-many-people-really-work-from-home-research-summary/)
  1. [How We Went Remote](https://archive.org/details/oscon2014-how-we-went-remote) (archive.org video from [OSCON 2014](https://conferences.oreilly.com/oscon/oscon2014/public/schedule/detail/34260) presentation)
  1. [How Working at Home Works (For Us)](https://www.lullabot.com/articles/how-working-at-home-works-for-us)
  1. [It’s Unclearly Defined, but Telecommuting Is Fast on the Rise](https://www.nytimes.com/2014/03/08/your-money/when-working-in-your-pajamas-is-more-productive.html?_r=0)
  1. [Latest Telecommuting Statistics | Global Workplace Analytics](http://globalworkplaceanalytics.com/telecommuting-statistics)
  1. [Learning From Distributed Companies](https://www.lullabot.com/articles/learning-from-distributed-companies)
  1. [Managing a Geographically Dispersed Team: Achieving Your Goals Together, While Apart](https://www.mindtools.com/pages/article/newTMM_40.htm)
  1. [Michael Bloomberg agrees with Marissa Mayer on telecommuting](http://www.capitalnewyork.com/article/politics/2013/03/8071699/michael-bloomberg-agrees-marissa-mayer-telecommuting)
  1. [My Ideal Day as a Remote Programmer: Taking Charge of Your Daily Routine](https://overflow.buffer.com/2014/06/12/my-ideal-day-as-a-programmer-taking-charge-of-your-daily-routine/)
  1. [My Remote Developer Life](https://shift.infinite.red/my-remote-developer-life-ama-bb91fa7bd0bd#.kjpehbcab)
  1. [One day offices will be a thing of the past](https://www.virgin.com/richard-branson/one-day-offices-will-be-a-thing-of-the-past)
  1. [Remote worker vs distributed team](https://opensource.com/life/11/11/remote-worker-vs-distributed-team)
  1. [Remote Workers Log More Hours and Are Slightly More Engaged](http://www.gallup.com/opinion/gallup/170669/remote-workers-log-hours-slightly-engaged.aspx)
  1. [Remote Working – 3 Year Retrospective](http://blog.jonliv.es/blog/2015/01/14/remote-working-3-year-retrospective/)
  1. [Rethinking Agile in an office-less world](https://signalvnoise.com/posts/3641-rethinking-agile-in-an-office-less-world)
  1. [Six Strategies for Managing Telecommuters](http://www.cio.com/article/2422138/leadership-management/six-strategies-for-managing-telecommuters.html)
  1. [Solo Workers Bond at Shared Workspaces](http://www.nytimes.com/2013/05/05/fashion/solo-workers-bond-at-shared-workspaces.html)
  1. [Team Knowledge and Coordination in Geographically Distributed Software Development](http://kraut.hciresearch.org/sites/kraut.hciresearch.org/files/articles/Espinosa07-CoordinationInGlobalSWDevelopment.pdf)
  1. [The future of telecommuting: Corralling the Yahoos](http://www.economist.com/news/business/21572804-technology-allows-millions-people-work-home-big-tech-firm-trying-stop?fsrc=scn/tw/te/pe/corallingtheyahoos)
  1. [The Pros & Cons of Being a Remote Team (& How We Do It)](https://www.groovehq.com/blog/being-a-remote-team)
  1. [To Raise Productivity, Let More Employees Work from Home](https://hbr.org/2014/01/to-raise-productivity-let-more-employees-work-from-home)
  1. [What is a Distributed Company?](https://www.lullabot.com/articles/what-is-a-distributed-company)
  1. [Why I work remotely ( hint: it has nothing to do with productivity)](https://m.signalvnoise.com/why-i-work-remotely-hint-it-has-nothing-to-do-with-productivity-34ace30f74fc?gi=39b26e8f40a1)
  1. [Why Coworking Is a Hit for Telecommuters and Entrepreneurs](http://www.cio.com/article/2369058/telecommuting/why-coworking-is-a-hit-for-telecommuters-and-entrepreneurs.html)
  1. [Why Marissa Mayer’s ban on remote working at Yahoo could backfire badly](https://gigaom.com/2013/02/25/why-marissa-mayers-ban-on-remote-working-at-yahoo-could-backfire-badly/)
  1. [Why moonlighting will change your career](https://blog.landing.jobs/why-moonlighting-will-change-your-career-7e8aac3dc25f)
  1. [Why Remote Workers Are More (Yes, More) Engaged](https://hbr.org/2012/08/are-you-taking-your-people-for)
  1. [Why Small Businesses Are Building Remote Workforces](http://www.businessinsider.com/why-small-businesses-are-building-remote-workforces-2013-10)
  1. [Why We (Still) Believe in Working Remotely](https://stackoverflow.blog/2013/02/why-we-still-believe-in-working-remotely/)
  1. ['Working From Home' Without Slacking Off](http://www.wsj.com/news/articles/SB10001424052702303684004577508953483021234)
  1. [Working Outside the Box: A Study of the Growing Momentum in Telework](http://www-01.ibm.com/industries/government/ieg/pdf/working_outside_the_box.pdf)
  1. [Working Remotely for Extroverts](https://hoppycow.com/2014/12/13/working-remotely-for-extroverts/)
  1. [Yahoo, Best Buy, and Telecommuting: Advice From A Distributed Company](https://www.lullabot.com/articles/yahoo-best-buy-and-telecommuting-advice-from-a-distributed-company)
  1. [Your Commute Is Killing You](http://www.slate.com/articles/business/moneybox/2011/05/your_commute_is_killing_you.html)
  1. [21 tools that will help your remote team work better together](http://thenextweb.com/apps/2014/12/06/tools-remote-teams/)
  1. [How to run a team of people who never see each other](https://qz.com/230998/how-to-run-a-team-of-people-who-never-see-each-other/)
  1. [Who Needs an Office? How to Go 100 Percent Remote.](https://www.entrepreneur.com/article/242708)
  1. [Remote Work: How to work the Precision Nutrition way](http://www.precisionnutrition.com/remote-how-to-work-the-pn-way)
  1. [How to suggest improvements remotely](https://x-team.com/blog/suggest-improvements-remotely/)
  1. [8 tips that will make you a more active, healthier remote developer](https://x-team.com/blog/how-to-be-healthy-remote/)
  1. [The 5 most important things we do as a remote company](https://x-team.com/blog/5-important-things-remote-company/)
  1. [How to focus when working remotely](https://x-team.com/blog/focus-working-remotely/)
  1. [3 mistakes to avoid if you want to get hired remotely](https://x-team.com/blog/mistakes-remote-developers/)
  1. [Becoming a contractor programmer in the UK](https://github.com/tadast/switching-to-contracting-uk/tree/formationsfactory)
  1. [Remote versus Co-located Work](https://martinfowler.com/articles/remote-or-co-located.html)
  1. [Gitlab's Remote Manifesto](https://about.gitlab.com/2015/04/08/the-remote-manifesto/)
  1. [Datadog Engineering: 9 ways to make working remote work for you](http://engineering.datadoghq.com/9-ways-to-make-working-remote-work-for-you/)
  1. [The Villains of Remote Work](https://blog.dnsimple.com/2016/10/the-villains-of-remote-work/)
  1. [Working remotely, coworking spaces, and mental health](https://bitquabit.com/post/working-remotely-coworking-and-mental-health/)
  1. [How to Make Remote Working Work for You](https://www.toptal.com/remote/how-to-make-remote-working-work-for-you)
  1. [Things To Watch Out For While Working Remotely](https://www.toptal.com/remote/remote-work-burnout-a-cautionary-tale)
  1. [How to Work Remotely and Still Be the Best](https://www.toptal.com/freelance/how-to-work-remotely-and-still-be-the-best)
  1. [The Ultimate Remote Team Culture](https://www.toptal.com/remote/the-ultimate-remote-culture)
  1. [How to Get a Remote Job](https://medium.com/@GOODROOT/how-to-get-a-remote-job-bb746e22a874)
  1. [How to Handle Client Work Remotely: Our Communication Stack](https://marsbased.com/blog/2015/12/07/how-to-handle-client-work-remotely-our-communication-stack/)
  1. [How a Week of Remote Work Boosts my Productivity Enormously](http://www.alexrodba.com/2016/07/24/How-a-week-of-remote-work-boosts-my-productivity-enormously/)
  1. [How to Keep Your Remote Workers Productive](http://www.alexrodba.com/2016/03/22/How-To-Keep-Your-Remote-Workers-Productive/)

## Videos
  1. [Jason Fried: Why work doesn't happen at work](https://www.youtube.com/watch?v=5XD2kNopsUs)
  1. [Fluent 2013: Mike Hostetler, “Remote Working Works!”](https://www.youtube.com/watch?v=23oBUH270YU)

## Books
  1. [Remote: Office Not Required](http://37signals.com/remote/).
     by Jason Fried and David Heinemeier Hansson (37signals), 2013.
  1. [The Ultimate Guide to Remote Work](https://zapier.com/learn/remote-work/).
     by Wade Foster (Zapier), 2015.
  1. [The Year Without Pants: WordPress.com and the Future of Work](http://scottberkun.com/yearwithoutpants/).
     by Scott Berkun, 2013.
  1. [The Remote Jobseeker’s Handbook](http://cobyism.com/remotejobseeker/).
     by Coby Chapple (GitHub), 2016.
  1. [Async Remote](http://blog.arkency.com/async-remote/).
     by Robert Pankowecki and Andrzej Krzywda (Arkency), 2014.

## Comics

  1. [Why working from home is both awesome and horrible](http://theoatmeal.com/comics/working_home)

## Job boards
  1. [Angel List](https://angel.co/jobs) - Startup Jobs. Search by going to Job Type, and selecting "Remote OK".
  1. [Authentic Jobs](https://authenticjobs.com/#remote=true) – Full-time and freelance job opportunities for web, design, and creative professionals.
  1. [Codestunts](https://codestunts.com)
  1. [Cryptocurrency Jobs](https://cryptocurrencyjobs.co/remote/) - Location filter -> *Remote*
  1. [Dribbble Jobs](https://dribbble.com/jobs?location=Anywhere)
  1. [Drupal Jobs](https://jobs.drupal.org/home/type/telecommute-remote-3588)
  1. [Europe Remotely](http://europeremotely.com/)
  1. [Find Bacon](https://findbacon.com/jobs/remote)
  1. [Flexjobs](https://www.flexjobs.com/) – Telecommuting Jobs & Professional Part-Time Jobs.
  1. [Front-end Developer Jobs](http://frontenddeveloperjob.com/) - View as table, then sort by `performed`
  1. [Github Jobs](https://jobs.github.com/) - Location filter -> "*Anywhere/Remote*"
  1. [Golangprojects](http://www.golangprojects.com/golang-remote-jobs.html) filter -> Remote only
  1. [Guru](http://www.guru.com/) - (has MANY different categories outside software)
  1. [Hasjob](https://hasjob.co/) – Location filter -> "*Anywhere/Remote*"
  1. [HigherEdJobs](https://www.higheredjobs.com/search/remote.cfm) has remote type filter.
  1. [HN hiring](http://hnhiring.me/) – Filter REMOTE.
  1. [Honestlance](https://www.honestlance.com/)
  1. [Jobbatical](https://jobbatical.com/)
  1. [JOBBOX.io](https://landing.jobs/offers) – Filter -> Remote only.
  1. [Jobspresso](https://jobspresso.co/) * High-quality remote positions that are open and legitimate *
  1. [Landing.jobs](https://landing.jobs/offers) filter -> Remote only
  1. [Larajobs](https://larajobs.com/?location=&remote=1) – The artisan employment connection
  1. [No Fluff Jobs](https://nofluffjobs.com/#criteria=remote) – Filter -> “*remote*”
  1. [NODESK](https://nodesk.co/remote-jobs/)
  1. [remote-jobs](https://github.com/jessicard/remote-jobs) - A list of semi to fully remote-friendly companies in tech
  1. [Remote.co Jobs](https://remote.co/remote-jobs/)
  1. [RemoteBase](https://remotebase.io/) - a searchable collection of remote companies and hiring info
  1. [Remotive Jobs](http://jobs.remotive.io/)
  1. [Skip the Drive](http://www.skipthedrive.com/)
  1. [Stack Overflow Jobs](https://stackoverflow.com/jobs/remote)
  1. [Virtual Vocations](https://www.virtualvocations.com/)
  1. [Vue.js Jobs](https://vuejobs.com/) Find Vue.js jobs all around the world - Click on "Remote" tab.
  1. [React.js Jobs](https://www.react-jobs.com) Find React.js jobs all around the world - Click on "Remote" toggle button.
  1. [We Work Remotely](https://weworkremotely.com/)
  1. [WFH.io](https://www.wfh.io/)
  1. [Workana](https://www.workana.com/) Freelance Job Board in Spanish and Portuguese
  1. [Working Nomads](http://www.workingnomads.co/jobs)

## Job boards aggregators
  1. [Alfred](https://alfred.serafin.io/) - Remote jobs aggregator.
  1. [Google Jobs](https://www.google.com/search?q=remote&ibp=htl;jobs#fpstate=tldetail&htidocid=IO0hI7dpKTSlzSKoAAAAAA%3D%3D&htin=1&htivrt=jobs)  – Aggregates from multiple boards and employer sites with sensitivity to location, job type, and more. Find out how to use it [here](https://support.google.com/websearch/answer/7498276?p=job_search_box&sa=X&ved=0ahUKEwid_qyLmJfXAhVD4YMKHYGBAK8Qra4CCGQoAQ&visit_id=1-636449234996681631-3229288694&rd=1).
  1. [GoRemote.io](https://goremote.io/)
  1. [Remote OK](https://remoteok.io/) - Scrapes many job board feeds for remote positions.
  1. [Remote Python](https://www.remotepython.com/) - Job board and aggregator specifically for remote Python jobs.
  1. [Remotely Awesome Jobs](https://www.remotelyawesomejobs.com/) - Crawls multiple job boards for remote job postings.
  1. [whoishiring.io](https://whoishiring.io/#!/search/19.41/-43.14/2/?remote=true)
  1. [Work Remotely](https://workremotely.io/) - Crawls and curates many job board feeds for remote positions

## Housing
  1. [bedndesk](http://www.bedndesk.com) - Coworking & coliving space in Mallorca island in Spain
  1. [Blackbox](http://blackbox.vc) - Coliving space in Silicon Valley
  1. [Common](https://www.hicommon.com/) - Coliving House in NewYork
  1. [Coworking in the Sun](http://www.coworkinginthesun.com) - Coliving & coworking space in Tenerife island in Spain
  1. [Hive Arena](http://hivearena.com/) - Coworking & Coliving Space in Seoul, South Korea
  1. [HubBOG](http://hubbog.com/) - Coworking Space + Startup Accelerator. Bogota, Colombia
  1. [Hus24](http://hus24.org/en/) - Coliving space in Sweden
  1. [Nest Copenhagen](http://nestcopenhagen.dk) - Coliving space in Copenhagen, Denmark
  1. [NoHatDigital](http://www.nohatdigital.com/mansionpage/) - Coliving space in Mexico
  1. [Nomad House](https://nomadhouse.io) - Global network of nomad housing
  1. [nomadicHUB](http://nomadichub.com) - Coliving & coworking spaces in exotic locations
  1. [Ondas](http://www.ondasmedellin.com) - Coworking space in Medellin, Colombia
  1. [Roam](https://www.roam.co/) - Global network of coliving spaces
  1. [Sende](http://sende.co) - Coliving & coworking space in northern Spain
  1. [Sun Desk](http://sun-desk.com) - Coliving & coworking space in Taghazout, Morocco
  1. [The Surf Office](https://www.thesurfoffice.com/) - Coworking & vacation space in Portugal, Canaries and California
  1. [Work From Curacao](http://www.workfromcuracao.com/) - Coliving space in Curacao
  1. [Worldpackers](https://www.worldpackers.com) - Housing/work exchange


## Interviewing
  1. [andreis/interview](https://github.com/andreis/interview) - Everything you need to kick ass on your coding interview
  2. [awesome-interviews](https://github.com/MaximAbramchuck/awesome-interview-questions) - A curated awesome list of lists of interview questions
  3. [interviewing.io](https://interviewing.io/) - Become awesome at technical interviews
  4. [remoteinterview.io](https://www.remoteinterview.io/) - Coding tests & pair programming interview tools
  5. [skillmeter.com](https://skillmeter.com/) - Online skills testing platform for recruiters & companies
  6. [hackerrank.com](https://www.hackerrank.com/) - Online platform for code studying and recruiting with job offers also

## Events
  1. [deceler8](https://sierraymar.exposure.co/decelerate-bali) - 10 days retreat
  1. [Project Getaway](http://www.projectgetaway.com) - 30 days retreat

## Newsletters
  1. [NODESK](https://nodesk.co/) - A newsletter about digital nomads and remote work that is sent out every two weeks.
  1. [Remote Internships](http://foundersgrid.com/)
  1. [Remote Report](http://remote.report) - A collection of the best remote, support focused and non-technical jobs delivered weekly
  1. [Remoteur](http://www.remoteur.com) - Remote jobs in Europe delivered to your inbox bi-weekly
  1. [Remotive - productive remote workers](http://remotive.io/) - A weekly newsletter on Remote Tips & Jobs sent to 10,000+ Remote Workers
  1. [Working Nomads](http://workingnomads.co/) - Job posts
  1. [Yonder Newsletter](https://yonder.io/newsletter) - Daily remote work tips, links, articles, and the Yonder Podcast

## Podcasts
  1. [Free People Move Podcast](https://teleport.org/podcast/) - mostly interviews with founders attacking the location independence / remote work space from different angles
  1. [Home Work](http://5by5.tv/homework) - A weekly advice podcast for people who work from home. (No longer in production but archive still available)
  1. [Lessons from Distributed Companies](https://www.lullabot.com/podcasts/drupalizeme-podcast/lessons-from-distributed-companies)
  1. [Remote Works](https://remote.works) - The Remote Works podcast publishes every two weeks with host Jonathan Sharp discussing the opportunities, experiences, culture and community surrounding remote work, remote teams, telecommuting and digital nomads.
  1. [The Yonder Podcast](https://www.yonder.io/post?category=Podcast) - Bi-weekly podcast: Jeff Robbins interviews people thinking about distributed teams, remote work, and how to support happy, productive, free-range workers.
  1. [Wide Teams](http://www.wideteams.com) - Each episode a one-on-one interview with a remote worker taking about workflow and practices

## Companies with "remote DNA"
  1. [10up](https://10up.com/careers/) - 10up makes the web better by finely crafting websites & tools for content creators.
  1. [AgentFire](https://agentfire.com/meet-our-team/) - Hyper local real estate websites powered by Wordpress.
  1. [Aha!](https://www.aha.io/company/careers/current-openings) - Aha! is roadmapping software for PMs who want their mojo back.
  1. [AirTreks](https://www.airtreks.com/about/) - Multi-stop international flight planner with a distributed team.
  1. [Ameego](http://ameego.ca/) - Restaurant scheduling software.
  1. [Arkency](http://blog.arkency.com/join-our-team/) - Rails and React.js experts, fully remote/async.
  1. [Articulate](https://articulate.com/company/careers.php) - EdTech. Makes software that helps teachers make e-learning courses. Ruby, Node, C#, and .NET for Windows app.
  1. [AT&T](https://att.jobs) - Nearly [20% of the eligible workforce](https://www.att.com/Common/about_us/files/csr_2012/worklife_balance.pdf) works remotely.
  1. [Auth0](https://auth0.com/jobs) - Zero-friction authentication and authorization for developers.
  1. [Authentic F & F](http://authenticff.com/) - Independent design and technology studio based in Denver and Minnesota
  1. [Aurity](https://www.aurity.co/) - 100% remote company, specializing in React and React Native.
  1. [Automattic](https://automattic.com/work-with-us/) - Makers of WordPress.com and Gravatar
  1. [Avallain](https://www.avallain.com/) - Education Technology and Digital Publishing. We have the tools and processes to achieve the positive impact on human potential that technology enhanced education can provide
  1. [Axelerant](https://www.axelerant.com/careers)
  1. [Baremetrics](https://baremetrics.com/jobs#all) - Analytics and insights for Stripe, Braintree, Recurly and Chargify.
  1. [BaseCamp](http://basecamp.com/about/team) - Project management software.
  1. [Basho](http://bashojobs.theresumator.com) - Creators of Riak, an open source platform and k/v database. We code in Erlang and hang out on clouds. Everyone works remote and gets together a few times a year at HQ in Seattle.
  1. [BeBanjo](http://bebanjo.com/careers/) - Software as a service for managing video on-demand. Ruby / Rails, Elasticsearch, Sidekiq.
  1. [Bluespark Labs](http://www.bluespark.com/work-at-bluespark) - WebDev Consulting and makers of Roomify. Remote team with HQs in Raleigh, NC and Italy. Drupal.
  1. [BookingSync](https://www.bookingsync.com/en/jobs) - Vacation Rental Software for professionals. Fully distributed team, we work remotely and try to make a company retreat each year. Proud Ember.js official sponsor, Ruby / Rails
  1. [Buffer](https://buffer.com/journey/) - Tools to help manage social media. PHP, CodeIgniter, MongoDB, Memcache, Backbone.js, React.js, Grunt.js, LESS, and Python.
  1. [Bugfender](https://bugfender.com/) - Bugfender is a remote logger for multiple platforms including iOS and Android. It stores logs created by your application and sends them to our server, creating a remote console where you can see logs in real time. Remote company based in Barcelona.
  1. [ButterCloud](http://www.buttercloud.com/) - A small team of web & app developers. We help startups & small to medium sized businesses build, maintain, and grow their products.
  1. [Cadasta](http://cadasta.org/about-us/careers/) - Secure platform for mapping global land & resource rights. 100% remote team; Python, Django, JavaScript, PostgreSQL.
  1. [Canonical](https://www.canonical.com/careers/all-vacancies) - Ubuntu.
  1. [Catalyze](https://catalyze.io/jobs) - HIPAA-compliant cloud computing for healthcare. HQ in Madison, WI. Docker, Go, Python.
  1. [Chef](https://www.chef.io/careers/) - We are all about IT automation for speed and awesomeness. Ruby, JavaScript & shell scripting. HQ in Seattle but we have employees all around US.
  1. [Ciao Bambino](http://ciaobambino.com/) - Family destinations and hotel reviews.
  1. [CircleCI](https://circleci.com/jobs#engineer) - Provides continuous integration tools and services.
  1. [Clevertech](https://clevertech.biz/careers) - We build incredible, game changing technology.
  1. [Close.io](http://jobs.close.io) - Inside sales CRM for startups and SMBs.
  1. [Codeship](https://codeship.com/jobs) - SaaS Continuous Delivery
  1. [Collabora](https://www.collabora.com/careers.html) - Open source software-based consulting.
  1. [Collage](http://jobs.collage.com/) - We provide the easiest and most versatile tools to help you turn your photos into memories. 100% remote team.
  1. [Compose](https://www.compose.io/jobs/) - Managing databases as a service. Distributed team with offices in San Meteo, CA and Birmingham, AL.
  1. [Continu](http://www.continu.co/careers/) - Continuous learning software for modern teams.
  1. [Countly](https://count.ly/full-stack-node-js-developer) - Open source, enterprise mobile / web analytics and marketing platform.
  1. [CRO Metrics](http://crometrics.com/jobs/) - Data-driven expirementation and growth programs.
  1. [Crossover](https://app.crossover.com/x/marketplace/available-jobs) - Project-based Java, .Net and DevOps positions.
  1. [Datadog](https://www.datadoghq.com/careers/) - Easy to use and scalable monitoring systems for modern and dynamic infrastructure.  Distributed team with offices in New York, Boston and Paris.  Engineers based all around the world.
  1. [DataStax](http://www.datastax.com/company/careers) - Consulting based on Apache Cassandra.
  1. [Deeson](https://www.deeson.co.uk/careers) - UK-based with European team. Digital agency specialising in Drupal, Symfony and Laravel
  1. [Demio](https://demio.com/inside/) - Webinar platform that just works.
  1. [DigitalOcean](https://www.digitalocean.com/company/careers/) - Simple Cloud Hosting, Built for Developers
  1. [DNSimple](https://dnsimple.com) - Small 100% remote and globally distributed team working to make domain management an afterthought.
  1. [Doist](https://doist.com/jobs/) - Redefining productivity since 2007.
  1. [Dotsub](https://dotsub.com/jobs) - Browser-based platform for subtitling & translating online videos. Java / Spring, JavaScript / React.js
  1. [Doximity](https://www.doximity.com/about/jobs) - Largest online medical network of US physicians. Ruby, Rails, Go, JavaScript, MySQL.
  1. [Drupal Association](https://assoc.drupal.org/jobs) - Non-profit supporting the Drupal project.
  1. [DuckDuckGo](https://duck.co/help/company/hiring) - Search engine.
  1. [EasyCommunicationTechnology](https://www.easycomtec.com/homeoffice/developer) - .NET development using C#, Angular, Azure. Remote-first company. 
  1. [Elastic](https://www.elastic.co/) - Open source search & analytics
  1. [Envato](https://envato.com/careers) - Maker of ThemeForest and other online marketplaces. MySQL, Ruby, Rails, Javascript. Distributed team with HQ in Melbourne, Australia.
  1. [Etsy](https://www.etsy.com/careers) - Marketplace for artists. MySQL, Memcache, PHP. Offices in Dublin, Paris, San Francisco, New York, London and Melbourne.
  1. [Eyeo](https://eyeo.com/en/jobs/) - Maker of AdBlock Plus. Main office in Cologne, Germany.
  1. [Findify](https://findify.io/careers/) - E-commerce search powered by machine learning and big data. Team distributed across Europe.
  1. [Fire Engine RED](http://fire-engine-red.com/about/#careers) - SaaS for higher education. Maker of Fireworks.
  1. [Fog Creek](http://www.fogcreek.com/careers/) - NY-based software company. Makers of bug-tracking and source control tools. Workday must overlap New York afternoons (1700 - 2200 GMT)
  1. [General Assembly](https://generalassemb.ly/careers) - Physical and on-line education for technology, business, and design.
  1. [Ghost](https://ghost.org/about/#careers) - Publishing platform.
  1. [Gigster](https://gigster.com/) - vetted network of top 5% freelancers worldwide. PM, Dev, Sales positions available.
  1. [Gitbook](http://jobs.gitbook.com/) - Publishing toolchain based on git. Javascript, node.js, Go.
  1. [GitHub](https://github.com/about/jobs)
  1. [GitLab](https://about.gitlab.com/jobs/) - Competitor to GitHub.
  1. [GlueNetworks](http://gluenetworks.com/) - Network automation company.
  1. [Gradle](https://gradle.com/careers) - Open Source Build Tool ; Enterprise SaaS and on-premise. Fully remote. Java, Groovy, Kotlin.
  1. [GrooveHQ](https://www.groovehq.com/about) - Help desk software.
  1. [Hanzo](https://www.hanzo.co/about-us/careers-uk) - Web archiving company. Fully Remote. Python, AWS.
  1. [Harvest](https://www.getharvest.com/careers) - Time tracking software.
  1. [HashiCorp](https://www.hashicorp.com/jobs.html) - Open source tools for automating the modern data center. Go, Ruby, Rails, Ember, JavaScript.
  1. [HE:labs](https://helabs.com/us/)
  1. [Healthfinch](http://www.healthfinch.com/careers/) - Making Healthcare systems more usable. HQ in Madison, WI, USA. Ruby, Javascript.
  1. [Heap](https://heapanalytics.com/jobs) – Web & Mobile Analytics, 2 of our 8 teammates are remote.
  1. [Help Scout](https://www.helpscout.net/careers/) - A help desk for teams that insist on a delightful customer experience.
  1. [Heroku](https://www.heroku.com/careers) - PaaS Cloud, makes devs' experience awesome, Ruby, Erlang, Javascript, Golang, Python.
  1. [Honeybadger](https://www.honeybadger.io/) - Ruby. 100% remote.
  1. [Hotjar](https://careers.hotjar.com/) - Analytics & Feedback tool.
  1. [Hubstaff](https://hubstaff.com/jobs) - Time tracking solution with multiple integrations.
  1. [Igalia](https://www.igalia.com/about-us/form) - Open source consultancy. HQ in Spain.
  1. [Incsub](http://incsub.com/careers/) - Remote team that builds Wordpress projects.
  1. [Inpsyde GmbH](https://inpsyde.com/) - WordPress Agency in Germany.
  1. [Institute for Nonprofit News](https://inn.org/about/jobs/) - Nonprofit news organization.
  1. [Instructure](https://www.instructure.com/careers/) - We make software that makes people smarter.
  1. [Intellum](http://intellum.com/) - We build employee collaboration, performance and learning tools. Ruby, iOS, Android, AWS, GCS.
  1. [InVision](https://www.invisionapp.com/company#jobs) - prototyping, collaboration & workflow platform.
  1. [Jackson River](https://www.jacksonriver.com/about/jobs) - Digital-first technology and strategy for nonprofits.
  1. [Khan Academy](https://www.khanacademy.org/careers) - EdTech. Non-profit focusing on K-12 STEM. Less, React, Flux, Backbone, jQuery, Python, Google App Engine, Swift, and Objective-C.
  1. [LaterPay](https://www.laterpay.net/) - The (micro)payment enabler. Munich, Germany. Python, JavaScript, AWS.
  1. [LaunchPotato](http://launchpotato.com/careers) - Startup studio based in Delray Beach, Florida.
  1. [Librato](http://solarwinds.jobs/solarwinds-cloud/) - Cloud Monitoring.
  1. [Linaro](https://www.linaro.org/careers/) - OpenSource Engineering on ARM.
  1. [Lincoln Loop](https://lincolnloop.com) - WebDev shop.
  1. [Litmus](https://litmus.com/careers) - Optimization tools for email professionals. Offices in Boston and London, but nearly 50% of the team works remotely.
  1. [LivingSocial](https://jobs.groupon.com/) - Company-wide support for teams of experienced, remote developers. Lots of autonomy.
  1. [Lullabot](https://www.lullabot.com/jobs) - Strategy, design and development using Drupal.
  1. [Maintainer Mountaineer](https://maintainer.io) - Open source community management as a service.
  1. [MariaDB](https://mariadb.com/about-us/careers) - Open source database.
  1. [MarsBased](https://marsbased.com) - Design & development consultancy from Barcelona, providing hieh-end Ruby on Rails & Javascript mobile and web applications.
  1. [Mapbox](https://www.mapbox.com/jobs/) - Map integration tools for various platforms.
  1. [MCFTech](https://www.mcftech.com/careers/) - Applications to help you run your business succesfully.
  1. [MeetEdgar](https://meetedgar.com/careers/) - Automated social sharing. US remote.
  1. [Mobile Jazz](https://mobilejazz.com/) - We are a dedicated team of highly-skilled engineers, designers and marketing experts on a mission to build a more beautiful digital world. We are a remote friendly company with headquarters in Barcelona.
  1. [Modern Tribe](http://tri.be/about/join-our-team/) - A digital agency with a modern twist. All freelancers. All experts.
  1. [Modus Create](https://moduscreate.com/) - Modus is a digital design-build agency driven by world-class talent. PHP, Javascript.
  1. [Mosalingua](https://www.mosalingua.com/en/jobs/) - Learn words, enjoy the world.
  1. [Mozilla](https://careers.mozilla.org/listings/) - Firefox has a 'Remote' option under it's location searchbar
  1. [Nectafy](http://nectafy.com/jobs/) - Inbound marketing and content creation.
  1. [Netsparker](https://www.netsparker.com/jobs/) - Web Application Security Scanner.
  1. [Next Big Sound](https://www.nextbigsound.com/about) - Analytics and Insights for the Music Industry.
  1. [Niteoweb](https://www.niteoweb.com/careers) - Employing tech enthusiasts from all over the world who love to build cool stuff.
  1. [NodeSource](https://nodesource.com/about) - NodeSource is dedicated to creating a sustainable ecosystem for Node.js.
  1. [Olark](https://www.olark.com/jobs) - Chat support funnel.
  1. [onTheGo Systems](https://www.onthegosystems.com/jobs/) - WordPress Developer, Supporter and Marketing Jobs.
  1. [Onyo](http://www.onyo.com) - Transforming the eating out experience in pure pleasure.
  1. [OpenCraft](http://opencraft.com/) - Open edX development (Free Software MOOC project).
  1. [Owsy](http://owsy.com/careers/) - International studio focused on creating products for financial service firms.
  1. [Parsely](http://www.parsely.com/jobs/) - Analytics solutions
  1. [Particular Software (NServiceBus)](https://particular.net/careers) - Enterprise Service Bus, Messaging, C#, Open Source
  1. [Patients Know Best](https://patients.workable.com/) - Empowering patients to manage their care, enabling professionals to share information while improving efficiencies for payers.
  1. [Paylocity](http://www.paylocity.com/careers/) - HR and payroll solutions
  1. [Pilot](https://pilot.co) - Pilot is a software platform that removes all the pain from contract work. We find work, negotiate contracts, send invoices and chase payments for hundreds of forward-looking engineers and designers around the world.
  1. [Precision Nutrition](http://www.precisionnutrition.com/) -  Online Nutrition Coaching and Certification.
  1. [PreviousNext](https://www.previousnext.com.au) - Australian based Drupal agency.
  1. [Prezly](https://www.prezly.com/) - SaaS PR platform. PHP, React, JS, Postgres. 100% remote.
  1. [RainforestQA](https://www.rainforestqa.com/jobs/) - On demand QA as a service.
  1. [Reaction Commerce](https://reactioncommerce.com/careers/) - Fastest-growing open source ecommerce platform. Node.js, MongoDB, Kubernetes, Docker.
  1. [Real HQ](https://realhq.com) - Maker of Agent Pronto, software designed to help make home buying and selling a better experience. We've been remote since the start, now 50+ spread across the globe. Ruby, Rails, React.js, iOS/Android.
  1. [RebelMouse](https://blog.rebelmouse.com/careers/) - Social publishing platform. Python, JS & iOS/Android developers. All over the world team.
  1. [Recurly](https://recurly.com/jobs/) - recurring billing management for subscription-based businesses
  1. [Red Hat](http://jobs.redhat.com/)
  1. [RightScale](http://www.rightscale.com/jobs)
  1. [Sangoma](http://www.sangoma.com) - Trusted leader in delivering globally scalable Voice-Over-IP telephony systems, both on-site and cloud-based. C, PHP, Python, JavaScript, Linux, FreePBX, VoIP.
  1. [Scrapinghub](https://scrapinghub.com/jobs)
  1. [ServiceNow](http://jobs.jobvite.com/servicenow/search?c=&l=&r=&t=&q=remote) - Enterprise cloud computing to improve service levels, energize employees, and change the way your enterprise works. Work at lightspeed.
  1. [ShakaCode](http://www.shakacode.com/about/index.html#work-with-us) - A global web development software consultancy and product company.
  1. [Simple](https://www.simple.com/careers)
  1. [Skyscrapers](http://skyscrapers.eu/jobs/) - Cloud hosting services & management. Working with multiple cloud providers (AWS, Digital Ocean, Linode, ...). 100% remote.
  1. [SoftwareMill](https://softwaremill.com/join-us/)
  1. [Songspace](https://songspace.com) Helps music creators collaborate, catalog, and share work with their professional team
  1. [Soostone](http://www.soostone.com/careers)
  1. [Spreaker](https://www.spreaker.com/jobs) Discover and listen to your favorite podcasts.
  1. [StackExchange](http://stackexchange.com/work-here)
  1. [Strongloop](https://strongloop.com/careers/)
  1. [Student Loan Hero](https://studentloanhero.com/careers/) - 100% remote company on a mission to help 44 million Americans manage and repay over $1.4 trillion in student loan
  1. [StyleSeat](http://static.styleseat.com/jobs/index.html) - we love high-impact remote engineers, collaboration, creativity, python, angularjs
  1. [Surevine](https://www.surevine.com/jobs/)
  1. [Surge](http://www.surgeforward.com/careers/) - 100% remote consulting company working primarily in Node.JS, iOS, .NET, PHP, and Android
  1. [Sysdig Cloud](https://sysdig.com/jobs/)
  1. [TaxJar](https://www.taxjar.com/jobs/) - Eliminate sales tax headaches.
  1. [Teamed.io](http://www.teamed.io/)
  1. [TeamSnap](https://www.teamsnap.com/about/careers) - TeamSnap is the No. 1 online sports team management software. 80% remote employees
  1. [TED](http://www.ted.com/about/our-organization/jobs-at-ted) - Technology team supports ted.com and internal tools. All engineers are remote. Ruby on Rails, JavaScript, Ember.js
  1. [Teleport](https://teleport.org/jobs/)
  1. [Tesera](https://tesera.com/) - We disrupt conventional thinking to expand what is possible. We ignite change in the future we share.
  1. [The Grid](http://thegrid.io/) - AI website builder. 100% distributed team.
  1. [Thermeon](http://thermeon.com/jobs.html) - Car rental software - 100% remote technical team
  1. [TimeDoctor](https://www.timedoctor.com/about-us.html) - Time tracking with screenshots, web and app usage monitoring, and integrations.
  1. [TimeSpot](https://timespothq.com/careers/) - Time tracking and scheduling for employees. Built with React.js, Django, Postgres. 100% remote.
  1. [Tipe](https://tipe.io) - Next Generation API-first CMS with GraphQL or REST API. Built with Nuxt.js, Serverless, AWS. 25% remote
  1. [Toggl](https://jobs.toggl.com/)
  1. [Toptal](https://www.toptal.com/careers) - 100% remote development company, solving worldwide talent shortage
  1. [Tortuga Backpacks](https://www.tortugabackpacks.com/pages/join) - Backpacks for city travel.
  1. [Trello](https://trello.com/jobs)
  1. [Twin Technologies](http://twintechs.com/about-twin/careers)
  1. [Vidalingua](http://www.vidalingua.com/amaze.php) - Bringing language apps to life.
  1. [Walltime](https://walltime.info) - A Brazilian digital assets exchange and other products & services using Blockchain technology.
  1. [Water Lily Pond](http://waterlilypond.co.uk/) - Advertising and marketing communication services.
  1. [wemake.services](https://wemake.services/meta/employees) - We sell repeatable software development process. Fully remote. Python, Javascript, Vue
  1. [Wikimedia](https://wikimediafoundation.org/wiki/Work_with_us)
  1. [WorkFront](https://www.workfront.com/careers/) - Online proofing solution. PHP, JavaScript, Java, .NET, MySQL, Redis
  1. [X-Team](https://x-team.com/join/) - Work on incredible web and mobile projects, with extraordinary developers. Unleash your potential. From anywhere. We are X-Team.
  1. [You Need a Budget](https://www.youneedabudget.com/jobs/) - Bank syncing and goals and debt management.
  1. [YourSports](https://www.yoursports.com/jobs) - A social network for your favorite teams.
  1. [Zamphyr](https://zamphyr.com/posao/) - School 2.0 for learning computer science. Remote-first, 100% JavaScript mostly Meteor.
  1. [Zapier](https://zapier.com/about/)
  1. [ZipRecruiter](https://www.ziprecruiter.com/careers) - Perl/Catalyst shop that has some of the best Perl devs working remotely.

## Q&A
  1. Chegg Tutor: [Online tutoring jobs starting at $20+/hour](https://www.chegg.com/tutors/become-a-tutor/)
  1. Quora: [Telecommuting and Working Remotely](http://www.quora.com/Telecommuting-and-Working-Remotely) / [Virtual Workplace](http://www.quora.com/Virtual-Workplace) / [Working at Home](http://www.quora.com/Working-at-Home)
  1. Remote.co: [Q&A's with 90+ Remote Companies](https://remote.co/qa-leading-remote-companies/)
  1. StackExchange
    - Workplace: [telecommute](http://workplace.stackexchange.com/questions/tagged/telecommute?sort=votes)
    - Freelancing: [remote](http://freelancing.stackexchange.com/questions/tagged/remote?sort=votes) / [working from home](http://freelancing.stackexchange.com/questions/tagged/working-from-home?sort=votes)
    - Programmers: [telecommuting](http://programmers.stackexchange.com/questions/tagged/telecommuting?sort=votes) / [home](http://programmers.stackexchange.com/questions/tagged/home?sort=votes)

## Communities
1. [/r/telecommuting](https://www.reddit.com/r/telecommuting/) - Subreddit.
1. [##remotes](https://github.com/remotesclub/remotes) - IRC channel ([web access](http://webchat.freenode.net/?channels=##remotes))
1. [Hacker Paradise](http://www.hackerparadise.org/) - Traveling remote workers.
1. [Remote Year](http://www.remoteyear.com/) - Traveling techies for 1 year.

## Conferences
 1. [DNX Global](http://www.dnxglobal.com/) - Digital Nomad Conference.
 1. [Out Of Office](http://www.outofoffice.hm/) - Online remote work event by [Human Made](https://hmn.md/)
 1. [Remote Working Conference](http://remoteworkingconf.com/) - Remote conference about remote working
 1. [Yonder](http://www.yonder.io/events/) - A round table conference bringing together leaders of distributed companies.
 1. [9punto5](http://www.9punto5.cl) - Remote work conference in Latin America.

## Tools
#### Communication
  1. [Appear.in](https://appear.in) – Browser-based, plugin-less group video calls.
  1. [Bluejeans](https://bluejeans.com/) video conferencing app, great for large groups & live streams
  1. [Codeshare.io](https://codeshare.io/) – Browser-based multi-user live code sharing with optional video chat.
  1. [Fleep](https://fleep.io/) - Internal chat and collaboration tool for development teams
  1. [Floobits](https://floobits.com) - Remote pair programming with screen share. Integrates with Sublime, IntelliJ, Atom and others
  1. [Flowdock](https://www.flowdock.com/) – Browser-based group chat for teams. Integrates with GitHub, Jira, Jenkins etc.
  1. [Hangouts](http://www.google.com/+/learnmore/hangouts/) – Chat system, share desktop and video calls.
  1. [Hipchat](https://www.hipchat.com/) – Great internal chat for hackers.
  1. [IRCCloud](https://www.irccloud.com) – Browser-based IRC client with permanent storage.
  1. [Mumble](https://wiki.mumble.info/) Mumble is an open source voice chat software
  1. [Precursor](https://precursorapp.com) - Simple prototyping & brainstorming web app with real-time collaboration.
  1. [PukkaTeam](https://www.pukkateam.com) - Real team presence through regular automated selfies and one-click video calling
  1. [Rocket.Chat](https://rocket.chat/) — The Ultimate Open Source WebChat Platform.
  1. [ScreenHero](https://screenhero.com) - Real-time, HD screen sharing for collaboration in teams.
  2. [Signal](https://signal.org/) - Encrypted, secure chat and video calls.
  1. [Skype](https://www.skype.com/) – Video calls.
  1. [Slack](https://slack.com/) – Chat system with loads of integration options.
  1. [Talky](https://talky.io/) — Truly simple video chat and screen sharing for groups
  1. [Zoom](https://zoom.us) — High-quality group video and sharing screen, run on linux, record session and support telephone calls.

#### Project Management
  1. [Asana](https://asana.com/) - Project management good for distributed teams.
  1. [Harvest](https://www.getharvest.com/) - Time tracking
  1. [Hitask](https://hitask.com/) - Easy task and project management for teams.
  1. [Pinitto.me](https://pinitto.me) - Lightweight realtime infinite virtual corkboard application (open source).
  1. [Trello](https://trello.com/) - Lean project boards.

#### Others
  1. [Coffitivity](https://coffitivity.com/) - Coffitivity recreates the ambient sounds of a cafe to boost your creativity and help you work better.
  1. [Funretro](https://funretro.github.io/distributed) - Funretro is a retrospective online board for distributed teams.
  1. [Noisli](https://www.noisli.com/) - Noisli has a list of diferent ambient sounds that can be combined to boost creativity and focus.
  1. [Qbserve](https://qotoqot.com/qbserve/) - Time tracking automation: freelance project tracking, timesheets, invoicing & real-time productivity feedback (Mac).
  1. [Teleport Sundial](https://sundial.teleport.org) - Manage the locations and timezones of your distributed team.
  1. [Timing](https://timingapp.com/) - Automatic time and productivity tracking for Mac. Helps you stay on track with your work (especially important when working remotely). Also ensures that no billable hours get lost if you are billing hourly (Mac).

## Law & Finance
  1. [1099 contractors](http://www.wisegeek.com/what-is-a-1099-contractor.htm) – US based companies can hire remote workers as.

## Others
  1. [awesome-digital-nomads](https://github.com/cbovis/awesome-digital-nomads) - 🏝 A curated list of awesome resources for Digital Nomads.
  1. [Hacker Spaces](https://wiki.hackerspaces.org/List_of_Hacker_Spaces) - List of hacker spaces.
  1. [LiquidSpace](https://liquidspace.com/) - Daily & Hourly Office & Meeting Room Rental.
  1. [NODESK](https://nodesk.co/) - 3000+ articles, remote jobs, resources and tools for digital nomads and remote workers.
  1. [Nomad List](https://nomadlist.io/) - Compare cost and quality of living in different cities.
  1. [Regus USA](http://www.regus.com/) - Executive suites, virtual offices & conference room space.
  1. [Remote Companies on Careers SO](http://talent.stackoverflow.com/companies?searchTerm=&location=&allowsremote=true)
  1. [Remote Working](https://github.com/greatghoul/remote-working) - A list of remote working resources for Chinese.
  1. [The Caravanserai](http://www.thecaravanserai.co/) - Co-living provider.
  1. [WorkFrom](https://workfrom.co/) - Find coffee shops that are good to work from.

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, [Lukasz Madon](https://github.com/lukasz-madon) has waived all copyright and related or neighboring rights to this work.
