// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package filter

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateFilterBackendCreatedCode is the HTTP code returned for type CreateFilterBackendCreated
const CreateFilterBackendCreatedCode int = 201

/*
CreateFilterBackendCreated Filter created

swagger:response createFilterBackendCreated
*/
type CreateFilterBackendCreated struct {

	/*
	  In: Body
	*/
	Payload *models.Filter `json:"body,omitempty"`
}

// NewCreateFilterBackendCreated creates CreateFilterBackendCreated with default headers values
func NewCreateFilterBackendCreated() *CreateFilterBackendCreated {

	return &CreateFilterBackendCreated{}
}

// WithPayload adds the payload to the create filter backend created response
func (o *CreateFilterBackendCreated) WithPayload(payload *models.Filter) *CreateFilterBackendCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create filter backend created response
func (o *CreateFilterBackendCreated) SetPayload(payload *models.Filter) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateFilterBackendCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateFilterBackendAcceptedCode is the HTTP code returned for type CreateFilterBackendAccepted
const CreateFilterBackendAcceptedCode int = 202

/*
CreateFilterBackendAccepted Configuration change accepted and reload requested

swagger:response createFilterBackendAccepted
*/
type CreateFilterBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.Filter `json:"body,omitempty"`
}

// NewCreateFilterBackendAccepted creates CreateFilterBackendAccepted with default headers values
func NewCreateFilterBackendAccepted() *CreateFilterBackendAccepted {

	return &CreateFilterBackendAccepted{}
}

// WithReloadID adds the reloadId to the create filter backend accepted response
func (o *CreateFilterBackendAccepted) WithReloadID(reloadID string) *CreateFilterBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create filter backend accepted response
func (o *CreateFilterBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create filter backend accepted response
func (o *CreateFilterBackendAccepted) WithPayload(payload *models.Filter) *CreateFilterBackendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create filter backend accepted response
func (o *CreateFilterBackendAccepted) SetPayload(payload *models.Filter) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateFilterBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateFilterBackendBadRequestCode is the HTTP code returned for type CreateFilterBackendBadRequest
const CreateFilterBackendBadRequestCode int = 400

/*
CreateFilterBackendBadRequest Bad request

swagger:response createFilterBackendBadRequest
*/
type CreateFilterBackendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateFilterBackendBadRequest creates CreateFilterBackendBadRequest with default headers values
func NewCreateFilterBackendBadRequest() *CreateFilterBackendBadRequest {

	return &CreateFilterBackendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create filter backend bad request response
func (o *CreateFilterBackendBadRequest) WithConfigurationVersion(configurationVersion string) *CreateFilterBackendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create filter backend bad request response
func (o *CreateFilterBackendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create filter backend bad request response
func (o *CreateFilterBackendBadRequest) WithPayload(payload *models.Error) *CreateFilterBackendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create filter backend bad request response
func (o *CreateFilterBackendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateFilterBackendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateFilterBackendConflictCode is the HTTP code returned for type CreateFilterBackendConflict
const CreateFilterBackendConflictCode int = 409

/*
CreateFilterBackendConflict The specified resource already exists

swagger:response createFilterBackendConflict
*/
type CreateFilterBackendConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateFilterBackendConflict creates CreateFilterBackendConflict with default headers values
func NewCreateFilterBackendConflict() *CreateFilterBackendConflict {

	return &CreateFilterBackendConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create filter backend conflict response
func (o *CreateFilterBackendConflict) WithConfigurationVersion(configurationVersion string) *CreateFilterBackendConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create filter backend conflict response
func (o *CreateFilterBackendConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create filter backend conflict response
func (o *CreateFilterBackendConflict) WithPayload(payload *models.Error) *CreateFilterBackendConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create filter backend conflict response
func (o *CreateFilterBackendConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateFilterBackendConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateFilterBackendDefault General Error

swagger:response createFilterBackendDefault
*/
type CreateFilterBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateFilterBackendDefault creates CreateFilterBackendDefault with default headers values
func NewCreateFilterBackendDefault(code int) *CreateFilterBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateFilterBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create filter backend default response
func (o *CreateFilterBackendDefault) WithStatusCode(code int) *CreateFilterBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create filter backend default response
func (o *CreateFilterBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create filter backend default response
func (o *CreateFilterBackendDefault) WithConfigurationVersion(configurationVersion string) *CreateFilterBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create filter backend default response
func (o *CreateFilterBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create filter backend default response
func (o *CreateFilterBackendDefault) WithPayload(payload *models.Error) *CreateFilterBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create filter backend default response
func (o *CreateFilterBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateFilterBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
