// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_check

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteHTTPCheckDefaultsAcceptedCode is the HTTP code returned for type DeleteHTTPCheckDefaultsAccepted
const DeleteHTTPCheckDefaultsAcceptedCode int = 202

/*
DeleteHTTPCheckDefaultsAccepted Configuration change accepted and reload requested

swagger:response deleteHttpCheckDefaultsAccepted
*/
type DeleteHTTPCheckDefaultsAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteHTTPCheckDefaultsAccepted creates DeleteHTTPCheckDefaultsAccepted with default headers values
func NewDeleteHTTPCheckDefaultsAccepted() *DeleteHTTPCheckDefaultsAccepted {

	return &DeleteHTTPCheckDefaultsAccepted{}
}

// WithReloadID adds the reloadId to the delete Http check defaults accepted response
func (o *DeleteHTTPCheckDefaultsAccepted) WithReloadID(reloadID string) *DeleteHTTPCheckDefaultsAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete Http check defaults accepted response
func (o *DeleteHTTPCheckDefaultsAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteHTTPCheckDefaultsAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteHTTPCheckDefaultsNoContentCode is the HTTP code returned for type DeleteHTTPCheckDefaultsNoContent
const DeleteHTTPCheckDefaultsNoContentCode int = 204

/*
DeleteHTTPCheckDefaultsNoContent HTTP check deleted

swagger:response deleteHttpCheckDefaultsNoContent
*/
type DeleteHTTPCheckDefaultsNoContent struct {
}

// NewDeleteHTTPCheckDefaultsNoContent creates DeleteHTTPCheckDefaultsNoContent with default headers values
func NewDeleteHTTPCheckDefaultsNoContent() *DeleteHTTPCheckDefaultsNoContent {

	return &DeleteHTTPCheckDefaultsNoContent{}
}

// WriteResponse to the client
func (o *DeleteHTTPCheckDefaultsNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteHTTPCheckDefaultsNotFoundCode is the HTTP code returned for type DeleteHTTPCheckDefaultsNotFound
const DeleteHTTPCheckDefaultsNotFoundCode int = 404

/*
DeleteHTTPCheckDefaultsNotFound The specified resource was not found

swagger:response deleteHttpCheckDefaultsNotFound
*/
type DeleteHTTPCheckDefaultsNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteHTTPCheckDefaultsNotFound creates DeleteHTTPCheckDefaultsNotFound with default headers values
func NewDeleteHTTPCheckDefaultsNotFound() *DeleteHTTPCheckDefaultsNotFound {

	return &DeleteHTTPCheckDefaultsNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete Http check defaults not found response
func (o *DeleteHTTPCheckDefaultsNotFound) WithConfigurationVersion(configurationVersion string) *DeleteHTTPCheckDefaultsNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete Http check defaults not found response
func (o *DeleteHTTPCheckDefaultsNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete Http check defaults not found response
func (o *DeleteHTTPCheckDefaultsNotFound) WithPayload(payload *models.Error) *DeleteHTTPCheckDefaultsNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete Http check defaults not found response
func (o *DeleteHTTPCheckDefaultsNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteHTTPCheckDefaultsNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteHTTPCheckDefaultsDefault General Error

swagger:response deleteHttpCheckDefaultsDefault
*/
type DeleteHTTPCheckDefaultsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteHTTPCheckDefaultsDefault creates DeleteHTTPCheckDefaultsDefault with default headers values
func NewDeleteHTTPCheckDefaultsDefault(code int) *DeleteHTTPCheckDefaultsDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteHTTPCheckDefaultsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete HTTP check defaults default response
func (o *DeleteHTTPCheckDefaultsDefault) WithStatusCode(code int) *DeleteHTTPCheckDefaultsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete HTTP check defaults default response
func (o *DeleteHTTPCheckDefaultsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete HTTP check defaults default response
func (o *DeleteHTTPCheckDefaultsDefault) WithConfigurationVersion(configurationVersion string) *DeleteHTTPCheckDefaultsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete HTTP check defaults default response
func (o *DeleteHTTPCheckDefaultsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete HTTP check defaults default response
func (o *DeleteHTTPCheckDefaultsDefault) WithPayload(payload *models.Error) *DeleteHTTPCheckDefaultsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete HTTP check defaults default response
func (o *DeleteHTTPCheckDefaultsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteHTTPCheckDefaultsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
