// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package server

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceRuntimeServerOKCode is the HTTP code returned for type ReplaceRuntimeServerOK
const ReplaceRuntimeServerOKCode int = 200

/*
ReplaceRuntimeServerOK Server transient settings replaced

swagger:response replaceRuntimeServerOK
*/
type ReplaceRuntimeServerOK struct {

	/*
	  In: Body
	*/
	Payload *models.RuntimeServer `json:"body,omitempty"`
}

// NewReplaceRuntimeServerOK creates ReplaceRuntimeServerOK with default headers values
func NewReplaceRuntimeServerOK() *ReplaceRuntimeServerOK {

	return &ReplaceRuntimeServerOK{}
}

// WithPayload adds the payload to the replace runtime server o k response
func (o *ReplaceRuntimeServerOK) WithPayload(payload *models.RuntimeServer) *ReplaceRuntimeServerOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace runtime server o k response
func (o *ReplaceRuntimeServerOK) SetPayload(payload *models.RuntimeServer) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceRuntimeServerOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceRuntimeServerBadRequestCode is the HTTP code returned for type ReplaceRuntimeServerBadRequest
const ReplaceRuntimeServerBadRequestCode int = 400

/*
ReplaceRuntimeServerBadRequest Bad request

swagger:response replaceRuntimeServerBadRequest
*/
type ReplaceRuntimeServerBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceRuntimeServerBadRequest creates ReplaceRuntimeServerBadRequest with default headers values
func NewReplaceRuntimeServerBadRequest() *ReplaceRuntimeServerBadRequest {

	return &ReplaceRuntimeServerBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace runtime server bad request response
func (o *ReplaceRuntimeServerBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceRuntimeServerBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace runtime server bad request response
func (o *ReplaceRuntimeServerBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace runtime server bad request response
func (o *ReplaceRuntimeServerBadRequest) WithPayload(payload *models.Error) *ReplaceRuntimeServerBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace runtime server bad request response
func (o *ReplaceRuntimeServerBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceRuntimeServerBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceRuntimeServerNotFoundCode is the HTTP code returned for type ReplaceRuntimeServerNotFound
const ReplaceRuntimeServerNotFoundCode int = 404

/*
ReplaceRuntimeServerNotFound The specified resource was not found

swagger:response replaceRuntimeServerNotFound
*/
type ReplaceRuntimeServerNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceRuntimeServerNotFound creates ReplaceRuntimeServerNotFound with default headers values
func NewReplaceRuntimeServerNotFound() *ReplaceRuntimeServerNotFound {

	return &ReplaceRuntimeServerNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace runtime server not found response
func (o *ReplaceRuntimeServerNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceRuntimeServerNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace runtime server not found response
func (o *ReplaceRuntimeServerNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace runtime server not found response
func (o *ReplaceRuntimeServerNotFound) WithPayload(payload *models.Error) *ReplaceRuntimeServerNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace runtime server not found response
func (o *ReplaceRuntimeServerNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceRuntimeServerNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceRuntimeServerDefault General Error

swagger:response replaceRuntimeServerDefault
*/
type ReplaceRuntimeServerDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceRuntimeServerDefault creates ReplaceRuntimeServerDefault with default headers values
func NewReplaceRuntimeServerDefault(code int) *ReplaceRuntimeServerDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceRuntimeServerDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace runtime server default response
func (o *ReplaceRuntimeServerDefault) WithStatusCode(code int) *ReplaceRuntimeServerDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace runtime server default response
func (o *ReplaceRuntimeServerDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace runtime server default response
func (o *ReplaceRuntimeServerDefault) WithConfigurationVersion(configurationVersion string) *ReplaceRuntimeServerDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace runtime server default response
func (o *ReplaceRuntimeServerDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace runtime server default response
func (o *ReplaceRuntimeServerDefault) WithPayload(payload *models.Error) *ReplaceRuntimeServerDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace runtime server default response
func (o *ReplaceRuntimeServerDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceRuntimeServerDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
