// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package server_template

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteServerTemplateAcceptedCode is the HTTP code returned for type DeleteServerTemplateAccepted
const DeleteServerTemplateAcceptedCode int = 202

/*
DeleteServerTemplateAccepted Configuration change accepted and reload requested

swagger:response deleteServerTemplateAccepted
*/
type DeleteServerTemplateAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteServerTemplateAccepted creates DeleteServerTemplateAccepted with default headers values
func NewDeleteServerTemplateAccepted() *DeleteServerTemplateAccepted {

	return &DeleteServerTemplateAccepted{}
}

// WithReloadID adds the reloadId to the delete server template accepted response
func (o *DeleteServerTemplateAccepted) WithReloadID(reloadID string) *DeleteServerTemplateAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete server template accepted response
func (o *DeleteServerTemplateAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteServerTemplateAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteServerTemplateNoContentCode is the HTTP code returned for type DeleteServerTemplateNoContent
const DeleteServerTemplateNoContentCode int = 204

/*
DeleteServerTemplateNoContent Server template deleted

swagger:response deleteServerTemplateNoContent
*/
type DeleteServerTemplateNoContent struct {
}

// NewDeleteServerTemplateNoContent creates DeleteServerTemplateNoContent with default headers values
func NewDeleteServerTemplateNoContent() *DeleteServerTemplateNoContent {

	return &DeleteServerTemplateNoContent{}
}

// WriteResponse to the client
func (o *DeleteServerTemplateNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteServerTemplateNotFoundCode is the HTTP code returned for type DeleteServerTemplateNotFound
const DeleteServerTemplateNotFoundCode int = 404

/*
DeleteServerTemplateNotFound The specified resource was not found

swagger:response deleteServerTemplateNotFound
*/
type DeleteServerTemplateNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteServerTemplateNotFound creates DeleteServerTemplateNotFound with default headers values
func NewDeleteServerTemplateNotFound() *DeleteServerTemplateNotFound {

	return &DeleteServerTemplateNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete server template not found response
func (o *DeleteServerTemplateNotFound) WithConfigurationVersion(configurationVersion string) *DeleteServerTemplateNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete server template not found response
func (o *DeleteServerTemplateNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete server template not found response
func (o *DeleteServerTemplateNotFound) WithPayload(payload *models.Error) *DeleteServerTemplateNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete server template not found response
func (o *DeleteServerTemplateNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteServerTemplateNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteServerTemplateDefault General Error

swagger:response deleteServerTemplateDefault
*/
type DeleteServerTemplateDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteServerTemplateDefault creates DeleteServerTemplateDefault with default headers values
func NewDeleteServerTemplateDefault(code int) *DeleteServerTemplateDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteServerTemplateDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete server template default response
func (o *DeleteServerTemplateDefault) WithStatusCode(code int) *DeleteServerTemplateDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete server template default response
func (o *DeleteServerTemplateDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete server template default response
func (o *DeleteServerTemplateDefault) WithConfigurationVersion(configurationVersion string) *DeleteServerTemplateDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete server template default response
func (o *DeleteServerTemplateDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete server template default response
func (o *DeleteServerTemplateDefault) WithPayload(payload *models.Error) *DeleteServerTemplateDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete server template default response
func (o *DeleteServerTemplateDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteServerTemplateDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
