// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package tcp_check

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetTCPCheckDefaultsOKCode is the HTTP code returned for type GetTCPCheckDefaultsOK
const GetTCPCheckDefaultsOKCode int = 200

/*
GetTCPCheckDefaultsOK Successful operation

swagger:response getTcpCheckDefaultsOK
*/
type GetTCPCheckDefaultsOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.TCPCheck `json:"body,omitempty"`
}

// NewGetTCPCheckDefaultsOK creates GetTCPCheckDefaultsOK with default headers values
func NewGetTCPCheckDefaultsOK() *GetTCPCheckDefaultsOK {

	return &GetTCPCheckDefaultsOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get Tcp check defaults o k response
func (o *GetTCPCheckDefaultsOK) WithConfigurationVersion(configurationVersion string) *GetTCPCheckDefaultsOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Tcp check defaults o k response
func (o *GetTCPCheckDefaultsOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Tcp check defaults o k response
func (o *GetTCPCheckDefaultsOK) WithPayload(payload *models.TCPCheck) *GetTCPCheckDefaultsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Tcp check defaults o k response
func (o *GetTCPCheckDefaultsOK) SetPayload(payload *models.TCPCheck) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetTCPCheckDefaultsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetTCPCheckDefaultsNotFoundCode is the HTTP code returned for type GetTCPCheckDefaultsNotFound
const GetTCPCheckDefaultsNotFoundCode int = 404

/*
GetTCPCheckDefaultsNotFound The specified resource was not found

swagger:response getTcpCheckDefaultsNotFound
*/
type GetTCPCheckDefaultsNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetTCPCheckDefaultsNotFound creates GetTCPCheckDefaultsNotFound with default headers values
func NewGetTCPCheckDefaultsNotFound() *GetTCPCheckDefaultsNotFound {

	return &GetTCPCheckDefaultsNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get Tcp check defaults not found response
func (o *GetTCPCheckDefaultsNotFound) WithConfigurationVersion(configurationVersion string) *GetTCPCheckDefaultsNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Tcp check defaults not found response
func (o *GetTCPCheckDefaultsNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Tcp check defaults not found response
func (o *GetTCPCheckDefaultsNotFound) WithPayload(payload *models.Error) *GetTCPCheckDefaultsNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Tcp check defaults not found response
func (o *GetTCPCheckDefaultsNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetTCPCheckDefaultsNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetTCPCheckDefaultsDefault General Error

swagger:response getTcpCheckDefaultsDefault
*/
type GetTCPCheckDefaultsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetTCPCheckDefaultsDefault creates GetTCPCheckDefaultsDefault with default headers values
func NewGetTCPCheckDefaultsDefault(code int) *GetTCPCheckDefaultsDefault {
	if code <= 0 {
		code = 500
	}

	return &GetTCPCheckDefaultsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get TCP check defaults default response
func (o *GetTCPCheckDefaultsDefault) WithStatusCode(code int) *GetTCPCheckDefaultsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get TCP check defaults default response
func (o *GetTCPCheckDefaultsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get TCP check defaults default response
func (o *GetTCPCheckDefaultsDefault) WithConfigurationVersion(configurationVersion string) *GetTCPCheckDefaultsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get TCP check defaults default response
func (o *GetTCPCheckDefaultsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get TCP check defaults default response
func (o *GetTCPCheckDefaultsDefault) WithPayload(payload *models.Error) *GetTCPCheckDefaultsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get TCP check defaults default response
func (o *GetTCPCheckDefaultsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetTCPCheckDefaultsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
