/*
 * Decompiled with CFR 0.152.
 */
package org.hampelratte.svdrp.responses.highlevel;

import java.util.Arrays;
import org.hampelratte.svdrp.responses.highlevel.BroadcastChannel;

public class DVBChannel
extends BroadcastChannel {
    private static final long serialVersionUID = 1L;
    public static final int QAM = 998;
    public static final int AUTOMATIC = 999;
    private int alpha = -1;
    private int bandwidth = -1;
    private int codeRateHP = -1;
    private int codeRateLP = -1;
    private int guardInterval = -1;
    private boolean horizontalPolarization = false;
    private boolean verticalPolarization = false;
    private int inversion = -1;
    private boolean leftCircularPolarization = false;
    private boolean rightCircularPolarization = false;
    private int modulation = -1;
    private int transmissionMode = -1;
    private int hierarchy = -1;
    private int rolloff = -1;
    private int priority = -1;

    public String toChannelsConf() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName().replace(":", "|"));
        if (this.getShortName().length() > 0) {
            sb.append(',');
            sb.append(this.getShortName());
        }
        if (this.getServiceProviderName().length() > 0) {
            sb.append(';');
            sb.append(this.getServiceProviderName());
        }
        sb.append(":");
        sb.append(this.getFrequency());
        sb.append(':');
        sb.append(this.getParameterString());
        sb.append(':');
        sb.append(this.getSource());
        sb.append(':');
        sb.append(this.getSymbolRate());
        sb.append(':');
        sb.append(this.getVPID());
        sb.append(':');
        sb.append(this.getAPID());
        sb.append(':');
        sb.append(this.getTPID());
        sb.append(':');
        sb.append(this.getSID());
        sb.append(':');
        sb.append(this.getNID());
        sb.append(':');
        sb.append(this.getTID());
        sb.append(':');
        sb.append(this.getRID());
        return sb.toString();
    }

    private String getParameterString() {
        StringBuffer sb = new StringBuffer();
        if (this.getAlpha() > -1) {
            sb.append('A');
            sb.append(this.getAlpha());
        }
        if (this.getBandwidth() > -1) {
            sb.append('B');
            sb.append(this.getBandwidth());
        }
        if (this.getCodeRateHP() > -1) {
            sb.append('C');
            sb.append(this.getCodeRateHP());
        }
        if (this.getCodeRateLP() > -1) {
            sb.append('D');
            sb.append(this.getCodeRateLP());
        }
        if (this.getGuardInterval() > -1) {
            sb.append('G');
            sb.append(this.getGuardInterval());
        }
        if (this.isHorizontalPolarization()) {
            sb.append('H');
        }
        if (this.getInversion() > -1) {
            sb.append('I');
            sb.append(this.getInversion());
        }
        if (this.isLeftCircularPolarization()) {
            sb.append('L');
        }
        if (this.getModulation() > -1) {
            sb.append('M');
            sb.append(this.getModulation());
        }
        if (this.getRolloff() > -1) {
            sb.append('O');
            sb.append(this.getRolloff());
        }
        if (this.getPriority() > -1) {
            sb.append('P');
            sb.append(this.getPriority());
        }
        if (this.isRightCircularPolarization()) {
            sb.append('R');
        }
        if (this.getTransmissionMode() > -1) {
            sb.append('T');
            sb.append(this.getTransmissionMode());
        }
        if (this.isVerticalPolarization()) {
            sb.append('V');
        }
        if (this.getHierarchy() > -1) {
            sb.append('Y');
            sb.append(this.getHierarchy());
        }
        return sb.toString();
    }

    public int getBandwidth() {
        return this.bandwidth;
    }

    public void setBandwidth(int bandwidth) {
        this.bandwidth = bandwidth;
    }

    public int getCodeRateHP() {
        return this.codeRateHP;
    }

    public void setCodeRateHP(int codeRateHP) {
        this.codeRateHP = codeRateHP;
    }

    public int getCodeRateLP() {
        return this.codeRateLP;
    }

    public void setCodeRateLP(int codeRateLP) {
        this.codeRateLP = codeRateLP;
    }

    public int getGuardInterval() {
        return this.guardInterval;
    }

    public void setGuardInterval(int guardInterval) {
        this.guardInterval = guardInterval;
    }

    public int getHierarchy() {
        return this.hierarchy;
    }

    public void setHierarchy(int hierarchy) {
        this.hierarchy = hierarchy;
    }

    public boolean isHorizontalPolarization() {
        return this.horizontalPolarization;
    }

    public void setHorizontalPolarization(boolean horizontalPolarization) {
        this.horizontalPolarization = horizontalPolarization;
    }

    public int getInversion() {
        return this.inversion;
    }

    public void setInversion(int inversion) {
        this.inversion = inversion;
    }

    public boolean isLeftCircularPolarization() {
        return this.leftCircularPolarization;
    }

    public void setLeftCircularPolarization(boolean leftCircularPolarization) {
        this.leftCircularPolarization = leftCircularPolarization;
    }

    public int getModulation() {
        return this.modulation;
    }

    public void setModulation(int modulation) {
        this.modulation = modulation;
    }

    public boolean isRightCircularPolarization() {
        return this.rightCircularPolarization;
    }

    public void setRightCircularPolarization(boolean rightCircularPolarization) {
        this.rightCircularPolarization = rightCircularPolarization;
    }

    public int getTransmissionMode() {
        return this.transmissionMode;
    }

    public void setTransmissionMode(int transmissionMode) {
        this.transmissionMode = transmissionMode;
    }

    public boolean isVerticalPolarization() {
        return this.verticalPolarization;
    }

    public void setVerticalPolarization(boolean verticalPolarization) {
        this.verticalPolarization = verticalPolarization;
    }

    public boolean equals(Object o) {
        if (o instanceof DVBChannel) {
            DVBChannel c = (DVBChannel)o;
            return c.getID().equals(this.getID());
        }
        return false;
    }

    @Deprecated
    public int getAlpha() {
        return this.alpha;
    }

    @Deprecated
    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    @Deprecated
    public int getRolloff() {
        return this.rolloff;
    }

    @Deprecated
    public void setRolloff(int rolloff) {
        this.rolloff = rolloff;
    }

    @Deprecated
    public int getPriority() {
        return this.priority;
    }

    @Deprecated
    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void validate() throws IllegalArgumentException {
        int[] validValues = new int[]{-1, 0, 1, 2, 4, 999};
        boolean valid = this.validateArray(validValues, this.alpha);
        if (!valid) {
            this.throwIllegalArgumentException("Alpha", this.alpha, validValues);
        }
        if (!(valid = this.validateArray(validValues = new int[]{-1, 1712, 5, 6, 7, 8, 10, 999}, this.bandwidth))) {
            this.throwIllegalArgumentException("Bandwidth", this.bandwidth, validValues);
        }
        if (!(valid = this.validateArray(validValues = new int[]{-1, 0, 12, 23, 34, 35, 45, 56, 67, 78, 89, 910, 999}, this.codeRateHP))) {
            this.throwIllegalArgumentException("Code rate HP", this.codeRateHP, validValues);
        }
        if (!(valid = this.validateArray(validValues = new int[]{-1, 0, 12, 23, 34, 35, 45, 56, 67, 78, 89, 910, 999}, this.codeRateLP))) {
            this.throwIllegalArgumentException("Code rate LP", this.codeRateLP, validValues);
        }
        if (!(valid = this.validateArray(validValues = new int[]{-1, 4, 8, 16, 32, 128, 19128, 19256, 999}, this.guardInterval))) {
            this.throwIllegalArgumentException("Guard interval", this.guardInterval, validValues);
        }
        if (!(valid = this.validateArray(validValues = new int[]{-1, 0, 1, 2, 4, 999}, this.hierarchy))) {
            this.throwIllegalArgumentException("Hierarchy", this.hierarchy, validValues);
        }
        if (!(valid = this.validateArray(validValues = new int[]{-1, 0, 1, 999}, this.inversion))) {
            this.throwIllegalArgumentException("Inversion", this.inversion, validValues);
        }
        if (!(valid = this.validateArray(validValues = new int[]{-1, 0, 2, 5, 6, 7, 10, 11, 12, 16, 32, 64, 128, 256, 998, 999}, this.modulation))) {
            this.throwIllegalArgumentException("Modulation", this.modulation, validValues);
        }
        if (!(valid = this.validateArray(validValues = new int[]{-1, 0, 1, 999}, this.priority))) {
            this.throwIllegalArgumentException("Priority", this.priority, validValues);
        }
        if (!(valid = this.validateArray(validValues = new int[]{-1, 0, 20, 25, 35, 999}, this.rolloff))) {
            this.throwIllegalArgumentException("Rolloff", this.rolloff, validValues);
        }
        if (!(valid = this.validateArray(validValues = new int[]{-1, 2, 8, 999}, this.transmissionMode))) {
            this.throwIllegalArgumentException("Transmission mode", this.transmissionMode, validValues);
        }
    }

    private void throwIllegalArgumentException(String name, int value, int[] validValues) throws IllegalArgumentException {
        throw new IllegalArgumentException(name + " value [" + value + "] is invalid. Valid values are " + Arrays.toString(validValues));
    }

    private boolean validateArray(int[] validValues, int value) {
        for (int i = 0; i < validValues.length; ++i) {
            if (value != validValues[i]) continue;
            return true;
        }
        return false;
    }

    public String getID() {
        String id = this.getSource() + "-" + this.getNID() + "-";
        if (this.getNID() == 0 && this.getTID() == 0) {
            int part = this.getFrequency();
            part += this.isHorizontalPolarization() ? 100000 : 0;
            part += this.isVerticalPolarization() ? 200000 : 0;
            part += this.isLeftCircularPolarization() ? 300000 : 0;
            id = id + (part += this.isRightCircularPolarization() ? 400000 : 0);
        } else {
            id = id + this.getTID();
        }
        id = id + "-" + this.getSID();
        if (this.getRID() != 0) {
            id = id + "-" + this.getRID();
        }
        return id;
    }
}

