/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field.types;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.field.types.DateType;
import java.lang.reflect.Field;
import java.sql.Timestamp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeStampType
extends DateType {
    private static final TimeStampType singleTon = new TimeStampType();

    public static TimeStampType getSingleton() {
        return singleTon;
    }

    private TimeStampType() {
        super(SqlType.DATE, new Class[]{Timestamp.class});
    }

    protected TimeStampType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    @Override
    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) {
        return sqlArg;
    }

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object javaObject) {
        return javaObject;
    }

    @Override
    public boolean isValidForField(Field field) {
        return field.getType() == Timestamp.class;
    }

    @Override
    public Object moveToNextValue(Object currentValue) {
        long newVal = System.currentTimeMillis();
        if (currentValue == null) {
            return new Timestamp(newVal);
        }
        if (newVal == ((Timestamp)currentValue).getTime()) {
            return new Timestamp(newVal + 1L);
        }
        return new Timestamp(newVal);
    }
}

