// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/sql/v1/cloud_sql_databases.proto

package sql

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Database delete request.
type SqlDatabasesDeleteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the database to be deleted in the instance.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// Database instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,3,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlDatabasesDeleteRequest) Reset() {
	*x = SqlDatabasesDeleteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_databases_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlDatabasesDeleteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlDatabasesDeleteRequest) ProtoMessage() {}

func (x *SqlDatabasesDeleteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_databases_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlDatabasesDeleteRequest.ProtoReflect.Descriptor instead.
func (*SqlDatabasesDeleteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_databases_proto_rawDescGZIP(), []int{0}
}

func (x *SqlDatabasesDeleteRequest) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *SqlDatabasesDeleteRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlDatabasesDeleteRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

// Database get request.
type SqlDatabasesGetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the database in the instance.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// Database instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,3,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlDatabasesGetRequest) Reset() {
	*x = SqlDatabasesGetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_databases_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlDatabasesGetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlDatabasesGetRequest) ProtoMessage() {}

func (x *SqlDatabasesGetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_databases_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlDatabasesGetRequest.ProtoReflect.Descriptor instead.
func (*SqlDatabasesGetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_databases_proto_rawDescGZIP(), []int{1}
}

func (x *SqlDatabasesGetRequest) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *SqlDatabasesGetRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlDatabasesGetRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

// Database insert request.
type SqlDatabasesInsertRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Database instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string    `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	Body    *Database `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlDatabasesInsertRequest) Reset() {
	*x = SqlDatabasesInsertRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_databases_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlDatabasesInsertRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlDatabasesInsertRequest) ProtoMessage() {}

func (x *SqlDatabasesInsertRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_databases_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlDatabasesInsertRequest.ProtoReflect.Descriptor instead.
func (*SqlDatabasesInsertRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_databases_proto_rawDescGZIP(), []int{2}
}

func (x *SqlDatabasesInsertRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlDatabasesInsertRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlDatabasesInsertRequest) GetBody() *Database {
	if x != nil {
		return x.Body
	}
	return nil
}

// Database list request.
type SqlDatabasesListRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud SQL instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *SqlDatabasesListRequest) Reset() {
	*x = SqlDatabasesListRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_databases_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlDatabasesListRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlDatabasesListRequest) ProtoMessage() {}

func (x *SqlDatabasesListRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_databases_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlDatabasesListRequest.ProtoReflect.Descriptor instead.
func (*SqlDatabasesListRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_databases_proto_rawDescGZIP(), []int{3}
}

func (x *SqlDatabasesListRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlDatabasesListRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

// Database update request.
type SqlDatabasesUpdateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the database to be updated in the instance.
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// Database instance ID. This does not include the project ID.
	Instance string `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
	// Project ID of the project that contains the instance.
	Project string    `protobuf:"bytes,3,opt,name=project,proto3" json:"project,omitempty"`
	Body    *Database `protobuf:"bytes,100,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *SqlDatabasesUpdateRequest) Reset() {
	*x = SqlDatabasesUpdateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_databases_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlDatabasesUpdateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlDatabasesUpdateRequest) ProtoMessage() {}

func (x *SqlDatabasesUpdateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_databases_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlDatabasesUpdateRequest.ProtoReflect.Descriptor instead.
func (*SqlDatabasesUpdateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_databases_proto_rawDescGZIP(), []int{4}
}

func (x *SqlDatabasesUpdateRequest) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *SqlDatabasesUpdateRequest) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SqlDatabasesUpdateRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *SqlDatabasesUpdateRequest) GetBody() *Database {
	if x != nil {
		return x.Body
	}
	return nil
}

// Database list response.
type DatabasesListResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always **sql#databasesList**.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// List of database resources in the instance.
	Items []*Database `protobuf:"bytes,2,rep,name=items,proto3" json:"items,omitempty"`
}

func (x *DatabasesListResponse) Reset() {
	*x = DatabasesListResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_databases_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatabasesListResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabasesListResponse) ProtoMessage() {}

func (x *DatabasesListResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_databases_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabasesListResponse.ProtoReflect.Descriptor instead.
func (*DatabasesListResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_databases_proto_rawDescGZIP(), []int{5}
}

func (x *DatabasesListResponse) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *DatabasesListResponse) GetItems() []*Database {
	if x != nil {
		return x.Items
	}
	return nil
}

var File_google_cloud_sql_v1_cloud_sql_databases_proto protoreflect.FileDescriptor

var file_google_cloud_sql_v1_cloud_sql_databases_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73, 0x71, 0x6c, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73, 0x71,
	0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x6d, 0x0a, 0x19, 0x53, 0x71,
	0x6c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x6a, 0x0a, 0x16, 0x53, 0x71, 0x6c,
	0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x47, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12,
	0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x84, 0x01, 0x0a, 0x19, 0x53, 0x71, 0x6c, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x31, 0x0a, 0x04, 0x62, 0x6f, 0x64,
	0x79, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x22, 0x4f, 0x0a, 0x17,
	0x53, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x4c, 0x69, 0x73, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0xa0, 0x01,
	0x0a, 0x19, 0x53, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x31, 0x0a,
	0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79,
	0x22, 0x60, 0x0a, 0x15, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x4c, 0x69, 0x73,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x33, 0x0a,
	0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x05, 0x69, 0x74, 0x65,
	0x6d, 0x73, 0x32, 0xed, 0x08, 0x0a, 0x13, 0x53, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xa2, 0x01, 0x0a, 0x06, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x44,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x2a, 0x40, 0x2f,
	0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f,
	0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x7d, 0x12,
	0x9b, 0x01, 0x0a, 0x03, 0x47, 0x65, 0x74, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71,
	0x6c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x47, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x22, 0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x12, 0x40, 0x2f, 0x76, 0x31,
	0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x7d, 0x12, 0x9d, 0x01,
	0x0a, 0x06, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x71, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x49, 0x6e, 0x73, 0x65, 0x72,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x43, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d,
	0x22, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x3a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0x9f, 0x01,
	0x0a, 0x04, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c,
	0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x3d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x12,
	0xa7, 0x01, 0x0a, 0x05, 0x50, 0x61, 0x74, 0x63, 0x68, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x4e, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x48, 0x32, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x7d, 0x3a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0xa8, 0x01, 0x0a, 0x06, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x44, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x4e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x1a, 0x40, 0x2f, 0x76,
	0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x7d, 0x3a, 0x04,
	0x62, 0x6f, 0x64, 0x79, 0x1a, 0x7c, 0xca, 0x41, 0x17, 0x73, 0x71, 0x6c, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x73, 0x71, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x42, 0x6b, 0x0a, 0x17, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x42, 0x16, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x3b, 0x73, 0x71, 0x6c, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_sql_v1_cloud_sql_databases_proto_rawDescOnce sync.Once
	file_google_cloud_sql_v1_cloud_sql_databases_proto_rawDescData = file_google_cloud_sql_v1_cloud_sql_databases_proto_rawDesc
)

func file_google_cloud_sql_v1_cloud_sql_databases_proto_rawDescGZIP() []byte {
	file_google_cloud_sql_v1_cloud_sql_databases_proto_rawDescOnce.Do(func() {
		file_google_cloud_sql_v1_cloud_sql_databases_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_sql_v1_cloud_sql_databases_proto_rawDescData)
	})
	return file_google_cloud_sql_v1_cloud_sql_databases_proto_rawDescData
}

var file_google_cloud_sql_v1_cloud_sql_databases_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_cloud_sql_v1_cloud_sql_databases_proto_goTypes = []interface{}{
	(*SqlDatabasesDeleteRequest)(nil), // 0: google.cloud.sql.v1.SqlDatabasesDeleteRequest
	(*SqlDatabasesGetRequest)(nil),    // 1: google.cloud.sql.v1.SqlDatabasesGetRequest
	(*SqlDatabasesInsertRequest)(nil), // 2: google.cloud.sql.v1.SqlDatabasesInsertRequest
	(*SqlDatabasesListRequest)(nil),   // 3: google.cloud.sql.v1.SqlDatabasesListRequest
	(*SqlDatabasesUpdateRequest)(nil), // 4: google.cloud.sql.v1.SqlDatabasesUpdateRequest
	(*DatabasesListResponse)(nil),     // 5: google.cloud.sql.v1.DatabasesListResponse
	(*Database)(nil),                  // 6: google.cloud.sql.v1.Database
	(*Operation)(nil),                 // 7: google.cloud.sql.v1.Operation
}
var file_google_cloud_sql_v1_cloud_sql_databases_proto_depIdxs = []int32{
	6, // 0: google.cloud.sql.v1.SqlDatabasesInsertRequest.body:type_name -> google.cloud.sql.v1.Database
	6, // 1: google.cloud.sql.v1.SqlDatabasesUpdateRequest.body:type_name -> google.cloud.sql.v1.Database
	6, // 2: google.cloud.sql.v1.DatabasesListResponse.items:type_name -> google.cloud.sql.v1.Database
	0, // 3: google.cloud.sql.v1.SqlDatabasesService.Delete:input_type -> google.cloud.sql.v1.SqlDatabasesDeleteRequest
	1, // 4: google.cloud.sql.v1.SqlDatabasesService.Get:input_type -> google.cloud.sql.v1.SqlDatabasesGetRequest
	2, // 5: google.cloud.sql.v1.SqlDatabasesService.Insert:input_type -> google.cloud.sql.v1.SqlDatabasesInsertRequest
	3, // 6: google.cloud.sql.v1.SqlDatabasesService.List:input_type -> google.cloud.sql.v1.SqlDatabasesListRequest
	4, // 7: google.cloud.sql.v1.SqlDatabasesService.Patch:input_type -> google.cloud.sql.v1.SqlDatabasesUpdateRequest
	4, // 8: google.cloud.sql.v1.SqlDatabasesService.Update:input_type -> google.cloud.sql.v1.SqlDatabasesUpdateRequest
	7, // 9: google.cloud.sql.v1.SqlDatabasesService.Delete:output_type -> google.cloud.sql.v1.Operation
	6, // 10: google.cloud.sql.v1.SqlDatabasesService.Get:output_type -> google.cloud.sql.v1.Database
	7, // 11: google.cloud.sql.v1.SqlDatabasesService.Insert:output_type -> google.cloud.sql.v1.Operation
	5, // 12: google.cloud.sql.v1.SqlDatabasesService.List:output_type -> google.cloud.sql.v1.DatabasesListResponse
	7, // 13: google.cloud.sql.v1.SqlDatabasesService.Patch:output_type -> google.cloud.sql.v1.Operation
	7, // 14: google.cloud.sql.v1.SqlDatabasesService.Update:output_type -> google.cloud.sql.v1.Operation
	9, // [9:15] is the sub-list for method output_type
	3, // [3:9] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_google_cloud_sql_v1_cloud_sql_databases_proto_init() }
func file_google_cloud_sql_v1_cloud_sql_databases_proto_init() {
	if File_google_cloud_sql_v1_cloud_sql_databases_proto != nil {
		return
	}
	file_google_cloud_sql_v1_cloud_sql_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_sql_v1_cloud_sql_databases_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlDatabasesDeleteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_databases_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlDatabasesGetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_databases_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlDatabasesInsertRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_databases_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlDatabasesListRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_databases_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlDatabasesUpdateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_databases_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatabasesListResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_sql_v1_cloud_sql_databases_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_sql_v1_cloud_sql_databases_proto_goTypes,
		DependencyIndexes: file_google_cloud_sql_v1_cloud_sql_databases_proto_depIdxs,
		MessageInfos:      file_google_cloud_sql_v1_cloud_sql_databases_proto_msgTypes,
	}.Build()
	File_google_cloud_sql_v1_cloud_sql_databases_proto = out.File
	file_google_cloud_sql_v1_cloud_sql_databases_proto_rawDesc = nil
	file_google_cloud_sql_v1_cloud_sql_databases_proto_goTypes = nil
	file_google_cloud_sql_v1_cloud_sql_databases_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SqlDatabasesServiceClient is the client API for SqlDatabasesService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SqlDatabasesServiceClient interface {
	// Deletes a database from a Cloud SQL instance.
	Delete(ctx context.Context, in *SqlDatabasesDeleteRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves a resource containing information about a database inside a Cloud
	// SQL instance.
	Get(ctx context.Context, in *SqlDatabasesGetRequest, opts ...grpc.CallOption) (*Database, error)
	// Inserts a resource containing information about a database inside a Cloud
	// SQL instance.
	Insert(ctx context.Context, in *SqlDatabasesInsertRequest, opts ...grpc.CallOption) (*Operation, error)
	// Lists databases in the specified Cloud SQL instance.
	List(ctx context.Context, in *SqlDatabasesListRequest, opts ...grpc.CallOption) (*DatabasesListResponse, error)
	// Partially updates a resource containing information about a database inside
	// a Cloud SQL instance. This method supports patch semantics.
	Patch(ctx context.Context, in *SqlDatabasesUpdateRequest, opts ...grpc.CallOption) (*Operation, error)
	// Updates a resource containing information about a database inside a Cloud
	// SQL instance.
	Update(ctx context.Context, in *SqlDatabasesUpdateRequest, opts ...grpc.CallOption) (*Operation, error)
}

type sqlDatabasesServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSqlDatabasesServiceClient(cc grpc.ClientConnInterface) SqlDatabasesServiceClient {
	return &sqlDatabasesServiceClient{cc}
}

func (c *sqlDatabasesServiceClient) Delete(ctx context.Context, in *SqlDatabasesDeleteRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlDatabasesService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlDatabasesServiceClient) Get(ctx context.Context, in *SqlDatabasesGetRequest, opts ...grpc.CallOption) (*Database, error) {
	out := new(Database)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlDatabasesService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlDatabasesServiceClient) Insert(ctx context.Context, in *SqlDatabasesInsertRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlDatabasesService/Insert", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlDatabasesServiceClient) List(ctx context.Context, in *SqlDatabasesListRequest, opts ...grpc.CallOption) (*DatabasesListResponse, error) {
	out := new(DatabasesListResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlDatabasesService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlDatabasesServiceClient) Patch(ctx context.Context, in *SqlDatabasesUpdateRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlDatabasesService/Patch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sqlDatabasesServiceClient) Update(ctx context.Context, in *SqlDatabasesUpdateRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.sql.v1.SqlDatabasesService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SqlDatabasesServiceServer is the server API for SqlDatabasesService service.
type SqlDatabasesServiceServer interface {
	// Deletes a database from a Cloud SQL instance.
	Delete(context.Context, *SqlDatabasesDeleteRequest) (*Operation, error)
	// Retrieves a resource containing information about a database inside a Cloud
	// SQL instance.
	Get(context.Context, *SqlDatabasesGetRequest) (*Database, error)
	// Inserts a resource containing information about a database inside a Cloud
	// SQL instance.
	Insert(context.Context, *SqlDatabasesInsertRequest) (*Operation, error)
	// Lists databases in the specified Cloud SQL instance.
	List(context.Context, *SqlDatabasesListRequest) (*DatabasesListResponse, error)
	// Partially updates a resource containing information about a database inside
	// a Cloud SQL instance. This method supports patch semantics.
	Patch(context.Context, *SqlDatabasesUpdateRequest) (*Operation, error)
	// Updates a resource containing information about a database inside a Cloud
	// SQL instance.
	Update(context.Context, *SqlDatabasesUpdateRequest) (*Operation, error)
}

// UnimplementedSqlDatabasesServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSqlDatabasesServiceServer struct {
}

func (*UnimplementedSqlDatabasesServiceServer) Delete(context.Context, *SqlDatabasesDeleteRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedSqlDatabasesServiceServer) Get(context.Context, *SqlDatabasesGetRequest) (*Database, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedSqlDatabasesServiceServer) Insert(context.Context, *SqlDatabasesInsertRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (*UnimplementedSqlDatabasesServiceServer) List(context.Context, *SqlDatabasesListRequest) (*DatabasesListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedSqlDatabasesServiceServer) Patch(context.Context, *SqlDatabasesUpdateRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}
func (*UnimplementedSqlDatabasesServiceServer) Update(context.Context, *SqlDatabasesUpdateRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}

func RegisterSqlDatabasesServiceServer(s *grpc.Server, srv SqlDatabasesServiceServer) {
	s.RegisterService(&_SqlDatabasesService_serviceDesc, srv)
}

func _SqlDatabasesService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlDatabasesDeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlDatabasesServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlDatabasesService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlDatabasesServiceServer).Delete(ctx, req.(*SqlDatabasesDeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlDatabasesService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlDatabasesGetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlDatabasesServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlDatabasesService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlDatabasesServiceServer).Get(ctx, req.(*SqlDatabasesGetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlDatabasesService_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlDatabasesInsertRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlDatabasesServiceServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlDatabasesService/Insert",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlDatabasesServiceServer).Insert(ctx, req.(*SqlDatabasesInsertRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlDatabasesService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlDatabasesListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlDatabasesServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlDatabasesService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlDatabasesServiceServer).List(ctx, req.(*SqlDatabasesListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlDatabasesService_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlDatabasesUpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlDatabasesServiceServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlDatabasesService/Patch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlDatabasesServiceServer).Patch(ctx, req.(*SqlDatabasesUpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SqlDatabasesService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SqlDatabasesUpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SqlDatabasesServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.sql.v1.SqlDatabasesService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SqlDatabasesServiceServer).Update(ctx, req.(*SqlDatabasesUpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SqlDatabasesService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.sql.v1.SqlDatabasesService",
	HandlerType: (*SqlDatabasesServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Delete",
			Handler:    _SqlDatabasesService_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _SqlDatabasesService_Get_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _SqlDatabasesService_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _SqlDatabasesService_List_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _SqlDatabasesService_Patch_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _SqlDatabasesService_Update_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/sql/v1/cloud_sql_databases.proto",
}
