/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot;

import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import sun.jvm.hotspot.debugger.DebuggerException;

public class RMIHelper {
    private static final boolean startRegistry;
    private static int port;
    private static String serverNamePrefix;

    public static void rebind(String uniqueID, Remote object) throws DebuggerException {
        String name = RMIHelper.getName(uniqueID);
        try {
            Naming.rebind(name, object);
        }
        catch (RemoteException re) {
            if (startRegistry) {
                try {
                    LocateRegistry.createRegistry(port);
                    Naming.rebind(name, object);
                }
                catch (Exception exp) {
                    throw new DebuggerException(exp);
                }
            }
            throw new DebuggerException(re);
        }
        catch (Exception exp) {
            throw new DebuggerException(exp);
        }
    }

    public static void unbind(String uniqueID) throws DebuggerException {
        String name = RMIHelper.getName(uniqueID);
        try {
            Naming.unbind(name);
        }
        catch (Exception exp) {
            throw new DebuggerException(exp);
        }
    }

    public static Remote lookup(String debugServerID) throws DebuggerException {
        int index = debugServerID.indexOf(64);
        StringBuffer nameBuf = new StringBuffer("//");
        String uniqueID = null;
        if (index != -1) {
            nameBuf.append(debugServerID.substring(index + 1));
            uniqueID = debugServerID.substring(0, index);
        } else {
            nameBuf.append(debugServerID);
        }
        nameBuf.append('/');
        nameBuf.append(serverNamePrefix);
        if (uniqueID != null) {
            nameBuf.append('_');
            nameBuf.append(uniqueID);
        }
        try {
            return Naming.lookup(nameBuf.toString());
        }
        catch (Exception exp) {
            throw new DebuggerException(exp);
        }
    }

    private static String getName(String uniqueID) {
        String name = null;
        name = uniqueID != null ? serverNamePrefix + "_" + uniqueID : serverNamePrefix;
        if (port != 1099) {
            name = "//localhost:" + port + "/" + name;
        }
        return name;
    }

    static {
        String tmp = System.getProperty("sun.jvm.hotspot.rmi.startRegistry");
        startRegistry = tmp == null || !tmp.equals("false");
        port = 1099;
        tmp = System.getProperty("sun.jvm.hotspot.rmi.port");
        if (tmp != null) {
            try {
                port = Integer.parseInt(tmp);
            }
            catch (NumberFormatException nfe) {
                System.err.println("invalid port supplied, assuming default");
            }
        }
        serverNamePrefix = (tmp = System.getProperty("sun.jvm.hotspot.rmi.serverNamePrefix")) != null ? serverNamePrefix : "SARemoteDebugger";
    }
}

