/* MoUtils.c generated by valac 0.54.3, the Vala compiler
 * generated from MoUtils.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MO_UTILS (mo_utils_get_type ())
#define MO_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MO_UTILS, MoUtils))
#define MO_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MO_UTILS, MoUtilsClass))
#define IS_MO_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MO_UTILS))
#define IS_MO_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MO_UTILS))
#define MO_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MO_UTILS, MoUtilsClass))

typedef struct _MoUtils MoUtils;
typedef struct _MoUtilsClass MoUtilsClass;
typedef struct _MoUtilsPrivate MoUtilsPrivate;
enum  {
	MO_UTILS_0_PROPERTY,
	MO_UTILS_NUM_PROPERTIES
};
static GParamSpec* mo_utils_properties[MO_UTILS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _MoUtils {
	GObject parent_instance;
	MoUtilsPrivate * priv;
};

struct _MoUtilsClass {
	GObjectClass parent_class;
};

static gpointer mo_utils_parent_class = NULL;

VALA_EXTERN GType mo_utils_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MoUtils, g_object_unref)
VALA_EXTERN GFile* mo_utils_newFile (const gchar* path);
VALA_EXTERN gboolean mo_utils_fileExists (const gchar* path);
VALA_EXTERN gint64 mo_utils_fileSize (const gchar* path);
VALA_EXTERN gchar* mo_utils_getParentFolder (const gchar* path);
VALA_EXTERN gchar* mo_utils_getLastMessage (const gchar* messages);
VALA_EXTERN gchar* input_parser_statusReplace (const gchar* oldString);
VALA_EXTERN void mo_utils_populateComboBox (GtkComboBox* Combo,
                                gchar** val_array,
                                gint val_array_length1,
                                gboolean render_cell);
VALA_EXTERN MoUtils* mo_utils_new (void);
VALA_EXTERN MoUtils* mo_utils_construct (GType object_type);
static GType mo_utils_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

GFile*
mo_utils_newFile (const gchar* path)
{
	gchar* uri = NULL;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* result = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	if (string_contains (path, "://")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (path);
		_g_free0 (uri);
		uri = _tmp0_;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup_printf ("file://%s", path);
		_g_free0 (uri);
		uri = _tmp1_;
	}
	_tmp2_ = uri;
	_tmp3_ = g_file_new_for_uri (_tmp2_);
	result = _tmp3_;
	_g_free0 (uri);
	return result;
}

gboolean
mo_utils_fileExists (const gchar* path)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = mo_utils_newFile (path);
	file = _tmp0_;
	result = g_file_query_exists (file, NULL);
	_g_object_unref0 (file);
	return result;
}

gint64
mo_utils_fileSize (const gchar* path)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	gint64 result = 0LL;
	g_return_val_if_fail (path != NULL, 0LL);
	_tmp0_ = mo_utils_newFile (path);
	file = _tmp0_;
	{
		GFileInfo* info = NULL;
		GFileInfo* _tmp1_;
		_tmp1_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_SIZE, 0, NULL, &_inner_error0_);
		info = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = g_file_info_get_size (info);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("MoUtils.vala:48: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint64 _tmp4_ = -1LL;
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
	result = (gint64) 0;
	_g_object_unref0 (file);
	return result;
}

gchar*
mo_utils_getParentFolder (const gchar* path)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* parent = NULL;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* result = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = mo_utils_newFile (path);
	file = _tmp0_;
	_tmp1_ = g_file_get_parent (file);
	parent = _tmp1_;
	_tmp2_ = g_file_get_parse_name (parent);
	result = _tmp2_;
	_g_object_unref0 (parent);
	_g_object_unref0 (file);
	return result;
}

gchar*
mo_utils_getLastMessage (const gchar* messages)
{
	gchar* message = NULL;
	gchar* escaped = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** splitMessages = NULL;
	gint splitMessages_length1 = 0;
	gint _splitMessages_size_ = 0;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gchar* result = NULL;
	message = NULL;
	_tmp0_ = g_strescape (messages, "");
	escaped = _tmp0_;
	_tmp1_ = escaped;
	_tmp2_ = input_parser_statusReplace (_tmp1_);
	_g_free0 (escaped);
	escaped = _tmp2_;
	_tmp3_ = escaped;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, "\\n", 20);
	splitMessages = (_vala_array_free (splitMessages, splitMessages_length1, (GDestroyNotify) g_free), NULL);
	splitMessages = _tmp5_;
	splitMessages_length1 = _vala_array_length (_tmp4_);
	_splitMessages_size_ = splitMessages_length1;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gchar** _tmp8_;
				gint _tmp8__length1;
				gchar** _tmp9_;
				gint _tmp9__length1;
				const gchar* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = x;
					x = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = splitMessages;
				_tmp8__length1 = splitMessages_length1;
				if (!(((guint) x) < g_strv_length (_tmp8_))) {
					break;
				}
				_tmp9_ = splitMessages;
				_tmp9__length1 = splitMessages_length1;
				_tmp10_ = _tmp9_[x];
				_tmp11_ = strlen (_tmp10_);
				_tmp12_ = _tmp11_;
				if (_tmp12_ > 5) {
					gchar** _tmp13_;
					gint _tmp13__length1;
					const gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp13_ = splitMessages;
					_tmp13__length1 = splitMessages_length1;
					_tmp14_ = _tmp13_[x];
					_tmp15_ = g_strdup (_tmp14_);
					_g_free0 (message);
					message = _tmp15_;
				}
			}
		}
	}
	result = message;
	splitMessages = (_vala_array_free (splitMessages, splitMessages_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (escaped);
	return result;
}

void
mo_utils_populateComboBox (GtkComboBox* Combo,
                           gchar** val_array,
                           gint val_array_length1,
                           gboolean render_cell)
{
	GtkListStore* Model = NULL;
	GtkListStore* _tmp0_;
	GtkListStore* _tmp7_;
	g_return_if_fail (Combo != NULL);
	_tmp0_ = gtk_list_store_new (1, G_TYPE_STRING, -1);
	Model = _tmp0_;
	{
		gchar** val_item_collection = NULL;
		gint val_item_collection_length1 = 0;
		gint _val_item_collection_size_ = 0;
		gint val_item_it = 0;
		val_item_collection = val_array;
		val_item_collection_length1 = val_array_length1;
		for (val_item_it = 0; val_item_it < val_item_collection_length1; val_item_it = val_item_it + 1) {
			gchar* _tmp1_;
			gchar* val_item = NULL;
			_tmp1_ = g_strdup (val_item_collection[val_item_it]);
			val_item = _tmp1_;
			{
				GtkTreeIter iter = {0};
				GtkListStore* _tmp2_;
				GtkTreeIter _tmp3_ = {0};
				GtkListStore* _tmp4_;
				GtkTreeIter _tmp5_;
				const gchar* _tmp6_;
				_tmp2_ = Model;
				gtk_list_store_append (_tmp2_, &_tmp3_);
				iter = _tmp3_;
				_tmp4_ = Model;
				_tmp5_ = iter;
				_tmp6_ = val_item;
				gtk_list_store_set (_tmp4_, &_tmp5_, 0, _ (_tmp6_), -1);
				_g_free0 (val_item);
			}
		}
	}
	_tmp7_ = Model;
	gtk_combo_box_set_model (Combo, (GtkTreeModel*) _tmp7_);
	if (render_cell) {
		GtkCellRenderer* Cell = NULL;
		GtkCellRendererText* _tmp8_;
		GtkCellRenderer* _tmp9_;
		GtkCellRenderer* _tmp10_;
		_tmp8_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
		g_object_ref_sink (_tmp8_);
		Cell = (GtkCellRenderer*) _tmp8_;
		_tmp9_ = Cell;
		gtk_cell_layout_pack_start ((GtkCellLayout*) Combo, _tmp9_, TRUE);
		_tmp10_ = Cell;
		gtk_cell_layout_set_attributes ((GtkCellLayout*) Combo, _tmp10_, "text", 0, NULL);
		_g_object_unref0 (Cell);
	}
	_g_object_unref0 (Model);
}

MoUtils*
mo_utils_construct (GType object_type)
{
	MoUtils * self = NULL;
	self = (MoUtils*) g_object_new (object_type, NULL);
	return self;
}

MoUtils*
mo_utils_new (void)
{
	return mo_utils_construct (TYPE_MO_UTILS);
}

static void
mo_utils_class_init (MoUtilsClass * klass,
                     gpointer klass_data)
{
	mo_utils_parent_class = g_type_class_peek_parent (klass);
}

static void
mo_utils_instance_init (MoUtils * self,
                        gpointer klass)
{
}

static GType
mo_utils_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MoUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mo_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MoUtils), 0, (GInstanceInitFunc) mo_utils_instance_init, NULL };
	GType mo_utils_type_id;
	mo_utils_type_id = g_type_register_static (G_TYPE_OBJECT, "MoUtils", &g_define_type_info, 0);
	return mo_utils_type_id;
}

GType
mo_utils_get_type (void)
{
	static volatile gsize mo_utils_type_id__volatile = 0;
	if (g_once_init_enter (&mo_utils_type_id__volatile)) {
		GType mo_utils_type_id;
		mo_utils_type_id = mo_utils_get_type_once ();
		g_once_init_leave (&mo_utils_type_id__volatile, mo_utils_type_id);
	}
	return mo_utils_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

