/* Settings.c generated by valac 0.54.3, the Vala compiler
 * generated from Settings.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SETTINGS (settings_get_type ())
#define SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS, Settings))
#define SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS, SettingsClass))
#define IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS))
#define IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS))
#define SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS, SettingsClass))

typedef struct _Settings Settings;
typedef struct _SettingsClass SettingsClass;
typedef struct _SettingsPrivate SettingsPrivate;
typedef enum  {
	SETTINGS_PARITY_NONE,
	SETTINGS_PARITY_ODD,
	SETTINGS_PARITY_EVEN,
	SETTINGS_PARITY_MARK,
	SETTINGS_PARITY_SPACE
} SettingsParity;

#define SETTINGS_TYPE_PARITY (settings_parity_get_type ())
typedef enum  {
	SETTINGS_HANDSHAKE_NONE,
	SETTINGS_HANDSHAKE_HARDWARE,
	SETTINGS_HANDSHAKE_SOFTWARE,
	SETTINGS_HANDSHAKE_BOTH
} SettingsHandshake;

#define SETTINGS_TYPE_HANDSHAKE (settings_handshake_get_type ())
typedef enum  {
	SETTINGS_ACCESS_MODE_READWRITE,
	SETTINGS_ACCESS_MODE_READONLY,
	SETTINGS_ACCESS_MODE_WRITEONLY
} SettingsAccessMode;

#define SETTINGS_TYPE_ACCESS_MODE (settings_access_mode_get_type ())
enum  {
	SETTINGS_0_PROPERTY,
	SETTINGS_DEVICE_PROPERTY,
	SETTINGS_BAUD_RATE_PROPERTY,
	SETTINGS_DATA_BITS_PROPERTY,
	SETTINGS_STOP_BITS_PROPERTY,
	SETTINGS_PARITY_PROPERTY,
	SETTINGS_HANDSHAKE_PROPERTY,
	SETTINGS_ACCESS_MODE_PROPERTY,
	SETTINGS_LOCAL_ECHO_PROPERTY,
	SETTINGS_AUTO_CONNECT_PROPERTY,
	SETTINGS_NUM_PROPERTIES
};
static GParamSpec* settings_properties[SETTINGS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PROFILE (profile_get_type ())
#define PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROFILE, Profile))
#define PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROFILE, ProfileClass))
#define IS_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROFILE))
#define IS_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROFILE))
#define PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROFILE, ProfileClass))

typedef struct _Profile Profile;
typedef struct _ProfileClass ProfileClass;

struct _Settings {
	GObject parent_instance;
	SettingsPrivate * priv;
};

struct _SettingsClass {
	GObjectClass parent_class;
};

struct _SettingsPrivate {
	gchar* _device;
	gint _baudRate;
	gint _dataBits;
	gint _stopBits;
	SettingsParity _parity;
	SettingsHandshake _handshake;
	SettingsAccessMode _accessMode;
	gboolean _localEcho;
	gboolean _autoConnect;
};

static gint Settings_private_offset;
static gpointer settings_parent_class = NULL;
VALA_EXTERN gchar* settings_DEFAULT_DEVICEFILE;
gchar* settings_DEFAULT_DEVICEFILE = NULL;
VALA_EXTERN gint settings_DEFAULT_BAUDRATE;
gint settings_DEFAULT_BAUDRATE = 1200;
VALA_EXTERN gint settings_DEFAULT_DATABITS;
gint settings_DEFAULT_DATABITS = 8;
VALA_EXTERN gint settings_DEFAULT_STOPBITS;
gint settings_DEFAULT_STOPBITS = 1;
VALA_EXTERN SettingsParity settings_DEFAULT_PARITY;
SettingsParity settings_DEFAULT_PARITY = SETTINGS_PARITY_NONE;
VALA_EXTERN SettingsHandshake settings_DEFAULT_HANDSHAKE;
SettingsHandshake settings_DEFAULT_HANDSHAKE = SETTINGS_HANDSHAKE_HARDWARE;
VALA_EXTERN SettingsAccessMode settings_DEFAULT_ACCESSMODE;
SettingsAccessMode settings_DEFAULT_ACCESSMODE = SETTINGS_ACCESS_MODE_READWRITE;
VALA_EXTERN gboolean settings_DEFAULT_LOCAL_ECHO;
gboolean settings_DEFAULT_LOCAL_ECHO = FALSE;
VALA_EXTERN gboolean settings_DEFAULT_AUTO_CONNECT;
gboolean settings_DEFAULT_AUTO_CONNECT = FALSE;

VALA_EXTERN GType settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Settings, g_object_unref)
VALA_EXTERN GType settings_parity_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType settings_handshake_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType settings_access_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Settings* settings_new (const gchar* device,
                        gint baudRate,
                        gint dataBits,
                        gint stopBits,
                        SettingsParity parity,
                        SettingsHandshake handshake,
                        SettingsAccessMode accessMode,
                        gboolean localEcho,
                        gboolean autoConnect);
VALA_EXTERN Settings* settings_construct (GType object_type,
                              const gchar* device,
                              gint baudRate,
                              gint dataBits,
                              gint stopBits,
                              SettingsParity parity,
                              SettingsHandshake handshake,
                              SettingsAccessMode accessMode,
                              gboolean localEcho,
                              gboolean autoConnect);
VALA_EXTERN gchar* settings_parityToChar (Settings* self);
VALA_EXTERN SettingsParity settings_get_parity (Settings* self);
VALA_EXTERN gchar* settings_getStatusbarString (Settings* self,
                                    gboolean open);
VALA_EXTERN const gchar* settings_get_device (Settings* self);
VALA_EXTERN gint settings_get_baudRate (Settings* self);
VALA_EXTERN gint settings_get_dataBits (Settings* self);
VALA_EXTERN gint settings_get_stopBits (Settings* self);
VALA_EXTERN GType profile_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Profile, g_object_unref)
VALA_EXTERN void settings_saveToProfile (Settings* self,
                             Profile* profile);
VALA_EXTERN void profile_setString (Profile* self,
                        const gchar* group,
                        const gchar* key,
                        const gchar* new_val);
VALA_EXTERN void profile_setInteger (Profile* self,
                         const gchar* group,
                         const gchar* key,
                         gint new_val);
VALA_EXTERN SettingsHandshake settings_get_handshake (Settings* self);
VALA_EXTERN SettingsAccessMode settings_get_accessMode (Settings* self);
VALA_EXTERN void profile_setBoolean (Profile* self,
                         const gchar* group,
                         const gchar* key,
                         gboolean new_val);
VALA_EXTERN gboolean settings_get_localEcho (Settings* self);
VALA_EXTERN gboolean settings_get_autoConnect (Settings* self);
VALA_EXTERN Settings* settings_loadFromProfile (Profile* profile);
VALA_EXTERN gchar* profile_getString (Profile* self,
                          const gchar* group,
                          const gchar* key);
VALA_EXTERN gint profile_getInteger (Profile* self,
                         const gchar* group,
                         const gchar* key,
                         gint default_val);
VALA_EXTERN gboolean profile_getBoolean (Profile* self,
                             const gchar* group,
                             const gchar* key,
                             gboolean default_val);
static void settings_set_device (Settings* self,
                          const gchar* value);
static void settings_set_baudRate (Settings* self,
                            gint value);
static void settings_set_dataBits (Settings* self,
                            gint value);
static void settings_set_stopBits (Settings* self,
                            gint value);
static void settings_set_parity (Settings* self,
                          SettingsParity value);
static void settings_set_handshake (Settings* self,
                             SettingsHandshake value);
static void settings_set_accessMode (Settings* self,
                              SettingsAccessMode value);
static void settings_set_localEcho (Settings* self,
                             gboolean value);
static void settings_set_autoConnect (Settings* self,
                               gboolean value);
static GObject * settings_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties);
static void settings_finalize (GObject * obj);
static GType settings_get_type_once (void);
static void _vala_settings_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec);
static void _vala_settings_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec);

const gchar* SETTINGS_ParityModeStrings[5] = {N_ ("None"), N_ ("Odd"), N_ ("Even"), N_ ("Mark"), N_ ("Space")};
const gchar* SETTINGS_AccessModeStrings[3] = {N_ ("Read and Write"), N_ ("Read Only"), N_ ("Write Only")};
const gchar* SETTINGS_DataBitItems[4] = {"5", "6", "7", "8"};
const gchar* SETTINGS_StopBitItems[2] = {"1", "2"};
const gchar* SETTINGS_BaudRateItems[17] = {"300", "600", "1200", "2400", "4800", "9600", "19200", "38400", "57600", "115200", "230400", "460800", "576000", "921600", "1000000", "2000000", "3000000"};

static inline gpointer
settings_get_instance_private (Settings* self)
{
	return G_STRUCT_MEMBER_P (self, Settings_private_offset);
}

static GType
settings_parity_get_type_once (void)
{
	static const GEnumValue values[] = {{SETTINGS_PARITY_NONE, "SETTINGS_PARITY_NONE", "none"}, {SETTINGS_PARITY_ODD, "SETTINGS_PARITY_ODD", "odd"}, {SETTINGS_PARITY_EVEN, "SETTINGS_PARITY_EVEN", "even"}, {SETTINGS_PARITY_MARK, "SETTINGS_PARITY_MARK", "mark"}, {SETTINGS_PARITY_SPACE, "SETTINGS_PARITY_SPACE", "space"}, {0, NULL, NULL}};
	GType settings_parity_type_id;
	settings_parity_type_id = g_enum_register_static ("SettingsParity", values);
	return settings_parity_type_id;
}

GType
settings_parity_get_type (void)
{
	static volatile gsize settings_parity_type_id__volatile = 0;
	if (g_once_init_enter (&settings_parity_type_id__volatile)) {
		GType settings_parity_type_id;
		settings_parity_type_id = settings_parity_get_type_once ();
		g_once_init_leave (&settings_parity_type_id__volatile, settings_parity_type_id);
	}
	return settings_parity_type_id__volatile;
}

static GType
settings_handshake_get_type_once (void)
{
	static const GEnumValue values[] = {{SETTINGS_HANDSHAKE_NONE, "SETTINGS_HANDSHAKE_NONE", "none"}, {SETTINGS_HANDSHAKE_HARDWARE, "SETTINGS_HANDSHAKE_HARDWARE", "hardware"}, {SETTINGS_HANDSHAKE_SOFTWARE, "SETTINGS_HANDSHAKE_SOFTWARE", "software"}, {SETTINGS_HANDSHAKE_BOTH, "SETTINGS_HANDSHAKE_BOTH", "both"}, {0, NULL, NULL}};
	GType settings_handshake_type_id;
	settings_handshake_type_id = g_enum_register_static ("SettingsHandshake", values);
	return settings_handshake_type_id;
}

GType
settings_handshake_get_type (void)
{
	static volatile gsize settings_handshake_type_id__volatile = 0;
	if (g_once_init_enter (&settings_handshake_type_id__volatile)) {
		GType settings_handshake_type_id;
		settings_handshake_type_id = settings_handshake_get_type_once ();
		g_once_init_leave (&settings_handshake_type_id__volatile, settings_handshake_type_id);
	}
	return settings_handshake_type_id__volatile;
}

static GType
settings_access_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{SETTINGS_ACCESS_MODE_READWRITE, "SETTINGS_ACCESS_MODE_READWRITE", "readwrite"}, {SETTINGS_ACCESS_MODE_READONLY, "SETTINGS_ACCESS_MODE_READONLY", "readonly"}, {SETTINGS_ACCESS_MODE_WRITEONLY, "SETTINGS_ACCESS_MODE_WRITEONLY", "writeonly"}, {0, NULL, NULL}};
	GType settings_access_mode_type_id;
	settings_access_mode_type_id = g_enum_register_static ("SettingsAccessMode", values);
	return settings_access_mode_type_id;
}

GType
settings_access_mode_get_type (void)
{
	static volatile gsize settings_access_mode_type_id__volatile = 0;
	if (g_once_init_enter (&settings_access_mode_type_id__volatile)) {
		GType settings_access_mode_type_id;
		settings_access_mode_type_id = settings_access_mode_get_type_once ();
		g_once_init_leave (&settings_access_mode_type_id__volatile, settings_access_mode_type_id);
	}
	return settings_access_mode_type_id__volatile;
}

Settings*
settings_construct (GType object_type,
                    const gchar* device,
                    gint baudRate,
                    gint dataBits,
                    gint stopBits,
                    SettingsParity parity,
                    SettingsHandshake handshake,
                    SettingsAccessMode accessMode,
                    gboolean localEcho,
                    gboolean autoConnect)
{
	Settings * self = NULL;
	self = (Settings*) g_object_new (object_type, "device", device, "baudRate", baudRate, "dataBits", dataBits, "stopBits", stopBits, "parity", parity, "handshake", handshake, "accessMode", accessMode, "localEcho", localEcho, "autoConnect", autoConnect, NULL);
	return self;
}

Settings*
settings_new (const gchar* device,
              gint baudRate,
              gint dataBits,
              gint stopBits,
              SettingsParity parity,
              SettingsHandshake handshake,
              SettingsAccessMode accessMode,
              gboolean localEcho,
              gboolean autoConnect)
{
	return settings_construct (TYPE_SETTINGS, device, baudRate, dataBits, stopBits, parity, handshake, accessMode, localEcho, autoConnect);
}

gchar*
settings_parityToChar (Settings* self)
{
	SettingsParity _tmp0_;
	gchar* _tmp6_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parity;
	switch (_tmp0_) {
		case SETTINGS_PARITY_NONE:
		{
			{
				gchar* _tmp1_;
				_tmp1_ = g_strdup (_ ("N"));
				result = _tmp1_;
				return result;
			}
		}
		case SETTINGS_PARITY_ODD:
		{
			{
				gchar* _tmp2_;
				_tmp2_ = g_strdup (_ ("O"));
				result = _tmp2_;
				return result;
			}
		}
		case SETTINGS_PARITY_EVEN:
		{
			{
				gchar* _tmp3_;
				_tmp3_ = g_strdup (_ ("E"));
				result = _tmp3_;
				return result;
			}
		}
		case SETTINGS_PARITY_MARK:
		{
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup (_ ("M"));
				result = _tmp4_;
				return result;
			}
		}
		case SETTINGS_PARITY_SPACE:
		{
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup (_ ("S"));
				result = _tmp5_;
				return result;
			}
		}
		default:
		break;
	}
	_tmp6_ = g_strdup ("?");
	result = _tmp6_;
	return result;
}

gchar*
settings_getStatusbarString (Settings* self,
                             gboolean open)
{
	gchar* r = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gint _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	_tmp1_ = g_strdup_printf ("%s", _tmp0_);
	_g_free0 (r);
	r = _tmp1_;
	if (open) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp2_ = r;
		_tmp3_ = g_strconcat (_tmp2_, " ", NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat (_tmp4_, _ ("OPEN"), NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat (_tmp6_, " ", NULL);
		_g_free0 (r);
		r = _tmp7_;
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
	} else {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp8_ = r;
		_tmp9_ = g_strconcat (_tmp8_, " ", NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp10_, _ ("CLOSED"), NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat (_tmp12_, " ", NULL);
		_g_free0 (r);
		r = _tmp13_;
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
	}
	_tmp14_ = r;
	_tmp15_ = self->priv->_baudRate;
	_tmp16_ = self->priv->_dataBits;
	_tmp17_ = settings_parityToChar (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = self->priv->_stopBits;
	_tmp20_ = g_strdup_printf ("%i,%i%s%i", _tmp15_, _tmp16_, _tmp18_, _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat (_tmp14_, _tmp21_, NULL);
	_g_free0 (r);
	r = _tmp22_;
	_g_free0 (_tmp21_);
	_g_free0 (_tmp18_);
	result = r;
	return result;
}

void
settings_saveToProfile (Settings* self,
                        Profile* profile)
{
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	SettingsParity _tmp4_;
	SettingsHandshake _tmp5_;
	SettingsAccessMode _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (profile != NULL);
	_tmp0_ = self->priv->_device;
	profile_setString (profile, "port_settings", "device", _tmp0_);
	_tmp1_ = self->priv->_baudRate;
	profile_setInteger (profile, "port_settings", "baud_rate", _tmp1_);
	_tmp2_ = self->priv->_dataBits;
	profile_setInteger (profile, "port_settings", "data_bits", _tmp2_);
	_tmp3_ = self->priv->_stopBits;
	profile_setInteger (profile, "port_settings", "stop_bits", _tmp3_);
	_tmp4_ = self->priv->_parity;
	profile_setInteger (profile, "port_settings", "parity", (gint) _tmp4_);
	_tmp5_ = self->priv->_handshake;
	profile_setInteger (profile, "port_settings", "handshake", (gint) _tmp5_);
	_tmp6_ = self->priv->_accessMode;
	profile_setInteger (profile, "port_settings", "access_mode", (gint) _tmp6_);
	_tmp7_ = self->priv->_localEcho;
	profile_setBoolean (profile, "port_settings", "local_echo", _tmp7_);
	_tmp8_ = self->priv->_autoConnect;
	profile_setBoolean (profile, "port_settings", "auto_connect", _tmp8_);
}

Settings*
settings_loadFromProfile (Profile* profile)
{
	gchar* device = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gint baudRate = 0;
	gint dataBits = 0;
	gint stopBits = 0;
	SettingsParity parity = 0;
	SettingsHandshake handshake = 0;
	SettingsAccessMode accessMode = 0;
	gboolean localEcho = FALSE;
	gboolean autoConnect = FALSE;
	gchar* _tmp2_;
	SettingsParity _tmp3_;
	SettingsHandshake _tmp4_;
	SettingsAccessMode _tmp5_;
	const gchar* _tmp6_;
	Settings* _tmp7_;
	Settings* result = NULL;
	g_return_val_if_fail (profile != NULL, NULL);
	_tmp0_ = settings_DEFAULT_DEVICEFILE;
	_tmp1_ = g_strdup (_tmp0_);
	device = _tmp1_;
	_tmp2_ = profile_getString (profile, "port_settings", "device");
	_g_free0 (device);
	device = _tmp2_;
	baudRate = profile_getInteger (profile, "port_settings", "baud_rate", settings_DEFAULT_BAUDRATE);
	dataBits = profile_getInteger (profile, "port_settings", "data_bits", settings_DEFAULT_DATABITS);
	stopBits = profile_getInteger (profile, "port_settings", "stop_bits", settings_DEFAULT_STOPBITS);
	_tmp3_ = settings_DEFAULT_PARITY;
	parity = (SettingsParity) profile_getInteger (profile, "port_settings", "parity", (gint) _tmp3_);
	_tmp4_ = settings_DEFAULT_HANDSHAKE;
	handshake = (SettingsHandshake) profile_getInteger (profile, "port_settings", "handshake", (gint) _tmp4_);
	_tmp5_ = settings_DEFAULT_ACCESSMODE;
	accessMode = (SettingsAccessMode) profile_getInteger (profile, "port_settings", "access_mode", (gint) _tmp5_);
	localEcho = profile_getBoolean (profile, "port_settings", "local_echo", settings_DEFAULT_LOCAL_ECHO);
	autoConnect = profile_getBoolean (profile, "port_settings", "auto_connect", settings_DEFAULT_AUTO_CONNECT);
	_tmp6_ = device;
	_tmp7_ = settings_new (_tmp6_, baudRate, dataBits, stopBits, parity, handshake, accessMode, localEcho, autoConnect);
	result = _tmp7_;
	_g_free0 (device);
	return result;
}

const gchar*
settings_get_device (Settings* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	result = _tmp0_;
	return result;
}

static void
settings_set_device (Settings* self,
                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = settings_get_device (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_device);
		self->priv->_device = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, settings_properties[SETTINGS_DEVICE_PROPERTY]);
	}
}

gint
settings_get_baudRate (Settings* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_baudRate;
	return result;
}

static void
settings_set_baudRate (Settings* self,
                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = settings_get_baudRate (self);
	if (old_value != value) {
		self->priv->_baudRate = value;
		g_object_notify_by_pspec ((GObject *) self, settings_properties[SETTINGS_BAUD_RATE_PROPERTY]);
	}
}

gint
settings_get_dataBits (Settings* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_dataBits;
	return result;
}

static void
settings_set_dataBits (Settings* self,
                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = settings_get_dataBits (self);
	if (old_value != value) {
		self->priv->_dataBits = value;
		g_object_notify_by_pspec ((GObject *) self, settings_properties[SETTINGS_DATA_BITS_PROPERTY]);
	}
}

gint
settings_get_stopBits (Settings* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_stopBits;
	return result;
}

static void
settings_set_stopBits (Settings* self,
                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = settings_get_stopBits (self);
	if (old_value != value) {
		self->priv->_stopBits = value;
		g_object_notify_by_pspec ((GObject *) self, settings_properties[SETTINGS_STOP_BITS_PROPERTY]);
	}
}

SettingsParity
settings_get_parity (Settings* self)
{
	SettingsParity result;
	SettingsParity _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_parity;
	result = _tmp0_;
	return result;
}

static void
settings_set_parity (Settings* self,
                     SettingsParity value)
{
	SettingsParity old_value;
	g_return_if_fail (self != NULL);
	old_value = settings_get_parity (self);
	if (old_value != value) {
		self->priv->_parity = value;
		g_object_notify_by_pspec ((GObject *) self, settings_properties[SETTINGS_PARITY_PROPERTY]);
	}
}

SettingsHandshake
settings_get_handshake (Settings* self)
{
	SettingsHandshake result;
	SettingsHandshake _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_handshake;
	result = _tmp0_;
	return result;
}

static void
settings_set_handshake (Settings* self,
                        SettingsHandshake value)
{
	SettingsHandshake old_value;
	g_return_if_fail (self != NULL);
	old_value = settings_get_handshake (self);
	if (old_value != value) {
		self->priv->_handshake = value;
		g_object_notify_by_pspec ((GObject *) self, settings_properties[SETTINGS_HANDSHAKE_PROPERTY]);
	}
}

SettingsAccessMode
settings_get_accessMode (Settings* self)
{
	SettingsAccessMode result;
	SettingsAccessMode _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_accessMode;
	result = _tmp0_;
	return result;
}

static void
settings_set_accessMode (Settings* self,
                         SettingsAccessMode value)
{
	SettingsAccessMode old_value;
	g_return_if_fail (self != NULL);
	old_value = settings_get_accessMode (self);
	if (old_value != value) {
		self->priv->_accessMode = value;
		g_object_notify_by_pspec ((GObject *) self, settings_properties[SETTINGS_ACCESS_MODE_PROPERTY]);
	}
}

gboolean
settings_get_localEcho (Settings* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_localEcho;
	return result;
}

static void
settings_set_localEcho (Settings* self,
                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = settings_get_localEcho (self);
	if (old_value != value) {
		self->priv->_localEcho = value;
		g_object_notify_by_pspec ((GObject *) self, settings_properties[SETTINGS_LOCAL_ECHO_PROPERTY]);
	}
}

gboolean
settings_get_autoConnect (Settings* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_autoConnect;
	return result;
}

static void
settings_set_autoConnect (Settings* self,
                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = settings_get_autoConnect (self);
	if (old_value != value) {
		self->priv->_autoConnect = value;
		g_object_notify_by_pspec ((GObject *) self, settings_properties[SETTINGS_AUTO_CONNECT_PROPERTY]);
	}
}

static GObject *
settings_constructor (GType type,
                      guint n_construct_properties,
                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	Settings * self;
	const gchar* _tmp0_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	parent_class = G_OBJECT_CLASS (settings_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SETTINGS, Settings);
	_tmp0_ = self->priv->_device;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		_tmp1_ = settings_DEFAULT_DEVICEFILE;
		settings_set_device (self, _tmp1_);
	}
	_tmp2_ = self->priv->_baudRate;
	if (_tmp2_ == 0) {
		settings_set_baudRate (self, settings_DEFAULT_BAUDRATE);
	}
	_tmp3_ = self->priv->_dataBits;
	if (_tmp3_ == 0) {
		settings_set_dataBits (self, settings_DEFAULT_DATABITS);
	}
	_tmp4_ = self->priv->_stopBits;
	if (_tmp4_ == 0) {
		settings_set_stopBits (self, settings_DEFAULT_STOPBITS);
	}
	return obj;
}

static void
settings_class_init (SettingsClass * klass,
                     gpointer klass_data)
{
	gchar* _tmp0_;
	settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Settings_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_settings_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_settings_set_property;
	G_OBJECT_CLASS (klass)->constructor = settings_constructor;
	G_OBJECT_CLASS (klass)->finalize = settings_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_DEVICE_PROPERTY, settings_properties[SETTINGS_DEVICE_PROPERTY] = g_param_spec_string ("device", "device", "device", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_BAUD_RATE_PROPERTY, settings_properties[SETTINGS_BAUD_RATE_PROPERTY] = g_param_spec_int ("baudRate", "baudRate", "baudRate", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_DATA_BITS_PROPERTY, settings_properties[SETTINGS_DATA_BITS_PROPERTY] = g_param_spec_int ("dataBits", "dataBits", "dataBits", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_STOP_BITS_PROPERTY, settings_properties[SETTINGS_STOP_BITS_PROPERTY] = g_param_spec_int ("stopBits", "stopBits", "stopBits", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_PARITY_PROPERTY, settings_properties[SETTINGS_PARITY_PROPERTY] = g_param_spec_enum ("parity", "parity", "parity", SETTINGS_TYPE_PARITY, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_HANDSHAKE_PROPERTY, settings_properties[SETTINGS_HANDSHAKE_PROPERTY] = g_param_spec_enum ("handshake", "handshake", "handshake", SETTINGS_TYPE_HANDSHAKE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_ACCESS_MODE_PROPERTY, settings_properties[SETTINGS_ACCESS_MODE_PROPERTY] = g_param_spec_enum ("accessMode", "accessMode", "accessMode", SETTINGS_TYPE_ACCESS_MODE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_LOCAL_ECHO_PROPERTY, settings_properties[SETTINGS_LOCAL_ECHO_PROPERTY] = g_param_spec_boolean ("localEcho", "localEcho", "localEcho", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_AUTO_CONNECT_PROPERTY, settings_properties[SETTINGS_AUTO_CONNECT_PROPERTY] = g_param_spec_boolean ("autoConnect", "autoConnect", "autoConnect", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = g_strdup ("/dev/ttyS0");
	settings_DEFAULT_DEVICEFILE = _tmp0_;
}

static void
settings_instance_init (Settings * self,
                        gpointer klass)
{
	self->priv = settings_get_instance_private (self);
}

static void
settings_finalize (GObject * obj)
{
	Settings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SETTINGS, Settings);
	_g_free0 (self->priv->_device);
	G_OBJECT_CLASS (settings_parent_class)->finalize (obj);
}

static GType
settings_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Settings), 0, (GInstanceInitFunc) settings_instance_init, NULL };
	GType settings_type_id;
	settings_type_id = g_type_register_static (G_TYPE_OBJECT, "Settings", &g_define_type_info, 0);
	Settings_private_offset = g_type_add_instance_private (settings_type_id, sizeof (SettingsPrivate));
	return settings_type_id;
}

GType
settings_get_type (void)
{
	static volatile gsize settings_type_id__volatile = 0;
	if (g_once_init_enter (&settings_type_id__volatile)) {
		GType settings_type_id;
		settings_type_id = settings_get_type_once ();
		g_once_init_leave (&settings_type_id__volatile, settings_type_id);
	}
	return settings_type_id__volatile;
}

static void
_vala_settings_get_property (GObject * object,
                             guint property_id,
                             GValue * value,
                             GParamSpec * pspec)
{
	Settings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SETTINGS, Settings);
	switch (property_id) {
		case SETTINGS_DEVICE_PROPERTY:
		g_value_set_string (value, settings_get_device (self));
		break;
		case SETTINGS_BAUD_RATE_PROPERTY:
		g_value_set_int (value, settings_get_baudRate (self));
		break;
		case SETTINGS_DATA_BITS_PROPERTY:
		g_value_set_int (value, settings_get_dataBits (self));
		break;
		case SETTINGS_STOP_BITS_PROPERTY:
		g_value_set_int (value, settings_get_stopBits (self));
		break;
		case SETTINGS_PARITY_PROPERTY:
		g_value_set_enum (value, settings_get_parity (self));
		break;
		case SETTINGS_HANDSHAKE_PROPERTY:
		g_value_set_enum (value, settings_get_handshake (self));
		break;
		case SETTINGS_ACCESS_MODE_PROPERTY:
		g_value_set_enum (value, settings_get_accessMode (self));
		break;
		case SETTINGS_LOCAL_ECHO_PROPERTY:
		g_value_set_boolean (value, settings_get_localEcho (self));
		break;
		case SETTINGS_AUTO_CONNECT_PROPERTY:
		g_value_set_boolean (value, settings_get_autoConnect (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_settings_set_property (GObject * object,
                             guint property_id,
                             const GValue * value,
                             GParamSpec * pspec)
{
	Settings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SETTINGS, Settings);
	switch (property_id) {
		case SETTINGS_DEVICE_PROPERTY:
		settings_set_device (self, g_value_get_string (value));
		break;
		case SETTINGS_BAUD_RATE_PROPERTY:
		settings_set_baudRate (self, g_value_get_int (value));
		break;
		case SETTINGS_DATA_BITS_PROPERTY:
		settings_set_dataBits (self, g_value_get_int (value));
		break;
		case SETTINGS_STOP_BITS_PROPERTY:
		settings_set_stopBits (self, g_value_get_int (value));
		break;
		case SETTINGS_PARITY_PROPERTY:
		settings_set_parity (self, g_value_get_enum (value));
		break;
		case SETTINGS_HANDSHAKE_PROPERTY:
		settings_set_handshake (self, g_value_get_enum (value));
		break;
		case SETTINGS_ACCESS_MODE_PROPERTY:
		settings_set_accessMode (self, g_value_get_enum (value));
		break;
		case SETTINGS_LOCAL_ECHO_PROPERTY:
		settings_set_localEcho (self, g_value_get_boolean (value));
		break;
		case SETTINGS_AUTO_CONNECT_PROPERTY:
		settings_set_autoConnect (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

