#!/usr/bin/env python3
import sys
import os
import glob

try:
    """ TIPC C-API library path searching """
    dir_name = os.path.dirname(os.path.abspath(__file__))
    pylib_path = glob.glob('%s%s'%(dir_name,'/../../../pytipc/build/lib*'))[0]
    sys.path.append(pylib_path)
except:
    pass

from tipc import *

SERVER_TYPE = 18888
SERVER_INST = 17
BUF_SIZE    = 40
TIMEOUT     = 10

def pyapi_hello_world_client():
    print("****** TIPC hello world client started ******")
    buf = "Hello World!!!"

    c = TipcConn(SOCK_RDM)
    srv = TipcAddr(SERVER_TYPE, SERVER_INST)
    up = srv_wait(srv, TIMEOUT * 1000)
    if up is True:
        c.sendto(buf, srv)
    else:
        print >> sys.stderr, "%s did not come up within %ds!" %(srv, TIMEOUT)
        sys.exit()

    print("Client: sent message: %s" %buf)
    ret, msg = c.recv()
    if ret <= 0:
        print("Client: unexpected response")
        sys.exit(1);

    print("Client: received response: %s" %msg.decode('utf-8'))
    print("****** TIPC hello client finished ******\n")


if __name__== "__main__":
    pyapi_hello_world_client()
