/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.internal.ant.org.eclipse.aether.internal.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Named;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.RepositorySystemSession;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.artifact.Artifact;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.metadata.Metadata;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.repository.RemoteRepository;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.spi.connector.layout.RepositoryLayout;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.spi.connector.layout.RepositoryLayoutFactory;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.transfer.NoRepositoryLayoutException;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.util.ConfigUtils;

@Named(value="maven2")
public final class Maven2RepositoryLayoutFactory
implements RepositoryLayoutFactory {
    static final String CONFIG_PROP_SIGNATURE_CHECKSUMS = "aether.checksums.forSignature";
    static final String CONFIG_PROP_CHECKSUMS_ALGORITHMS = "aether.checksums.algorithms";
    static final String DEFAULT_CHECKSUMS_ALGORITHMS = "SHA-1,MD5";
    private float priority;

    @Override
    public float getPriority() {
        return this.priority;
    }

    public Maven2RepositoryLayoutFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public RepositoryLayout newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryLayoutException {
        if (!"default".equals(repository.getContentType())) {
            throw new NoRepositoryLayoutException(repository);
        }
        boolean forSignature = ConfigUtils.getBoolean(session, false, CONFIG_PROP_SIGNATURE_CHECKSUMS);
        List<String> checksumsAlgorithms = Arrays.asList(ConfigUtils.getString(session, DEFAULT_CHECKSUMS_ALGORITHMS, CONFIG_PROP_CHECKSUMS_ALGORITHMS).split(","));
        return forSignature ? new Maven2RepositoryLayout(checksumsAlgorithms) : new Maven2RepositoryLayoutEx(checksumsAlgorithms);
    }

    private static class Maven2RepositoryLayoutEx
    extends Maven2RepositoryLayout {
        protected Maven2RepositoryLayoutEx(List<String> checksumsAlgorithms) {
            super(checksumsAlgorithms);
        }

        @Override
        public List<RepositoryLayout.Checksum> getChecksums(Artifact artifact, boolean upload, URI location) {
            if (this.isSignature(artifact.getExtension())) {
                return Collections.emptyList();
            }
            return super.getChecksums(artifact, upload, location);
        }

        private boolean isSignature(String extension) {
            return extension.endsWith(".asc");
        }
    }

    private static class Maven2RepositoryLayout
    implements RepositoryLayout {
        private final List<String> checksumsAlgorithms;

        protected Maven2RepositoryLayout(List<String> checksumsAlgorithms) {
            this.checksumsAlgorithms = checksumsAlgorithms;
        }

        private URI toUri(String path) {
            try {
                return new URI(null, null, path, null);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public URI getLocation(Artifact artifact, boolean upload) {
            StringBuilder path = new StringBuilder(128);
            path.append(artifact.getGroupId().replace('.', '/')).append('/');
            path.append(artifact.getArtifactId()).append('/');
            path.append(artifact.getBaseVersion()).append('/');
            path.append(artifact.getArtifactId()).append('-').append(artifact.getVersion());
            if (artifact.getClassifier().length() > 0) {
                path.append('-').append(artifact.getClassifier());
            }
            if (artifact.getExtension().length() > 0) {
                path.append('.').append(artifact.getExtension());
            }
            return this.toUri(path.toString());
        }

        @Override
        public URI getLocation(Metadata metadata, boolean upload) {
            StringBuilder path = new StringBuilder(128);
            if (metadata.getGroupId().length() > 0) {
                path.append(metadata.getGroupId().replace('.', '/')).append('/');
                if (metadata.getArtifactId().length() > 0) {
                    path.append(metadata.getArtifactId()).append('/');
                    if (metadata.getVersion().length() > 0) {
                        path.append(metadata.getVersion()).append('/');
                    }
                }
            }
            path.append(metadata.getType());
            return this.toUri(path.toString());
        }

        @Override
        public List<RepositoryLayout.Checksum> getChecksums(Artifact artifact, boolean upload, URI location) {
            return this.getChecksums(location);
        }

        @Override
        public List<RepositoryLayout.Checksum> getChecksums(Metadata metadata, boolean upload, URI location) {
            return this.getChecksums(location);
        }

        private List<RepositoryLayout.Checksum> getChecksums(URI location) {
            ArrayList<RepositoryLayout.Checksum> checksums = new ArrayList<RepositoryLayout.Checksum>(this.checksumsAlgorithms.size());
            for (String algorithm : this.checksumsAlgorithms) {
                checksums.add(RepositoryLayout.Checksum.forLocation(location, algorithm));
            }
            return checksums;
        }
    }
}

