(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require map.Map.
Require int.Int.
Require list.List.
Require list.Length.
Require list.Mem.
Require list.Nth.
Require option.Option.
Require list.NthLength.
Require list.Append.
Require list.NthLengthAppend.

(* Why3 assumption *)
Definition unit := unit.

Axiom qtmark : Type.
Parameter qtmark_WhyType : WhyType qtmark.
Existing Instance qtmark_WhyType.

Axiom func : forall (a:Type) (b:Type), Type.
Parameter func_WhyType : forall (a:Type) {a_WT:WhyType a}
  (b:Type) {b_WT:WhyType b}, WhyType (func a b).
Existing Instance func_WhyType.

(* Why3 assumption *)
Definition pred (a:Type) := (func a bool).

Parameter infix_at: forall {a:Type} {a_WT:WhyType a}
  {b:Type} {b_WT:WhyType b}, (func a b) -> a -> b.

Axiom map : forall (a:Type) (b:Type), Type.
Parameter map_WhyType : forall (a:Type) {a_WT:WhyType a}
  (b:Type) {b_WT:WhyType b}, WhyType (map a b).
Existing Instance map_WhyType.

Parameter get: forall {a:Type} {a_WT:WhyType a} {b:Type} {b_WT:WhyType b},
  (map a b) -> a -> b.

Parameter set: forall {a:Type} {a_WT:WhyType a} {b:Type} {b_WT:WhyType b},
  (map a b) -> a -> b -> (map a b).

Axiom Select_eq : forall {a:Type} {a_WT:WhyType a} {b:Type} {b_WT:WhyType b},
  forall (m:(map a b)), forall (a1:a) (a2:a), forall (b1:b), (a1 = a2) ->
  ((get (set m a1 b1) a2) = b1).

Axiom Select_neq : forall {a:Type} {a_WT:WhyType a}
  {b:Type} {b_WT:WhyType b}, forall (m:(map a b)), forall (a1:a) (a2:a),
  forall (b1:b), (~ (a1 = a2)) -> ((get (set m a1 b1) a2) = (get m a2)).

Parameter const: forall {a:Type} {a_WT:WhyType a} {b:Type} {b_WT:WhyType b},
  b -> (map a b).

Axiom Const : forall {a:Type} {a_WT:WhyType a} {b:Type} {b_WT:WhyType b},
  forall (b1:b) (a1:a), ((get (const b1: (map a b)) a1) = b1).

(* Why3 assumption *)
Inductive id :=
  | Id : Z -> id.
Axiom id_WhyType : WhyType id.
Existing Instance id_WhyType.

(* Why3 assumption *)
Definition state := (map id Z).

(* Why3 assumption *)
Definition pos := Z.

(* Why3 assumption *)
Definition stack := (list Z).

(* Why3 assumption *)
Inductive machine_state :=
  | VMS : Z -> (list Z) -> (map id Z) -> machine_state.
Axiom machine_state_WhyType : WhyType machine_state.
Existing Instance machine_state_WhyType.

(* Why3 assumption *)
Inductive instr :=
  | Iconst : Z -> instr
  | Ivar : id -> instr
  | Isetvar : id -> instr
  | Ibranch : Z -> instr
  | Iadd : instr
  | Isub : instr
  | Imul : instr
  | Ibeq : Z -> instr
  | Ibne : Z -> instr
  | Ible : Z -> instr
  | Ibgt : Z -> instr
  | Ihalt : instr.
Axiom instr_WhyType : WhyType instr.
Existing Instance instr_WhyType.

(* Why3 assumption *)
Definition code := (list instr).

(* Why3 assumption *)
Inductive codeseq_at: (list instr) -> Z -> (list instr) -> Prop :=
  | codeseq_at_intro : forall (c1:(list instr)) (c2:(list instr))
      (c3:(list instr)), (codeseq_at
      (Init.Datatypes.app (Init.Datatypes.app c1 c2) c3)
      (list.Length.length c1) c2).

Axiom codeseq_at_app_right : forall (c:(list instr)) (c1:(list instr))
  (c2:(list instr)) (p:Z), (codeseq_at c p (Init.Datatypes.app c1 c2)) ->
  (codeseq_at c (p + (list.Length.length c1))%Z c2).

Axiom codeseq_at_app_left : forall (c:(list instr)) (c1:(list instr))
  (c2:(list instr)) (p:Z), (codeseq_at c p (Init.Datatypes.app c1 c2)) ->
  (codeseq_at c p c1).

(* Why3 assumption *)
Definition iconst (n:Z): (list instr) :=
  (Init.Datatypes.cons (Iconst n) Init.Datatypes.nil).

(* Why3 assumption *)
Definition ivar (x:id): (list instr) :=
  (Init.Datatypes.cons (Ivar x) Init.Datatypes.nil).

(* Why3 assumption *)
Definition isetvar (x:id): (list instr) :=
  (Init.Datatypes.cons (Isetvar x) Init.Datatypes.nil).

(* Why3 assumption *)
Definition ibeq (ofs:Z): (list instr) :=
  (Init.Datatypes.cons (Ibeq ofs) Init.Datatypes.nil).

(* Why3 assumption *)
Definition ible (ofs:Z): (list instr) :=
  (Init.Datatypes.cons (Ible ofs) Init.Datatypes.nil).

(* Why3 assumption *)
Definition ibne (ofs:Z): (list instr) :=
  (Init.Datatypes.cons (Ibne ofs) Init.Datatypes.nil).

(* Why3 assumption *)
Definition ibgt (ofs:Z): (list instr) :=
  (Init.Datatypes.cons (Ibgt ofs) Init.Datatypes.nil).

(* Why3 assumption *)
Definition ibranch (ofs:Z): (list instr) :=
  (Init.Datatypes.cons (Ibranch ofs) Init.Datatypes.nil).

(* Why3 assumption *)
Inductive transition: (list instr) -> machine_state -> machine_state ->
  Prop :=
  | trans_const : forall (c:(list instr)) (p:Z) (n:Z), (codeseq_at c p
      (iconst n)) -> forall (s:(list Z)) (m:(map id Z)), (transition c (VMS p
      s m) (VMS (p + 1%Z)%Z (Init.Datatypes.cons n s) m))
  | trans_var : forall (c:(list instr)) (p:Z) (x:id), (codeseq_at c p
      (ivar x)) -> forall (s:(list Z)) (m:(map id Z)), (transition c (VMS p s
      m) (VMS (p + 1%Z)%Z (Init.Datatypes.cons (get m x) s) m))
  | trans_set_var : forall (c:(list instr)) (p:Z) (x:id), (codeseq_at c p
      (isetvar x)) -> forall (n:Z) (s:(list Z)) (m:(map id Z)), (transition c
      (VMS p (Init.Datatypes.cons n s) m) (VMS (p + 1%Z)%Z s (set m x n)))
  | trans_add : forall (c:(list instr)) (p:Z), (codeseq_at c p
      (Init.Datatypes.cons Iadd Init.Datatypes.nil)) -> forall (n1:Z) (n2:Z)
      (s:(list Z)) (m:(map id Z)), (transition c (VMS p
      (Init.Datatypes.cons n2 (Init.Datatypes.cons n1 s)) m) (VMS (p + 1%Z)%Z
      (Init.Datatypes.cons (n1 + n2)%Z s) m))
  | trans_sub : forall (c:(list instr)) (p:Z), (codeseq_at c p
      (Init.Datatypes.cons Isub Init.Datatypes.nil)) -> forall (n1:Z) (n2:Z)
      (s:(list Z)) (m:(map id Z)), (transition c (VMS p
      (Init.Datatypes.cons n2 (Init.Datatypes.cons n1 s)) m) (VMS (p + 1%Z)%Z
      (Init.Datatypes.cons (n1 - n2)%Z s) m))
  | trans_mul : forall (c:(list instr)) (p:Z), (codeseq_at c p
      (Init.Datatypes.cons Imul Init.Datatypes.nil)) -> forall (n1:Z) (n2:Z)
      (s:(list Z)) (m:(map id Z)), (transition c (VMS p
      (Init.Datatypes.cons n2 (Init.Datatypes.cons n1 s)) m) (VMS (p + 1%Z)%Z
      (Init.Datatypes.cons (n1 * n2)%Z s) m))
  | trans_beq : forall (c:(list instr)) (p1:Z) (ofs:Z), (codeseq_at c p1
      (ibeq ofs)) -> forall (s:(list Z)) (m:(map id Z)) (n1:Z) (n2:Z),
      (n1 = n2) -> (transition c (VMS p1
      (Init.Datatypes.cons n2 (Init.Datatypes.cons n1 s)) m)
      (VMS ((p1 + 1%Z)%Z + ofs)%Z s m))
  | trans_beq1 : forall (c:(list instr)) (p1:Z) (ofs:Z), (codeseq_at c p1
      (ibeq ofs)) -> forall (s:(list Z)) (m:(map id Z)) (n1:Z) (n2:Z),
      (~ (n1 = n2)) -> (transition c (VMS p1
      (Init.Datatypes.cons n2 (Init.Datatypes.cons n1 s)) m)
      (VMS (p1 + 1%Z)%Z s m))
  | trans_bne : forall (c:(list instr)) (p1:Z) (ofs:Z), (codeseq_at c p1
      (ibne ofs)) -> forall (s:(list Z)) (m:(map id Z)) (n1:Z) (n2:Z),
      (n1 = n2) -> (transition c (VMS p1
      (Init.Datatypes.cons n2 (Init.Datatypes.cons n1 s)) m)
      (VMS (p1 + 1%Z)%Z s m))
  | trans_bne1 : forall (c:(list instr)) (p1:Z) (ofs:Z), (codeseq_at c p1
      (ibne ofs)) -> forall (s:(list Z)) (m:(map id Z)) (n1:Z) (n2:Z),
      (~ (n1 = n2)) -> (transition c (VMS p1
      (Init.Datatypes.cons n2 (Init.Datatypes.cons n1 s)) m)
      (VMS ((p1 + 1%Z)%Z + ofs)%Z s m))
  | trans_ble : forall (c:(list instr)) (p1:Z) (ofs:Z), (codeseq_at c p1
      (ible ofs)) -> forall (s:(list Z)) (m:(map id Z)) (n1:Z) (n2:Z),
      (n1 <= n2)%Z -> (transition c (VMS p1
      (Init.Datatypes.cons n2 (Init.Datatypes.cons n1 s)) m)
      (VMS ((p1 + 1%Z)%Z + ofs)%Z s m))
  | trans_ble1 : forall (c:(list instr)) (p1:Z) (ofs:Z), (codeseq_at c p1
      (ible ofs)) -> forall (s:(list Z)) (m:(map id Z)) (n1:Z) (n2:Z),
      (~ (n1 <= n2)%Z) -> (transition c (VMS p1
      (Init.Datatypes.cons n2 (Init.Datatypes.cons n1 s)) m)
      (VMS (p1 + 1%Z)%Z s m))
  | trans_bgt : forall (c:(list instr)) (p1:Z) (ofs:Z), (codeseq_at c p1
      (ibgt ofs)) -> forall (s:(list Z)) (m:(map id Z)) (n1:Z) (n2:Z),
      (n1 <= n2)%Z -> (transition c (VMS p1
      (Init.Datatypes.cons n2 (Init.Datatypes.cons n1 s)) m)
      (VMS (p1 + 1%Z)%Z s m))
  | trans_bgt1 : forall (c:(list instr)) (p1:Z) (ofs:Z), (codeseq_at c p1
      (ibgt ofs)) -> forall (s:(list Z)) (m:(map id Z)) (n1:Z) (n2:Z),
      (~ (n1 <= n2)%Z) -> (transition c (VMS p1
      (Init.Datatypes.cons n2 (Init.Datatypes.cons n1 s)) m)
      (VMS ((p1 + 1%Z)%Z + ofs)%Z s m))
  | trans_branch : forall (c:(list instr)) (p:Z) (ofs:Z), (codeseq_at c p
      (ibranch ofs)) -> forall (s:(list Z)) (m:(map id Z)), (transition c
      (VMS p s m) (VMS ((p + 1%Z)%Z + ofs)%Z s m)).

(* Why3 assumption *)
Inductive transition_star: (list instr) -> machine_state -> machine_state ->
  Prop :=
  | Refl : forall (p:(list instr)) (x:machine_state), (transition_star p x x)
  | Step : forall (p:(list instr)) (x:machine_state) (y:machine_state)
      (z:machine_state), (transition p x y) -> ((transition_star p y z) ->
      (transition_star p x z)).

Axiom transition_star_one : forall (p:(list instr)) (s1:machine_state)
  (s2:machine_state), (transition p s1 s2) -> (transition_star p s1 s2).

Axiom transition_star_transitive : forall (p:(list instr)) (s1:machine_state)
  (s2:machine_state) (s3:machine_state), (transition_star p s1 s2) ->
  ((transition_star p s2 s3) -> (transition_star p s1 s3)).

(* Why3 assumption *)
Definition vm_stuck (c:(list instr)) (msi:machine_state)
  (msf:machine_state): Prop := (transition_star c msi msf) /\
  forall (ms':machine_state), ~ (transition c msf ms').

(* Why3 assumption *)
Inductive clock_state :=
  | VMC : Z -> (list Z) -> (map id Z) -> Z -> clock_state.
Axiom clock_state_WhyType : WhyType clock_state.
Existing Instance clock_state_WhyType.

(* Why3 assumption *)
Definition parameter := ((list instr)* (func clock_state bool))%type.

(* Why3 assumption *)
Definition transition_out (p:((list instr)* (func clock_state bool))%type)
  (mc1:clock_state) (mc2:clock_state): Prop :=
  match p with
  | (c, inside) => (~ ((infix_at inside mc1) = true)) /\
      ((~ ((infix_at inside mc2) = true)) /\
      match mc1 with
      | (VMC p1 s1 m1 c1) =>
          match mc2 with
          | (VMC p2 s2 m2 c2) => (transition c (VMS p1 s1 m1) (VMS p2 s2
              m2)) /\ (c2 = (c1 + 1%Z)%Z)
          end
      end)
  end.

(* Why3 assumption *)
Inductive transition_star1: ((list instr)* (func clock_state bool))%type ->
  clock_state -> clock_state -> Prop :=
  | Refl1 : forall (p:((list instr)* (func clock_state bool))%type)
      (x:clock_state), (transition_star1 p x x)
  | Step1 : forall (p:((list instr)* (func clock_state bool))%type)
      (x:clock_state) (y:clock_state) (z:clock_state), (transition_out p x
      y) -> ((transition_star1 p y z) -> (transition_star1 p x z)).

Axiom transition_star_one1 : forall (p:((list instr)* (func clock_state
  bool))%type) (s1:clock_state) (s2:clock_state), (transition_out p s1 s2) ->
  (transition_star1 p s1 s2).

Axiom transition_star_transitive1 : forall (p:((list instr)* (func
  clock_state bool))%type) (s1:clock_state) (s2:clock_state)
  (s3:clock_state), (transition_star1 p s1 s2) -> ((transition_star1 p s2
  s3) -> (transition_star1 p s1 s3)).

Axiom transition_star_endpoints : forall (c:(list instr)) (p:(func
  clock_state bool)) (s0:clock_state) (s1:clock_state), (transition_star1 (c,
  p) s0 s1) -> ((~ (s0 = s1)) -> ((~ ((infix_at p s0) = true)) /\
  ~ ((infix_at p s1) = true))).

Axiom transition_star_weakening : forall (c:(list instr)) (p:(func
  clock_state bool)) (q:(func clock_state bool)) (s0:clock_state)
  (s1:clock_state), (forall (x:clock_state), ((infix_at q x) = true) ->
  ((infix_at p x) = true)) -> ((transition_star1 (c, p) s0 s1) ->
  (transition_star1 (c, q) s0 s1)).

Axiom transition_deterministic : forall (c:(list instr)) (ms:machine_state)
  (ms':machine_state) (ms'':machine_state), ((transition c ms ms') /\
  (transition c ms ms'')) -> (ms' = ms'').

Axiom transition_out_deterministic : forall (p:((list instr)* (func
  clock_state bool))%type) (mc1:clock_state) (mc2:clock_state)
  (mc3:clock_state), ((transition_out p mc1 mc2) /\ (transition_out p mc1
  mc3)) -> (mc2 = mc3).

(* Why3 goal *)
Theorem WP_parameter_halt_stuck : forall (c:(list instr)) (p:Z) (s:(list Z))
  (m:(map id Z)), (codeseq_at c p
  (Init.Datatypes.cons Ihalt Init.Datatypes.nil)) -> ((forall (p1:Z)
  (i:instr), (codeseq_at c p1 (Init.Datatypes.cons i Init.Datatypes.nil)) ->
  ((list.Nth.nth p1 c) = (Init.Datatypes.Some i))) ->
  forall (ms':machine_state), ~ (transition c (VMS p s m) ms')).
intros c p s m h1 h2 ms'.
Require Import Why3.
red;intro H;inversion H;subst;why3 "CVC4,1.4,".
Qed.

