/*
 * Decompiled with CFR 0.152.
 */
package xalanjdoc;

import com.sun.javadoc.DocErrorReporter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import xalanjdoc.ConfigurationStandard;
import xalanjdoc.Standard;

public class Extern {
    private static Map packageMap;
    final String packageName;
    final String path;
    final boolean relative;

    Extern(String packageName, String path, boolean relative) {
        this.packageName = packageName;
        this.path = path;
        this.relative = relative;
        if (packageMap == null) {
            packageMap = new HashMap();
        }
        packageMap.put(packageName, this);
    }

    static String adjustEndFileSeparator(String url) {
        String filesep;
        String string = filesep = Extern.isRelativePath(url) ? File.separator : "/";
        if (!url.endsWith(filesep)) {
            url = String.valueOf(url) + filesep;
        }
        return url;
    }

    static String composeExternPackageList(String url, String pkglisturl) {
        url = Extern.adjustEndFileSeparator(url);
        if ((pkglisturl = Extern.adjustEndFileSeparator(pkglisturl)).startsWith("http://") || pkglisturl.startsWith("file:")) {
            return Extern.fetchURLComposeExternPackageList(url, pkglisturl);
        }
        return Extern.readFileComposeExternPackageList(url, pkglisturl);
    }

    static String fetchURLComposeExternPackageList(String urlpath, String pkglisturlpath) {
        String link = String.valueOf(pkglisturlpath) + "package-list";
        try {
            boolean relative = Extern.isRelativePath(urlpath);
            Extern.readPackageList(new URL(link).openStream(), urlpath, relative);
        }
        catch (MalformedURLException malformedURLException) {
            return Extern.getText("doclet.MalformedURL", link);
        }
        catch (IOException iOException) {
            return Extern.getText("doclet.URL_error", link);
        }
        return null;
    }

    public static Extern findPackage(String pkgName) {
        if (packageMap == null) {
            return null;
        }
        return (Extern)packageMap.get(pkgName);
    }

    private static String getText(String msg) {
        Standard.configuration();
        return ConfigurationStandard.standardmessage.getText(msg);
    }

    private static String getText(String prop, String link) {
        Standard.configuration();
        return ConfigurationStandard.standardmessage.getText(prop, link);
    }

    static boolean isRelativePath(String url) {
        return (url.startsWith("http://") || url.startsWith("file:")) ^ true;
    }

    static String readFileComposeExternPackageList(String urlpath, String relpath) {
        String link = String.valueOf(relpath) + "package-list";
        try {
            File file = new File(link);
            if (!file.exists() || !file.canRead()) {
                return Extern.getText("doclet.File_error", link);
            }
            boolean relative = Extern.isRelativePath(urlpath);
            Extern.readPackageList(new FileInputStream(file), urlpath, relative);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return Extern.getText("doclet.File_error", link);
        }
        catch (IOException iOException) {
            return Extern.getText("doclet.File_error", link);
        }
        return null;
    }

    static void readPackageList(InputStream input, String path, boolean relative) throws IOException {
        InputStreamReader in = new InputStreamReader(input);
        StringBuffer strbuf = new StringBuffer();
        try {
            int c;
            while ((c = in.read()) >= 0) {
                char ch = (char)c;
                if (ch == '\n' || ch == '\r') {
                    if (strbuf.length() <= 0) continue;
                    String packname = strbuf.toString();
                    String packpath = String.valueOf(path) + packname.replace('.', '/') + '/';
                    new Extern(packname, packpath, relative);
                    strbuf.setLength(0);
                    continue;
                }
                strbuf.append(ch);
            }
        }
        finally {
            Object var6_9 = null;
            input.close();
        }
    }

    public String toString() {
        return String.valueOf(this.packageName) + (this.relative ? " -> " : " => ") + this.path;
    }

    public static boolean url(String url, String pkglisturl, DocErrorReporter reporter) {
        if (packageMap != null) {
            reporter.printError(Extern.getText("doclet.link_option_twice"));
            return false;
        }
        String errMsg = Extern.composeExternPackageList(url, pkglisturl);
        if (errMsg != null) {
            reporter.printError(errMsg);
            return false;
        }
        return true;
    }
}

