import Test.Tasty( TestTree, defaultMain, localOption, testGroup )
import Test.Tasty.QuickCheck(
  QuickCheckTests( QuickCheckTests ),
  QuickCheckMaxRatio( QuickCheckMaxRatio ))
import Cidr( cidr_properties, cidr_tests )
import IPv4Address( ipv4address_properties, ipv4address_tests )
import Octet( octet_properties, octet_tests )

tests :: TestTree
tests = testGroup "All Tests" [
          cidr_properties,
          cidr_tests,
          ipv4address_properties,
          ipv4address_tests,
          octet_properties,
          octet_tests ]

-- | Warning: the QuickCheckMaxRatio option is not a ratio. It's
--   currently set to \"100%\", so that the test suite passes even if
--   we have to throw out all of our random test cases.
main :: IO ()
main =
  defaultMain $
    localOption (QuickCheckTests 5000) $
    localOption (QuickCheckMaxRatio 5000) tests
