-- -*-Sql-*- mode (to keep my emacs happy)
--
-- API Package Body for Bioentry_Dbxref_Assoc.
--
-- Scaffold auto-generated by gen-api.pl. gen-api.pl is
-- Copyright 2002-2003 Genomics Institute of the Novartis Research Foundation
-- Copyright 2002-2008 Hilmar Lapp
-- 
--  This file is part of BioSQL.
--
--  BioSQL is free software: you can redistribute it and/or modify it
--  under the terms of the GNU Lesser General Public License as
--  published by the Free Software Foundation, either version 3 of the
--  License, or (at your option) any later version.
--
--  BioSQL is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU Lesser General Public License for more details.
--
--  You should have received a copy of the GNU Lesser General Public License
--  along with BioSQL. If not, see <http://www.gnu.org/licenses/>.
--

CREATE OR REPLACE
PACKAGE BODY DbxEntA IS

CURSOR DbxEntA_c (
		DbxEntA_ENT_OID	IN SG_BIOENTRY_DBXREF_ASSOC.ENT_OID%TYPE,
		DbxEntA_DBX_OID	IN SG_BIOENTRY_DBXREF_ASSOC.DBX_OID%TYPE)
RETURN SG_BIOENTRY_DBXREF_ASSOC%ROWTYPE IS
	SELECT t.* FROM SG_BIOENTRY_DBXREF_ASSOC t
	WHERE
		t.Dbx_Oid = DbxEntA_Dbx_Oid
	AND	t.Ent_Oid = DbxEntA_Ent_Oid
	;

FUNCTION get_oid(
		ENT_OID	IN SG_BIOENTRY_DBXREF_ASSOC.ENT_OID%TYPE DEFAULT NULL,
		DBX_OID	IN SG_BIOENTRY_DBXREF_ASSOC.DBX_OID%TYPE DEFAULT NULL,
		DbxEntA_RANK	IN SG_BIOENTRY_DBXREF_ASSOC.RANK%TYPE DEFAULT NULL,
		Ent_IDENTIFIER	IN SG_BIOENTRY.IDENTIFIER%TYPE DEFAULT NULL,
		Ent_ACCESSION	IN SG_BIOENTRY.ACCESSION%TYPE DEFAULT NULL,
		Ent_DB_OID	IN SG_BIOENTRY.DB_OID%TYPE DEFAULT NULL,
		Ent_VERSION	IN SG_BIOENTRY.VERSION%TYPE DEFAULT NULL,
		Dbx_ACCESSION	IN SG_DBXREF.ACCESSION%TYPE DEFAULT NULL,
		Dbx_DBNAME	IN SG_DBXREF.DBNAME%TYPE DEFAULT NULL,
		Dbx_VERSION	IN SG_DBXREF.VERSION%TYPE DEFAULT NULL,
		do_DML		IN NUMBER DEFAULT BSStd.DML_NO)
RETURN INTEGER
IS
	pk	INTEGER DEFAULT NULL;
	DbxEntA_row DbxEntA_c%ROWTYPE;
	ENT_OID_	SG_BIOENTRY.OID%TYPE DEFAULT ENT_OID;
	DBX_OID_	SG_DBXREF.OID%TYPE DEFAULT DBX_OID;
BEGIN
	-- look up SG_BIOENTRY
	IF (ENT_OID_ IS NULL) THEN
		ENT_OID_ := Ent.get_oid(
			Ent_ACCESSION => Ent_ACCESSION,
			Ent_VERSION => Ent_VERSION,
			Ent_IDENTIFIER => Ent_IDENTIFIER,
			DB_OID => Ent_DB_OID);
	END IF;
	-- look up SG_DBXREF
	IF (DBX_OID_ IS NULL) THEN
		DBX_OID_ := Dbx.get_oid(
			Dbx_DBNAME => Dbx_DBNAME,
			Dbx_ACCESSION => Dbx_ACCESSION,
			Dbx_VERSION => Dbx_VERSION,
			do_DML => do_DML);
	END IF;
	-- do the look up
	FOR DbxEntA_row IN DbxEntA_c (ENT_OID_, DBX_OID_) LOOP
        	pk := 1;
	END LOOP;
	-- insert if requested (no update because all attributes are in the UK)
	IF (pk IS NULL) AND 
	   ((do_DML = BSStd.DML_I) OR (do_DML = BSStd.DML_UI)) THEN
	    	-- look up foreign keys if not provided:
		-- look up SG_BIOENTRY successful?
		IF (ENT_OID_ IS NULL) THEN
			raise_application_error(-20101,
				'failed to look up Ent <' || Ent_ACCESSION || '|' || Ent_VERSION || '|' || Ent_IDENTIFIER || '|' || Ent_DB_OID || '>');
		END IF;
		-- look up SG_DBXREF successful?
		IF (DBX_OID_ IS NULL) THEN
			raise_application_error(-20101,
				'failed to look up Dbx <' || Dbx_ACCESSION || '|' || Dbx_DBNAME || '|' || Dbx_VERSION || '>');
		END IF;
	    	-- insert the record and obtain the primary key
	    	pk := do_insert(
		        ENT_OID => ENT_OID_,
		        DBX_OID => DBX_OID_,
			RANK => DbxEntA_RANK);
	END IF; -- no update here
	-- return the TRUE or FALSE
	RETURN pk;
END;

FUNCTION do_insert(
		ENT_OID	IN SG_BIOENTRY_DBXREF_ASSOC.ENT_OID%TYPE,
		DBX_OID IN SG_BIOENTRY_DBXREF_ASSOC.DBX_OID%TYPE,
		RANK	IN SG_BIOENTRY_DBXREF_ASSOC.RANK%TYPE)
RETURN INTEGER
IS
BEGIN
	-- insert the record
	INSERT INTO SG_BIOENTRY_DBXREF_ASSOC (
		ENT_OID,
		DBX_OID,
		RANK)
	VALUES (DBX_OID,
		ENT_OID,
		RANK)
	;
	-- return TRUE
	RETURN 1;
END;

END DbxEntA;
/

