--
-- API Package Body for Chromosome.
--
-- Scaffold auto-generated by gen-api.pl (H.Lapp, 2002).
--
-- $Id: Chromosome.pkb,v 1.1.1.1 2002-08-13 19:51:10 lapp Exp $
--

--
-- Copyright 2002-2003 Genomics Institute of the Novartis Research Foundation
-- Copyright 2002-2008 Hilmar Lapp
-- 
--  This file is part of BioSQL.
--
--  BioSQL is free software: you can redistribute it and/or modify it
--  under the terms of the GNU Lesser General Public License as
--  published by the Free Software Foundation, either version 3 of the
--  License, or (at your option) any later version.
--
--  BioSQL is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU Lesser General Public License for more details.
--
--  You should have received a copy of the GNU Lesser General Public License
--  along with BioSQL. If not, see <http://www.gnu.org/licenses/>.
--

CREATE OR REPLACE
PACKAGE BODY Chrom IS

chr_cached SG_CHROMOSOME.OID%TYPE DEFAULT NULL;
cache_key VARCHAR2(128) DEFAULT NULL;

CURSOR Chr_c (
		Chr_NAME	IN SG_CHROMOSOME.NAME%TYPE,
		Chr_TAX_OID	IN SG_CHROMOSOME.TAX_OID%TYPE)
RETURN SG_CHROMOSOME%ROWTYPE IS
	SELECT t.* FROM SG_CHROMOSOME t
	WHERE
		t.NAME = Chr_NAME
	AND	t.TAX_OID = Chr_TAX_OID
	;

FUNCTION get_oid(
		Chr_OID	IN SG_CHROMOSOME.OID%TYPE DEFAULT NULL,
		Chr_NAME	IN SG_CHROMOSOME.NAME%TYPE,
		Chr_LENGTH	IN SG_CHROMOSOME.LENGTH%TYPE DEFAULT NULL,
		TAX_OID	IN SG_CHROMOSOME.TAX_OID%TYPE,
		Tax_NAME	   IN SG_TAXON.NAME%TYPE DEFAULT NULL,
		Tax_NCBI_TAXON_ID  IN SG_TAXON.NCBI_TAXON_ID%TYPE DEFAULT NULL,
		do_DML		IN NUMBER DEFAULT BSStd.DML_NO)
RETURN SG_CHROMOSOME.OID%TYPE
IS
	pk	SG_CHROMOSOME.OID%TYPE DEFAULT NULL;
	Chr_row Chr_c%ROWTYPE;
	TAX_OID_	SG_TAXON.OID%TYPE DEFAULT TAX_OID;
	key_str VARCHAR2(128) DEFAULT Chr_NAME || '|' || Tax_OID || '|' || Tax_NAME || '|' || Tax_NCBI_TAXON_ID;
BEGIN
	-- initialize
	IF (do_DML > BSStd.DML_NO) THEN
		pk := Chr_OID;
	END IF;
	-- look up
	IF pk IS NULL THEN
		IF (key_str = cache_key) THEN
			-- this will by-pass a potential update
		        RETURN chr_cached;
		ELSE
			-- reset cache
			cache_key := NULL;
			chr_cached := NULL;
			-- look up SG_TAXON
			IF (TAX_OID_ IS NULL) THEN
			        TAX_OID_ := Tax.get_oid(
					 Tax_NAME => Tax_NAME,
					 Tax_NCBI_TAXON_ID => Tax_NCBI_TAXON_ID);
			END IF;
			-- look up primary key
			FOR Chr_row IN Chr_c(Chr_NAME, TAX_OID_) LOOP
			    pk := Chr_row.OID;
			    -- cache result
			    cache_key := key_str;
			    chr_cached := pk;
			END LOOP;
		END IF;
	END IF;
	-- insert/update if requested
	IF (pk IS NULL) AND 
	   ((do_DML = BSStd.DML_I) OR (do_DML = BSStd.DML_UI)) THEN
	    	-- look up foreign keys if not provided:
		-- look up SG_TAXON successful?
		IF (TAX_OID_ IS NULL) THEN
			raise_application_error(-20101,
				'failed to look up Tax <' || Tax_NAME || '|' || Tax_NCBI_TAXON_ID || '>');
		END IF;
	    	-- insert the record and obtain the primary key
	    	pk := do_insert(
		        NAME => Chr_NAME,
			LENGTH => Chr_LENGTH,
			TAX_OID => TAX_OID_);
	ELSIF (do_DML = BSStd.DML_U) OR (do_DML = BSStd.DML_UI) THEN
	        -- update the record (note that not provided FKs will not
		-- be changed nor looked up)
		do_update(
			Chr_OID	=> pk,
		        Chr_NAME => Chr_NAME,
			Chr_LENGTH => Chr_LENGTH,
			Chr_TAX_OID => TAX_OID_);
	END IF;
	-- return the primary key
	RETURN pk;
END;

FUNCTION do_insert(
		NAME	IN SG_CHROMOSOME.NAME%TYPE,
		LENGTH	IN SG_CHROMOSOME.LENGTH%TYPE,
		TAX_OID	IN SG_CHROMOSOME.TAX_OID%TYPE)
RETURN SG_CHROMOSOME.OID%TYPE 
IS
	pk	SG_CHROMOSOME.OID%TYPE;
BEGIN
	-- pre-generate the primary key value
	SELECT SG_Sequence.nextval INTO pk FROM DUAL;
	-- insert the record
	INSERT INTO SG_CHROMOSOME (
		OID,
		NAME,
		LENGTH,
		TAX_OID)
	VALUES (pk,
		NAME,
		LENGTH,
		TAX_OID)
	;
	-- return the new pk value
	RETURN pk;
END;

PROCEDURE do_update(
		Chr_OID	IN SG_CHROMOSOME.OID%TYPE,
		Chr_NAME	IN SG_CHROMOSOME.NAME%TYPE,
		Chr_LENGTH	IN SG_CHROMOSOME.LENGTH%TYPE,
		Chr_TAX_OID	IN SG_CHROMOSOME.TAX_OID%TYPE)
IS
BEGIN
	-- update the record (and leave attributes passed as NULL untouched)
	UPDATE SG_CHROMOSOME
	SET
		NAME = NVL(Chr_NAME, NAME),
		LENGTH = NVL(Chr_LENGTH, LENGTH),
		TAX_OID = NVL(Chr_TAX_OID, TAX_OID)
	WHERE OID = Chr_OID
	;
END;

END Chrom;
/

