#include <stdint.h>
#include <stdbool.h>
#define CR(crn,op1,crm,op2)     (((crn) << 12) | ((op1) << 8) | ((crm) << 4) | (op2))
typedef void   McrProc(void *clientData,uint32_t icode,uint32_t value);
typedef uint32_t MrcProc(void *clientData,uint32_t icode);

typedef struct ControlReg {
	char *name;
	uint8_t crn;
	uint8_t op1;
	uint8_t crm;
	uint8_t op2;
	McrProc *mcrProc;
	MrcProc *mrcProc;
} ControlReg;

static ControlReg controlReg[] = {
	{
		.name = "Main ID",	
		.crn = 0,
		.op1 = 0,
		.crm = 0,
		.op2 = 0,
	},
	{
		.name = "Main ID",	
		.crn = 0,
		.op1 = 0,
		.crm = 0,
		.op2 = 4,
	},
	{
		.name = "Main ID",	
		.crn = 0,
		.op1 = 0,
		.crm = 0,
		.op2 = 6,
	},
	{
		.name = "Main ID",	
		.crn = 0,
		.op1 = 0,
		.crm = 0,
		.op2 = 7,
	},
	{
		.name = "Cache Type",
		.crn = 0,
		.op1 = 0,
		.crm = 0,
		.op2 = 1,
	},
	{
		.name = "TCM Type",
		.crn = 0,
		.op1 = 0,
		.crm = 0,
		.op2 = 2,
	},
	{
		.name = "TLB Type",
		.crn = 0,
		.op1 = 0,
		.crm = 0,	
		.op2 = 3,
	},
	{
		.name = "Multiprocessor ID",
		.crn = 0,
		.op1 = 0,
		.crm = 0,
		.op2 = 5,
	},
	{
		.name = "Processor Feature 0",
		.crn = 0,
		.op1 = 0,
		.crm = 1,
		.op2 = 0,
	},
	{
		.name = "Processor Feature 1",
		.crn = 0,
		.op1 = 0,
		.crm = 1,
		.op2 = 1,
	},
	{
		.name = "Debug Feature 0",
		.crn = 0,
		.op1 = 0,
		.crm = 1,
		.op2 = 2,
	},
	{
		.name = "Auxiliary Feature 0",
		.crn = 0,
		.op1 = 0,
		.crm = 1,
		.op2 = 3,
	},
	{
		.name = "Memory Model Feature 0",
		.crn = 0,
		.op1 = 0,
		.crm = 1,
		.op2 = 4,
	},
	{
		.name = "Memory Model Feature 1",
		.crn = 0,
		.op1 = 0,
		.crm = 1,
		.op2 = 5,
	},
	{
		.name = "Memory Model Feature 2",
		.crn = 0,
		.op1 = 0,
		.crm = 1,
		.op2 = 6,
	},
	{
		.name = "Memory Model Feature 3",
		.crn = 0,
		.op1 = 0,
		.crm = 1,
		.op2 = 7,
	},
	{
		.name = "Instruction Set Attribute 0",
		.crn = 0,
		.op1 = 0,
		.crm = 2,
		.op2 = 0,
	},
	{
		.name = "Instruction Set Attribute 1",
		.crn = 0,
		.op1 = 0,
		.crm = 2,
		.op2 = 1,
	},
	{
		.name = "Instruction Set Attribute 2",
		.crn = 0,
		.op1 = 0,
		.crm = 2,
		.op2 = 2,
	},
	{
		.name = "Instruction Set Attribute 3",
		.crn = 0,
		.op1 = 0,
		.crm = 2,
		.op2 = 3,
	},
	{
		.name = "Instruction Set Attribute 4",
		.crn = 0,
		.op1 = 0,
		.crm = 2,
		.op2 = 4,
	},
	{
		.name = "Instruction Set Attribute 5",
		.crn = 0,
		.op1 = 0,
		.crm = 2,
		.op2 = 5,
	},
	{
		.name = "Instruction Set Attribute 6",
		.crn = 0,
		.op1 = 0,
		.crm = 2,
		.op2 = 6,
	},
	{
		.name = "Instruction Set Attribute 7",
		.crn = 0,
		.op1 = 0,
		.crm = 2,
		.op2 = 7,
	},
	{
		.name = "Cache Size Identification",
		.crn = 0,
		.op1 = 1,
		.crm = 0,
		.op2 = 0,
	},
	{
		.name = "Cache Level ID",
		.crn = 0,
		.op1 = 1,
		.crm = 0,
		.op2 = 1,
	},
	{
		.name = "Silicon ID",
		.crn = 0,
		.op1 = 1,
		.crm = 0,
		.op2 = 7,
	},
	{
		.name = "Cache Size Selection",
		.crn = 0,
		.op1 = 2,
		.crm = 0,
		.op2 = 0,
	},
	{
		.name = "Control",
		.crn = 1,
		.op1 = 0,
		.crm = 0,
		.op2 = 0,
	},
	{
		.name = "Auxiliary Control",
		.crn = 1,
		.op1 = 0,
		.crm = 0,
		.op2 = 1,
	}, 
	{
		.name = "Coprocessor Access Control",
		.crn = 1,
		.op1 = 0,
		.crm = 0,
		.op2 = 2,
	},
	{
		.name = "Secure Configuration",
		.crn = 1,
		.op1 = 0,
		.crm = 1,
		.op2 = 0,	
	},
	{
		.name = "Secure Debug Enable",
		.crn = 1,
		.op1 = 0,
		.crm = 1,
		.op2 = 1,
	},
	{
		.name = "Nonsecure Access Control",
		.crn = 1,
		.op1 = 0,
		.crm = 1,
		.op2 = 2,
	},
	{
		.name = "Translation Table Base 0",
		.crn = 2,
		.op1 = 0,
		.crm = 0,
		.op2 = 0,
	},
	{
		.name = "Translation Table Base 1",
		.crn = 2,
		.op1 = 0,
		.crm = 0,
		.op2 = 1,
	},
	{
		.name = "Translation Table Base Control",
		.crn = 2,
		.op1 = 0,
		.crm = 0,
		.op2 = 2,
	},
	{
		.name = "Domain Access Control",
		.crn = 3,
		.op1 = 0,
		.crm = 0,
		.op2 = 0,
	},
	{
		.name = "Data Fault Status",
		.crn = 5,
		.op1 = 0,
		.crm = 0,
		.op2 = 0,
	},
	{
		.name = "Instruction Fault Status",
		.crn = 5,
		.op1 = 0,
		.crm = 0,
		.op2 = 1,
	},
	{
		.name = "Data Auxiliary Fault Status",
		.crn = 5,
		.op1 = 0,
		.crm = 1,
		.op2 = 0,	
	},
	{
		.name = "Instruction Auxiliary Fault Status",
		.crn = 5,
		.op1 = 0,
		.crm = 1,
		.op2 = 1,
	},
	{
		.name = "Data Fault Address",
		.crn = 6,
		.op1 = 0,
		.crm = 0,
		.op2 = 0,
	},
	{
		.name = "Instruction Fault Address",
		.crn = 6,
		.op1 = 0,
		.crm = 0,
		.op2 = 2,
	},
	{
		.name = "NOP (WFI)",
		.crn = 7,
		.op1 = 0,
		.crm = 0,
		.op2 = 4,
	},
	{
		.name = "Physical Address",
		.crn = 7,
		.op1 = 0,
		.crm = 4,
		.op2 = 0,
	},
	{
		.name = "Invalidate all icaches to point of unification",
		.crn = 7,
		.op1 = 0,
		.crm = 5,
		.op2 = 0,
	},
	{
		.name = "Invalidate icache line to point of unification",
		.crn = 7,
		.op1 = 0,
		.crm = 5,
		.op2 = 1,	
	},
	{
		.name = "Flush Prefetch Buffer",
		.crn = 7,
		.op1 = 0,
		.crm = 5,
		.op2 = 4,
	},
	{
		.name = "NOP (Invalidate entire branch predictor array)",
		.crn = 7,
		.op1 = 0,
		.crm = 5,
		.op2 = 6,
	},
	{
		.name = "NOP (Invalidate branch predictor array line by MVA)",
		.crn = 7,
		.op1 = 0,
		.crm = 5,
		.op2 = 7,
	},
	{
		.name = "Invalidate dcache line to pt of coherency by MVA",
		.crn = 7,
		.op1 = 0,
		.crm = 6,
		.op2 = 1,
	},
	{
		.name = "Invalidate data cache line by set and way",
		.crn = 7,
		.op1 = 0,
		.crm = 6,
		.op2 = 1,
	},
	{
		.name = "VA to PA translation in the current state",
		.crn = 7,
		.op1 = 0,
		.crm = 8,
		.op2 = 0,
	},
	{
		.name = "VA to PA translation in the current state",
		.crn = 7,
		.op1 = 0,
		.crm = 8,
		.op2 = 1,
	},
	{
		.name = "VA to PA translation in the current state",
		.crn = 7,
		.op1 = 0,
		.crm = 8,
		.op2 = 2,
	},
	{
		.name = "VA to PA translation in the current state",
		.crn = 7,
		.op1 = 0,
		.crm = 8,
		.op2 = 3,
	},
	{
		.name = "VA to PA translation in the other state",
		.crn = 7,
		.op1 = 0,
		.crm = 8,
		.op2 = 4,
	},
	{
		.name = "VA to PA translation in the other state",
		.crn = 7,
		.op1 = 0,
		.crm = 8,
		.op2 = 5,
	},
	{
		.name = "VA to PA translation in the other state",
		.crn = 7,
		.op1 = 0,
		.crm = 8,
		.op2 = 6,
	},
	{
		.name = "VA to PA translation in the other state",
		.crn = 7,
		.op1 = 0,
		.crm = 8,
		.op2 = 7,
	},
	{
		.name = "Clean data cache line to point of coherency by MVA",
		.crn = 7,
		.op1 = 0,
		.crm = 10,
		.op2 = 1,
	},
	{
		.name = "Clean data cache line by set and way",
		.crn = 7,
		.op1 = 0,
		.crm = 10,
		.op2 = 2,
	},
	{
		.name = "Data Synchronization Barrier",
		.crn = 7,
		.op1 = 0,
		.crm = 10,
		.op2 = 4,
	},
	{
		.name = "Data Memory Barrier",
		.crn = 7,
		.op1 = 0,
		.crm = 10,
		.op2 = 5,
	},
	{
		.name = "Clean dcache line to point of unification by MVA",
		.crn = 7,
		.op1 = 0,
		.crm = 11,
		.op2 = 1,
	},
	{
		.name = "Clean and invalidate dcache line to pt of coherency by MVA",
		.crn = 7,
		.op1 = 0,
		.crm = 14,
		.op2 = 1,
	},
	{
		.name = "Clean and invalidate data cache line by set and way",
		.crn = 7,
		.op1 = 0,
		.crm = 14,
		.op2 = 2,
	},
	{
		.name = "Invalidate ITLB unlocked entries",
		.crn = 8,
		.op1 = 0,
		.crm = 5,
		.op2 = 0,
	},
	{
		.name = "Invalidate ITLB entry by MVA",
		.crn = 8,
		.op1 = 0,
		.crm = 5,
		.op2 = 1,
	},
	{
		.name = "Invalidate Instruction TLB entry on ASID match",
		.crn = 8,
		.op1 = 0,
		.crm = 5,
		.op2 = 2,
	},
	{
		.name = "Invalidate DTLB unlocked entries",
		.crn = 8,
		.op1 = 0,
		.crm = 6,
		.op2 = 0,
	},
	{
		.name = "Invalidate DTLB entry by MVA",
		.crn = 8,
		.op1 = 0,
		.crm = 6,
		.op2 = 1,
	},
	{
		.name = "Invaildate DTLB entry on ASID match",
		.crn = 8,
		.op1 = 0,
		.crm = 6,
		.op2 = 2,
	},
	{
		.name = "Invalidate unified TLB unlocked entries", 
		.crn = 8,
		.op1 = 0,
		.crm = 7,
		.op2 = 0,
	},
	{
		.name = "Invalidate unified TLB entry by MVA",
		.crn = 8,
		.op1 = 0,
		.crm = 7,
		.op2 = 1,
	},
	{
		.name = "Invalidate unified TLB entry on ASID match",
		.crn = 8,
		.op1 = 0,
		.crm = 7,
		.op2 = 2,	
	},
	{
		.name = "Performance Monitor Control",
		.crn = 9,
		.op1 = 0,
		.crm = 12,
		.op2 = 0,
	},
	{
		.name = "Count Enable Set",
		.crn = 9,
		.op1 = 0,
		.crm = 12,
		.op2 = 1,
	},
	{
		.name = "Count Enable Clear",
		.crn = 9,
		.op1 = 0,
		.crm = 12,
		.op2 = 2,
	},
	{
		.name = "Overflow Flag status",
		.crn = 9,
		.op1 = 0,
		.crm = 12,
		.op2 = 3,
	},
	{
		.name = "Software Increment",
		.crn = 9,
		.op1 = 0,
		.crm = 12,
		.op2 = 4,
	},
	{
		.name = "Performance Counter Selection",
		.crn = 9,
		.op1 = 0,
		.crm = 12,
		.op2 = 5,
	},
	{
		.name = "Cycle count",
		.crn = 9,
		.op1 = 0,
		.crm = 13,
		.op2 = 0,
	},
	{
		.name  = "Event Selection",
		.crn = 9,
		.op1 = 0,
		.crm = 13,
		.op2 = 1,
	},
	{
		.name = "Performance Monitor Count",
		.crn = 9,
		.op1 = 0,
		.crm = 13,
		.op2 = 2,
	},
	{
		.name = "User Enable",
		.crn = 9,
		.op1 = 0,
		.crm = 14,
		.op2 = 0,
	},
	{
		.name = "Interrupt Enable Set",
		.crn = 9,
		.op1 = 0,
		.crm = 14,
		.op2 = 1,
	},
	{
		.name = "Interrupt Enable Clear",
		.crn = 9,
		.op1 = 0,
		.crm = 14,
		.op2 = 2,
	},
	{
		.name = "L2 Cache Lockdown",
		.crn = 9,
		.op1 = 1,
		.crm = 0,
		.op2 = 0,
	},
	{
		.name = "L2 Cache Auxiliary Control",
		.crn = 0,
		.op1 = 1,
		.crm = 0,
		.op2 = 2,
	},
	{
		.name = "Data TLB Lockdown Register",
		.crn = 10,
		.op1 = 0,
		.crm = 0,
		.op2 = 0,
	},
	{
		.name = "Instruction TLB Lockdown Register",
		.crn = 10,
		.op1 = 0,
		.crm = 0,
		.op2 = 1,  
	},
	{
		.name = "Data TLB Preload",
		.crn = 10,
		.op1 = 0,
		.crm = 1,
		.op2 = 0,	
	},
	{
		.name = "Instruction TLB Preload",
		.crn = 10,
		.op1 = 0,
		.crm = 1,
		.op2 = 1,
	},
	{
		.name = "Primary Region Remap Register",
		.crn = 10,
		.op1 = 0,
		.crm = 2,
		.op2 = 0,	
	},
	{
		.name = "Normal Memory Remap Register",
		.crn = 10,
		.op1 = 0,
		.crm = 2,
		.op2 = 1,
	},
	{
		.name = "PLE Identification and Status",
		.crn = 11,
		.op1 = 0,
		.crm = 0,
		.op2 = 0,	
	},
	{
		.name = "PLE Identification and Status",
		.crn = 11,
		.op1 = 0,
		.crm = 0,
		.op2 = 2,
	},
	{
		.name = "PLE Identification and Status",
		.crn = 11,
		.op1 = 0,
		.crm = 0,
		.op2 = 3,
	},
	{
		.name = "PLE User Accessibility",
		.crn = 11,
		.op1 = 0,
		.crm = 1,
		.op2 = 0,
	},
	{
		.name = "PLE Channel Number",
		.crn = 11,
		.op1 = 0,
		.crm = 2,
		.op2 = 0,
	},
	{
		.name = "PLE enable",
		.crn = 11,
		.op1 = 0,
		.crm = 3,
		.op2 = 0,
	},
	{
		.name = "PLE enable",
		.crn = 11,
		.op1 = 0,
		.crm = 3,
		.op2 = 1,
	},
	{
		.name = "PLE enable",
		.crn = 11,
		.op1 = 0,
		.crm = 3,
		.op2 = 2,
	},
	{
		.name = "PLE Control",
		.crn = 11,
		.op1 = 0,
		.crm = 4,
		.op2 = 0,
	},
	{
		.name = "PLE Internal Start Address",
		.crn = 11,
		.op1 = 0,
		.crm = 5,
		.op2 = 0,
	},
	{
		.name = "PLE Internal End Address",
		.crn = 11,
		.op1 = 0,
		.crm = 7,
		.op2 = 0,
	},
	{
		.name = "PLE Channel Status",
		.crn = 11,
		.op1 = 0,
		.crm = 8,
		.op2 = 0,
	},
	{
		.name = "PLE Context ID",
		.crn = 11,
		.op1 = 0,
		.crm = 15,
		.op2 = 0,
	},
	{
		.name = "Secure or Nonsecure Vector Base Address",
		.crn = 12,
		.op1 = 0,
		.crm = 0,
		.op2 = 0,
	},
	{
		.name = "Monitor Vector Base Address",
		.crn = 12,
		.op1 = 0,
		.crm = 0,
		.op2 = 1,
	},
	{
		.name = "Interrupt Status",
		.crn = 12,
		.op1 = 0,
		.crm = 0,
		.op2 = 0,
	},
	{
		.name = "FCSE PID",
		.crn = 13,
		.op1 = 0,
		.crm = 0,
		.op2 = 0,
	},
	{
		.name = "Context ID",
		.crn = 13,
		.op1 = 0,
		.crm = 0,
		.op2 = 1,
	},
	{
		.name = "User read/write Thread and Process ID",
		.crn = 13,
		.op1 = 0,
		.crm = 0,
		.op2 = 2,
	},
	{
		.name = "User read-only Thread and Process ID",
		.crn = 13,
		.op1 = 0,
		.crm = 0,
		.op2 = 3,
	},
	{
		.name = "Privileged only Thread and Process ID",
		.crn = 13,
		.op1 = 0,
		.crm = 0,
		.op2 = 4,
	},
	{
		.name = "D-L1 Data 0 Register",
		.crn = 15,
		.op1 = 0,
		.crm = 0,
		.op2 = 0,
	},
	{
		.name = "D-L1 Data 1 Register",
		.crn = 15,
		.op1 = 0,
		.crm = 0,
		.op2 = 1,
	},
	{
		.name = "D-TLB CAM write operation",
		.crn = 15,
		.op1 = 0,
		.crm = 0,
		.op2 = 2,
	},
	{
		.name = "D-TLB ATTR write operation",
		.crn = 15,
		.op1 = 0,
		.crm = 0,
		.op2 = 3,
	},
	{
		.name = "D-TLB PA write operation",
		.crn = 15,
		.op1 = 0,
		.crm = 0,
		.op2 = 4,
	},
	{
		.name = "D-HVAB write operation",
		.crn = 15,
		.op1 = 0,
		.crm = 0,
		.op2 = 5,
	},
	{
		.name = "D-Tag write operation",
		.crn = 15,
		.op1 = 0,
		.crm = 0,
		.op2 = 6,
	},
	{
		.name = "D-Data write operation",
		.crn = 15,
		.op1 = 0,
		.crm = 0,
		.op2 = 7,
	},
	{
		.name = "I-L1 Data 0 Register",
		.crn = 15,
		.op1 = 0,
		.crm = 1,
		.op2 = 0,
	},
	{
		.name = "I-L1 Data 1 Register",
		.crn = 15,
		.op1 = 0,
		.crm = 1,
		.op2 = 1,
	},
	{
		.name = "I-TLB CAM write operation",
		.crn = 15,
		.op1 = 0,
		.crm = 1,
		.op2 = 2,
	},
	{
		.name = "I-TLB ATTR write operation",
		.crn = 15,
		.op1 = 0,
		.crm = 1,
		.op2 = 3,
	},
	{
		.name = "I-TLB PA write operation",
		.crn = 15,
		.op1 = 0,
		.crm = 1,
		.op2 = 4,
	},
	{
		.name = "I-HVAB write operation",
		.crn = 15,
		.op1 = 0,
		.crm = 1,
		.op2 = 5,
	},
	{
		.name = "I-Tag write operation",
		.crn = 15,
		.op1 = 0,
		.crm = 1,
		.op2 = 6,
	},
	{
		.name = "I-Data write operation",
		.crn = 15,
		.op1 = 0,
		.crm = 1,
		.op2 = 7,
	},
	{
		.name = "D-TLB CAM read operation",
		.crn = 15,
		.op1 = 0,
		.crm = 2,
		.op2 = 2,
	},
	{
		.name = "D-TLB ATTR read operation",
		.crn = 15,
		.op1 = 0,
		.crm = 2,
		.op2 = 3,
	},
	{
		.name = "D-TLB PA read operaion",
		.crn = 15,
		.op1 = 0,
		.crm = 2,
		.op2 = 4,
	},
	{
		.name = "D-HVAB read operation",
		.crn = 15,
		.op1 = 0,
		.crm = 2,
		.op2 = 5,
	},
	{
		.name = "D-Tag read operation",
		.crn = 15,
		.op1 = 0,
		.crm = 2,
		.op2 = 6,
	},
	{
		.name = "I-TLB CAM read operation",
		.crn = 15,
		.op1 = 0,
		.crm = 3,
		.op2 = 2,
	},
	{
		.name = "I-TLB ATTR read operation",
		.crn = 15,
		.op1 = 0,
		.crm = 3,
		.op2 = 3,
	},
	{
		.name = "I-TLB PA Read operation",
		.crn = 15,
		.op1 = 0,
		.crm = 3,
		.op2 = 4,
	},
	{
		.name = "I-HVAB read operation",
		.crn = 15,
		.op1 = 0,
		.crm = 3,
		.op2 = 5,
	},
	{
		.name = "I-Tag read operation",
		.crn = 15,
		.op1 = 0,
		.crm = 3,
		.op2 = 6,
	},
	{
		.name = "I-Data read operation",
		.crn = 15,
		.op1 = 0,
		.crm = 3,
		.op2 = 7,
	},
	{
		.name = "GHB write operation",
		.crn = 15,
		.op1 = 0,
		.crm = 5,
		.op2 = 2,
	},
	{
		.name = "BTB write operation",
		.crn = 15,
		.op1 = 0,
		.crm = 5,
		.op2 = 3,
	},
	{
		.name = "GHB read operation",
		.crn = 15,
		.op1 = 0,
		.crm = 7,
		.op2 = 2,
	},
	{
		.name = "BTB read operation",
		.crn = 15,
		.op1 = 0,
		.crm = 7,
		.op2 = 3,
	},
	{
		.name = "L2 Data 0 Register",
		.crn = 15,
		.op1 = 0,
		.crm = 8,
		.op2 = 0,
	},
	{
		.name = "L2 Data 1 Register",
		.crn = 15,
		.op1 = 0,
		.crm = 8,
		.op2 = 1,	
	},
	{
		.name = "L2 tag, L2 valid write operation",
		.crn = 15,
		.op1 = 0,
		.crm = 8,
		.op2 = 2,
	},
	{
		.name = "L2 data, L2 dirty write operation",
		.crn =15,
		.op1 = 0,
		.crm = 8,
		.op2 = 3,
	},
	{
		.name = "L2 parity and ECC write operation",
		.crn = 15,
		.op1 = 0,
		.crm = 8,
		.op2 = 4,
	},
	{
		.name = "L2 Data 2 register",
		.crn = 15,
		.op1 = 0,
		.crm = 8,
		.op2 = 5,
	},
	{
		.name = "L2 tag, L2 valid read operation",
		.crn = 15,
		.op1 = 0,
		.crm = 9,
		.op2 = 2,
	},
	{
		.name = "L2 data, L2 dirty read operation",
		.crn = 15,
		.op1 = 0,
		.crm = 9,
		.op2 = 3,
	},
	{
		.name = "L2 parity and ECC operation",
		.crn = 15,
		.op1 = 0,
		.crm = 9,
		.op2 = 4,
	},
};
