// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A video source. You can upload a smaller video as a base64-encoded string as long as the encoded file is less than 25MB. You can also transfer videos up to 1GB in size from an S3 bucket.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub enum VideoSource {
    /// <p>Video content encoded in base64.</p>
    Bytes(::aws_smithy_types::Blob),
    /// <p>The location of a video object in an S3 bucket.</p>
    S3Location(crate::types::S3Location),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl VideoSource {
    /// Tries to convert the enum instance into [`Bytes`](crate::types::VideoSource::Bytes), extracting the inner [`Blob`](::aws_smithy_types::Blob).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_bytes(&self) -> ::std::result::Result<&::aws_smithy_types::Blob, &Self> {
        if let VideoSource::Bytes(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Bytes`](crate::types::VideoSource::Bytes).
    pub fn is_bytes(&self) -> bool {
        self.as_bytes().is_ok()
    }
    /// Tries to convert the enum instance into [`S3Location`](crate::types::VideoSource::S3Location), extracting the inner [`S3Location`](crate::types::S3Location).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_s3_location(&self) -> ::std::result::Result<&crate::types::S3Location, &Self> {
        if let VideoSource::S3Location(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`S3Location`](crate::types::VideoSource::S3Location).
    pub fn is_s3_location(&self) -> bool {
        self.as_s3_location().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}
