/* $Id: util.h,v 1.7 2004/03/06 22:30:15 andrewbaker Exp $ */
/*
** Copyright (C) 2001 Martin Roesch <roesch@sourcefire.com>
** Copyright (C) 2001-2004 Andrew R. Baker <andrewb@snort.org>
**
** This program is distributed under the terms of version 1.0 of the 
** Q Public License.  See LICENSE.QPL for further details.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
*/

#ifndef __UTIL_H__
#define __UTIL_H__

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>

#define STD_BUF  256 
#define TIMEBUF_SIZE 26
#define FILEPATH_BUFSIZE 8192

extern char *protocol_names[];

void LogMessage(const char *, ...);

void FatalError(const char *, ...);
void FreeToks(char **, int);
char *ZapWhitespace(char *);
void *SafeAlloc(unsigned long);
char *ProcessFileOption(char *);
int strip(char *);
void InitProtoNames();
char *fasthex(u_char *, int);
void PrintNetData(FILE *, u_char *, const int);
void ClearDumpBuf();
void GoDaemon();
size_t RenderTimestamp(time_t timet, char *timebuf, size_t len);
int RenderTimeval(struct timeval *tv, char *timebuf, size_t len);
int CreatePidFile(char *filename);
int String2Long(char *string, long *result);
int String2ULong(char *string, unsigned long *result);
int StripWhitespace(char **data);
int BuildFilePath(char *filename, char *default_basedir, char **filepath);

#endif  /* __UTIL_H__ */
