#include <fcntl.h>
#include <unistd.h>

#include <vector>
#include <string>

#include <lufs/proto.h>
#include <lufs/fs.h>

using namespace std;

#include "tools.h"
#include "file_handle.h"
#include "fs_modules.h"


/********* FSModule methods **************/

string FSModule::GetVirtualFilename(const char* fname)
{
	if(endswith(fname, GetRealExtension()))
		return string(fname)+GetVirtualExtension();
	else
		return string();
}

bool FSModule::IsMyVirtualFilename(const char* fname)
{
	// ends with virtual extension ?
	string real_candidate = removeend( fname, GetVirtualExtension() );
	if( real_candidate.size() == 0 )
		return false;
	
	// real filename ends with real extension corresponding to the compression we use ?
	return endswith(real_candidate.c_str(),GetRealExtension());
}

string FSModule::GetRealFilename( const char* virtuel )
{
	return removeend( virtuel, GetVirtualExtension() );
}

FileHandle*	FSModule::Open( const char* path )
{
	TRACE(Identity()<<" tries to open "<<path);
	
	if( !IsMyVirtualFilename(path) )
		return NULL;
	
	string real_path = GetRealFilename(path);
	TRACE(Identity()<<" => name matches, i'll look closer at "<<path<<" ** "<<real_path);
	
	FileHandle *handle = CreateHandle(path,real_path.c_str());
	if( handle->Open()<0 )
	{
		delete handle;
		return 0;
	}
	else
		return handle;
}


/********* FSModule_Default methods **************/

string FSModule_Default::GetVirtualFilename(const char* fname)
{
	return string(fname);
}

bool FSModule_Default::IsMyVirtualFilename(const char* fname)
{
	return true;
}

string FSModule_Default::GetRealFilename( const char* virtuel )
{
	return virtuel;
}

/********* FSModule_Flac methods **************/
