// Code generated by goyacc -v y.output -o parser.go -p mtail parser.y. DO NOT EDIT.

//line parser.y:5
package parser

import __yyfmt__ "fmt"

//line parser.y:5

import (
	"time"

	"github.com/golang/glog"
	"github.com/google/mtail/internal/metrics"
	"github.com/google/mtail/internal/vm/ast"
	"github.com/google/mtail/internal/vm/position"
)

//line parser.y:18
type mtailSymType struct {
	yys      int
	intVal   int64
	floatVal float64
	floats   []float64
	op       int
	text     string
	texts    []string
	flag     bool
	n        ast.Node
	kind     metrics.Kind
	duration time.Duration
}

const INVALID = 57346
const COUNTER = 57347
const GAUGE = 57348
const TIMER = 57349
const TEXT = 57350
const HISTOGRAM = 57351
const AFTER = 57352
const AS = 57353
const BY = 57354
const CONST = 57355
const HIDDEN = 57356
const DEF = 57357
const DEL = 57358
const NEXT = 57359
const OTHERWISE = 57360
const ELSE = 57361
const STOP = 57362
const BUCKETS = 57363
const BUILTIN = 57364
const REGEX = 57365
const STRING = 57366
const CAPREF = 57367
const CAPREF_NAMED = 57368
const ID = 57369
const DECO = 57370
const INTLITERAL = 57371
const FLOATLITERAL = 57372
const DURATIONLITERAL = 57373
const INC = 57374
const DEC = 57375
const DIV = 57376
const MOD = 57377
const MUL = 57378
const MINUS = 57379
const PLUS = 57380
const POW = 57381
const SHL = 57382
const SHR = 57383
const LT = 57384
const GT = 57385
const LE = 57386
const GE = 57387
const EQ = 57388
const NE = 57389
const BITAND = 57390
const XOR = 57391
const BITOR = 57392
const NOT = 57393
const AND = 57394
const OR = 57395
const ADD_ASSIGN = 57396
const ASSIGN = 57397
const CONCAT = 57398
const MATCH = 57399
const NOT_MATCH = 57400
const LCURLY = 57401
const RCURLY = 57402
const LPAREN = 57403
const RPAREN = 57404
const LSQUARE = 57405
const RSQUARE = 57406
const COMMA = 57407
const NL = 57408

var mtailToknames = [...]string{
	"$end",
	"error",
	"$unk",
	"INVALID",
	"COUNTER",
	"GAUGE",
	"TIMER",
	"TEXT",
	"HISTOGRAM",
	"AFTER",
	"AS",
	"BY",
	"CONST",
	"HIDDEN",
	"DEF",
	"DEL",
	"NEXT",
	"OTHERWISE",
	"ELSE",
	"STOP",
	"BUCKETS",
	"BUILTIN",
	"REGEX",
	"STRING",
	"CAPREF",
	"CAPREF_NAMED",
	"ID",
	"DECO",
	"INTLITERAL",
	"FLOATLITERAL",
	"DURATIONLITERAL",
	"INC",
	"DEC",
	"DIV",
	"MOD",
	"MUL",
	"MINUS",
	"PLUS",
	"POW",
	"SHL",
	"SHR",
	"LT",
	"GT",
	"LE",
	"GE",
	"EQ",
	"NE",
	"BITAND",
	"XOR",
	"BITOR",
	"NOT",
	"AND",
	"OR",
	"ADD_ASSIGN",
	"ASSIGN",
	"CONCAT",
	"MATCH",
	"NOT_MATCH",
	"LCURLY",
	"RCURLY",
	"LPAREN",
	"RPAREN",
	"LSQUARE",
	"RSQUARE",
	"COMMA",
	"NL",
}
var mtailStatenames = [...]string{}

const mtailEofCode = 1
const mtailErrCode = 2
const mtailInitialStackSize = 16

//line parser.y:651

//  tokenpos returns the position of the current token.
func tokenpos(mtaillex mtailLexer) position.Position {
	return mtaillex.(*parser).t.Pos
}

// markedpos returns the position recorded from the most recent mark_pos
// production.
func markedpos(mtaillex mtailLexer) position.Position {
	return mtaillex.(*parser).pos
}

//line yacctab:1
var mtailExca = [...]int{
	-1, 1,
	1, -1,
	-2, 0,
	-1, 2,
	1, 1,
	15, 116,
	28, 116,
	34, 116,
	-2, 88,
	-1, 24,
	66, 21,
	-2, 66,
	-1, 107,
	15, 116,
	28, 116,
	34, 116,
	-2, 88,
}

const mtailPrivate = 57344

const mtailLast = 233

var mtailAct = [...]int{

	158, 21, 92, 64, 44, 29, 28, 43, 42, 27,
	26, 30, 47, 93, 14, 41, 24, 91, 123, 46,
	19, 154, 152, 153, 153, 88, 106, 53, 52, 168,
	22, 167, 50, 51, 63, 89, 49, 13, 50, 51,
	31, 28, 127, 94, 87, 49, 11, 25, 2, 20,
	10, 15, 90, 12, 165, 33, 13, 36, 34, 35,
	45, 60, 38, 39, 45, 11, 25, 142, 20, 10,
	15, 113, 12, 105, 33, 114, 36, 34, 35, 45,
	140, 38, 39, 161, 40, 80, 81, 103, 83, 82,
	124, 124, 104, 133, 37, 50, 51, 112, 107, 16,
	85, 86, 1, 40, 66, 68, 67, 131, 126, 28,
	29, 28, 162, 37, 100, 101, 99, 130, 16, 102,
	136, 24, 146, 28, 28, 19, 141, 143, 145, 144,
	151, 150, 156, 155, 147, 148, 132, 149, 69, 116,
	73, 74, 75, 76, 77, 78, 117, 97, 96, 70,
	71, 61, 79, 118, 98, 166, 119, 120, 121, 171,
	170, 122, 164, 163, 62, 95, 48, 65, 169, 128,
	60, 33, 129, 36, 34, 35, 45, 84, 38, 39,
	33, 115, 36, 34, 35, 45, 72, 38, 39, 33,
	18, 36, 34, 35, 45, 157, 38, 39, 160, 111,
	40, 159, 110, 70, 71, 138, 137, 134, 135, 40,
	37, 125, 54, 109, 9, 139, 8, 7, 108, 37,
	55, 56, 57, 58, 59, 6, 32, 23, 37, 17,
	5, 4, 3,
}
var mtailPact = [...]int{

	-1000, -1000, 52, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, 37, -1000, -1000, -14, -23, -1000, -39, 215, 136,
	167, 56, -1000, -1000, 117, -1000, 98, -1000, 28, 34,
	60, 6, -38, -26, -1000, -1000, -1000, 158, -1000, -1000,
	158, 110, -1000, -1000, 80, -1000, -1000, 73, -40, -1000,
	-1000, -1000, -1000, -1000, 175, -1000, -1000, -1000, -1000, -1000,
	-1000, 44, -23, 171, -1000, -40, -1000, -1000, -1000, -1000,
	-1000, -1000, -40, -1000, -1000, -1000, -1000, -1000, -1000, -40,
	-1000, -1000, -40, -40, -40, -1000, -1000, -40, 158, 149,
	-20, 27, -1000, 117, -1000, -40, -1000, -1000, -40, -1000,
	-1000, -1000, -1000, 6, -23, 158, -1000, 33, 194, -1000,
	-1000, -1000, 57, -23, -1000, 36, 158, 158, 167, 158,
	158, 158, 37, -42, 56, -1000, -41, -1000, 158, 158,
	-1000, 56, -1000, -1000, -1000, -1000, -1000, 174, 59, 133,
	20, -1000, -1000, 98, 60, -1000, -1000, 43, 43, 110,
	-1000, -1000, -1000, 158, -1000, 80, -1000, -34, -1000, -1000,
	-1000, -1000, -36, -1000, -1000, -1000, 56, 174, 130, -1000,
	-1000, -1000,
}
var mtailPgo = [...]int{

	0, 48, 232, 18, 12, 231, 230, 229, 3, 4,
	15, 13, 2, 227, 10, 11, 1, 14, 226, 7,
	40, 9, 225, 218, 217, 216, 8, 30, 214, 213,
	212, 208, 0, 207, 195, 190, 186, 177, 167, 166,
	165, 154, 152, 138, 120, 112, 102, 73, 17, 97,
}
var mtailR1 = [...]int{

	0, 46, 1, 1, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 5, 5, 5, 6, 6, 4,
	7, 7, 13, 13, 17, 17, 17, 17, 39, 39,
	16, 16, 38, 38, 38, 14, 14, 36, 36, 36,
	36, 36, 36, 15, 15, 37, 37, 10, 10, 27,
	27, 27, 42, 42, 21, 20, 20, 20, 40, 40,
	9, 9, 41, 41, 41, 41, 12, 12, 11, 11,
	43, 43, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 18, 18, 19, 3, 3, 26, 22, 35, 35,
	23, 23, 23, 23, 29, 29, 30, 30, 30, 30,
	30, 33, 34, 34, 31, 44, 45, 45, 45, 45,
	24, 25, 28, 28, 32, 32, 48, 49, 47, 47,
}
var mtailR2 = [...]int{

	0, 1, 0, 2, 1, 1, 1, 1, 1, 1,
	1, 3, 1, 1, 4, 2, 2, 1, 2, 3,
	1, 1, 4, 4, 1, 1, 4, 4, 1, 1,
	1, 4, 1, 1, 1, 1, 4, 1, 1, 1,
	1, 1, 1, 1, 4, 1, 1, 1, 4, 1,
	4, 4, 1, 1, 1, 1, 4, 4, 1, 1,
	1, 4, 1, 1, 1, 1, 1, 2, 1, 2,
	1, 1, 1, 3, 4, 1, 1, 1, 3, 1,
	1, 1, 4, 1, 1, 3, 5, 3, 0, 1,
	2, 2, 2, 1, 1, 1, 1, 1, 1, 1,
	1, 2, 1, 3, 2, 2, 1, 1, 3, 3,
	4, 3, 4, 2, 1, 1, 0, 0, 0, 1,
}
var mtailChk = [...]int{

	-1000, -46, -1, -2, -5, -6, -22, -24, -25, -28,
	17, 13, 20, 4, -17, 18, 66, -7, -35, -48,
	16, -16, -27, -13, -11, 14, -14, -21, -8, -12,
	-15, -20, -18, 22, 25, 26, 24, 61, 29, 30,
	51, -10, -26, -19, -9, 27, -19, -4, -39, 59,
	52, 53, -4, 66, -30, 5, 6, 7, 8, 9,
	34, 15, 28, -11, -8, -38, 48, 50, 49, -43,
	32, 33, -36, 42, 43, 44, 45, 46, 47, -42,
	57, 58, 55, 54, -37, 40, 41, 38, 63, 61,
	-17, -48, -12, -11, -12, -40, 38, 37, -41, 36,
	34, 35, 39, -20, 19, -47, 66, -1, -23, -29,
	27, 24, -49, 27, -4, 10, -47, -47, -47, -47,
	-47, -47, -47, -3, -16, 62, -3, 62, -47, -47,
	-4, -16, -27, 60, -33, -31, -44, 12, 11, 21,
	23, -4, 31, -14, -15, -21, -8, -17, -17, -10,
	-26, -19, 64, 65, 62, -9, -12, -34, -32, 27,
	24, 24, -45, 30, 29, 34, -16, 65, 65, -32,
	30, 29,
}
var mtailDef = [...]int{

	2, -2, -2, 3, 4, 5, 6, 7, 8, 9,
	10, 0, 12, 13, 0, 0, 17, 0, 0, 0,
	0, 24, 25, 20, -2, 89, 30, 49, 68, 60,
	35, 54, 72, 0, 75, 76, 77, 116, 79, 80,
	0, 43, 55, 81, 47, 83, 116, 15, 118, 2,
	28, 29, 16, 18, 0, 96, 97, 98, 99, 100,
	117, 0, 0, 113, 68, 118, 32, 33, 34, 69,
	70, 71, 118, 37, 38, 39, 40, 41, 42, 118,
	52, 53, 118, 118, 118, 45, 46, 118, 0, 0,
	0, 0, 60, 66, 67, 118, 58, 59, 118, 62,
	63, 64, 65, 11, 0, 116, 119, -2, 87, 93,
	94, 95, 0, 0, 111, 0, 0, 0, 116, 116,
	116, 0, 116, 0, 84, 73, 0, 78, 0, 0,
	14, 26, 27, 19, 90, 91, 92, 0, 0, 0,
	0, 110, 112, 31, 36, 50, 51, 22, 23, 44,
	56, 57, 82, 0, 74, 48, 61, 101, 102, 114,
	115, 104, 105, 106, 107, 86, 85, 0, 0, 103,
	108, 109,
}
var mtailTok1 = [...]int{

	1,
}
var mtailTok2 = [...]int{

	2, 3, 4, 5, 6, 7, 8, 9, 10, 11,
	12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
	22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
	32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
	42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
	52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
	62, 63, 64, 65, 66,
}
var mtailTok3 = [...]int{
	0,
}

var mtailErrorMessages = [...]struct {
	state int
	token int
	msg   string
}{
	{112, 4, "unexpected end of file, expecting '/' to end regex"},
	{18, 1, "unexpected end of file, expecting '}' to end block"},
	{18, 1, "unexpected end of file, expecting '}' to end block"},
	{18, 1, "unexpected end of file, expecting '}' to end block"},
	{14, 63, "unexpected indexing of an expression"},
	{14, 66, "statement with no effect, missing an assignment, `+' concatenation, or `{}' block?"},
}

//line yaccpar:1

/*	parser for yacc output	*/

var (
	mtailDebug        = 0
	mtailErrorVerbose = false
)

type mtailLexer interface {
	Lex(lval *mtailSymType) int
	Error(s string)
}

type mtailParser interface {
	Parse(mtailLexer) int
	Lookahead() int
}

type mtailParserImpl struct {
	lval  mtailSymType
	stack [mtailInitialStackSize]mtailSymType
	char  int
}

func (p *mtailParserImpl) Lookahead() int {
	return p.char
}

func mtailNewParser() mtailParser {
	return &mtailParserImpl{}
}

const mtailFlag = -1000

func mtailTokname(c int) string {
	if c >= 1 && c-1 < len(mtailToknames) {
		if mtailToknames[c-1] != "" {
			return mtailToknames[c-1]
		}
	}
	return __yyfmt__.Sprintf("tok-%v", c)
}

func mtailStatname(s int) string {
	if s >= 0 && s < len(mtailStatenames) {
		if mtailStatenames[s] != "" {
			return mtailStatenames[s]
		}
	}
	return __yyfmt__.Sprintf("state-%v", s)
}

func mtailErrorMessage(state, lookAhead int) string {
	const TOKSTART = 4

	if !mtailErrorVerbose {
		return "syntax error"
	}

	for _, e := range mtailErrorMessages {
		if e.state == state && e.token == lookAhead {
			return "syntax error: " + e.msg
		}
	}

	res := "syntax error: unexpected " + mtailTokname(lookAhead)

	// To match Bison, suggest at most four expected tokens.
	expected := make([]int, 0, 4)

	// Look for shiftable tokens.
	base := mtailPact[state]
	for tok := TOKSTART; tok-1 < len(mtailToknames); tok++ {
		if n := base + tok; n >= 0 && n < mtailLast && mtailChk[mtailAct[n]] == tok {
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}
	}

	if mtailDef[state] == -2 {
		i := 0
		for mtailExca[i] != -1 || mtailExca[i+1] != state {
			i += 2
		}

		// Look for tokens that we accept or reduce.
		for i += 2; mtailExca[i] >= 0; i += 2 {
			tok := mtailExca[i]
			if tok < TOKSTART || mtailExca[i+1] == 0 {
				continue
			}
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}

		// If the default action is to accept or reduce, give up.
		if mtailExca[i+1] != 0 {
			return res
		}
	}

	for i, tok := range expected {
		if i == 0 {
			res += ", expecting "
		} else {
			res += " or "
		}
		res += mtailTokname(tok)
	}
	return res
}

func mtaillex1(lex mtailLexer, lval *mtailSymType) (char, token int) {
	token = 0
	char = lex.Lex(lval)
	if char <= 0 {
		token = mtailTok1[0]
		goto out
	}
	if char < len(mtailTok1) {
		token = mtailTok1[char]
		goto out
	}
	if char >= mtailPrivate {
		if char < mtailPrivate+len(mtailTok2) {
			token = mtailTok2[char-mtailPrivate]
			goto out
		}
	}
	for i := 0; i < len(mtailTok3); i += 2 {
		token = mtailTok3[i+0]
		if token == char {
			token = mtailTok3[i+1]
			goto out
		}
	}

out:
	if token == 0 {
		token = mtailTok2[1] /* unknown char */
	}
	if mtailDebug >= 3 {
		__yyfmt__.Printf("lex %s(%d)\n", mtailTokname(token), uint(char))
	}
	return char, token
}

func mtailParse(mtaillex mtailLexer) int {
	return mtailNewParser().Parse(mtaillex)
}

func (mtailrcvr *mtailParserImpl) Parse(mtaillex mtailLexer) int {
	var mtailn int
	var mtailVAL mtailSymType
	var mtailDollar []mtailSymType
	_ = mtailDollar // silence set and not used
	mtailS := mtailrcvr.stack[:]

	Nerrs := 0   /* number of errors */
	Errflag := 0 /* error recovery flag */
	mtailstate := 0
	mtailrcvr.char = -1
	mtailtoken := -1 // mtailrcvr.char translated into internal numbering
	defer func() {
		// Make sure we report no lookahead when not parsing.
		mtailstate = -1
		mtailrcvr.char = -1
		mtailtoken = -1
	}()
	mtailp := -1
	goto mtailstack

ret0:
	return 0

ret1:
	return 1

mtailstack:
	/* put a state and value onto the stack */
	if mtailDebug >= 4 {
		__yyfmt__.Printf("char %v in %v\n", mtailTokname(mtailtoken), mtailStatname(mtailstate))
	}

	mtailp++
	if mtailp >= len(mtailS) {
		nyys := make([]mtailSymType, len(mtailS)*2)
		copy(nyys, mtailS)
		mtailS = nyys
	}
	mtailS[mtailp] = mtailVAL
	mtailS[mtailp].yys = mtailstate

mtailnewstate:
	mtailn = mtailPact[mtailstate]
	if mtailn <= mtailFlag {
		goto mtaildefault /* simple state */
	}
	if mtailrcvr.char < 0 {
		mtailrcvr.char, mtailtoken = mtaillex1(mtaillex, &mtailrcvr.lval)
	}
	mtailn += mtailtoken
	if mtailn < 0 || mtailn >= mtailLast {
		goto mtaildefault
	}
	mtailn = mtailAct[mtailn]
	if mtailChk[mtailn] == mtailtoken { /* valid shift */
		mtailrcvr.char = -1
		mtailtoken = -1
		mtailVAL = mtailrcvr.lval
		mtailstate = mtailn
		if Errflag > 0 {
			Errflag--
		}
		goto mtailstack
	}

mtaildefault:
	/* default state action */
	mtailn = mtailDef[mtailstate]
	if mtailn == -2 {
		if mtailrcvr.char < 0 {
			mtailrcvr.char, mtailtoken = mtaillex1(mtaillex, &mtailrcvr.lval)
		}

		/* look through exception table */
		xi := 0
		for {
			if mtailExca[xi+0] == -1 && mtailExca[xi+1] == mtailstate {
				break
			}
			xi += 2
		}
		for xi += 2; ; xi += 2 {
			mtailn = mtailExca[xi+0]
			if mtailn < 0 || mtailn == mtailtoken {
				break
			}
		}
		mtailn = mtailExca[xi+1]
		if mtailn < 0 {
			goto ret0
		}
	}
	if mtailn == 0 {
		/* error ... attempt to resume parsing */
		switch Errflag {
		case 0: /* brand new error */
			mtaillex.Error(mtailErrorMessage(mtailstate, mtailtoken))
			Nerrs++
			if mtailDebug >= 1 {
				__yyfmt__.Printf("%s", mtailStatname(mtailstate))
				__yyfmt__.Printf(" saw %s\n", mtailTokname(mtailtoken))
			}
			fallthrough

		case 1, 2: /* incompletely recovered error ... try again */
			Errflag = 3

			/* find a state where "error" is a legal shift action */
			for mtailp >= 0 {
				mtailn = mtailPact[mtailS[mtailp].yys] + mtailErrCode
				if mtailn >= 0 && mtailn < mtailLast {
					mtailstate = mtailAct[mtailn] /* simulate a shift of "error" */
					if mtailChk[mtailstate] == mtailErrCode {
						goto mtailstack
					}
				}

				/* the current p has no shift on "error", pop stack */
				if mtailDebug >= 2 {
					__yyfmt__.Printf("error recovery pops state %d\n", mtailS[mtailp].yys)
				}
				mtailp--
			}
			/* there is no state on the stack with an error shift ... abort */
			goto ret1

		case 3: /* no shift yet; clobber input char */
			if mtailDebug >= 2 {
				__yyfmt__.Printf("error recovery discards %s\n", mtailTokname(mtailtoken))
			}
			if mtailtoken == mtailEofCode {
				goto ret1
			}
			mtailrcvr.char = -1
			mtailtoken = -1
			goto mtailnewstate /* try again in the same state */
		}
	}

	/* reduction by production mtailn */
	if mtailDebug >= 2 {
		__yyfmt__.Printf("reduce %v in:\n\t%v\n", mtailn, mtailStatname(mtailstate))
	}

	mtailnt := mtailn
	mtailpt := mtailp
	_ = mtailpt // guard against "declared and not used"

	mtailp -= mtailR2[mtailn]
	// mtailp is now the index of $0. Perform the default action. Iff the
	// reduced production is ε, $1 is possibly out of range.
	if mtailp+1 >= len(mtailS) {
		nyys := make([]mtailSymType, len(mtailS)*2)
		copy(nyys, mtailS)
		mtailS = nyys
	}
	mtailVAL = mtailS[mtailp+1]

	/* consult goto table to find next state */
	mtailn = mtailR1[mtailn]
	mtailg := mtailPgo[mtailn]
	mtailj := mtailg + mtailS[mtailp].yys + 1

	if mtailj >= mtailLast {
		mtailstate = mtailAct[mtailg]
	} else {
		mtailstate = mtailAct[mtailj]
		if mtailChk[mtailstate] != -mtailn {
			mtailstate = mtailAct[mtailg]
		}
	}
	// dummy call; replaced with literal code
	switch mtailnt {

	case 1:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:91
		{
			mtaillex.(*parser).root = mtailDollar[1].n
		}
	case 2:
		mtailDollar = mtailS[mtailpt-0 : mtailpt+1]
//line parser.y:98
		{
			mtailVAL.n = &ast.StmtList{}
		}
	case 3:
		mtailDollar = mtailS[mtailpt-2 : mtailpt+1]
//line parser.y:102
		{
			mtailVAL.n = mtailDollar[1].n
			if mtailDollar[2].n != nil {
				mtailVAL.n.(*ast.StmtList).Children = append(mtailVAL.n.(*ast.StmtList).Children, mtailDollar[2].n)
			}
		}
	case 4:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:112
		{
			mtailVAL.n = mtailDollar[1].n
		}
	case 5:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:114
		{
			mtailVAL.n = mtailDollar[1].n
		}
	case 6:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:116
		{
			mtailVAL.n = mtailDollar[1].n
		}
	case 7:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:118
		{
			mtailVAL.n = mtailDollar[1].n
		}
	case 8:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:120
		{
			mtailVAL.n = mtailDollar[1].n
		}
	case 9:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:122
		{
			mtailVAL.n = mtailDollar[1].n
		}
	case 10:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:124
		{
			mtailVAL.n = &ast.NextStmt{tokenpos(mtaillex)}
		}
	case 11:
		mtailDollar = mtailS[mtailpt-3 : mtailpt+1]
//line parser.y:128
		{
			mtailVAL.n = &ast.PatternFragment{Id: mtailDollar[2].n, Expr: mtailDollar[3].n}
		}
	case 12:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:132
		{
			mtailVAL.n = &ast.StopStmt{tokenpos(mtaillex)}
		}
	case 13:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:136
		{
			mtailVAL.n = &ast.Error{tokenpos(mtaillex), mtailDollar[1].text}
		}
	case 14:
		mtailDollar = mtailS[mtailpt-4 : mtailpt+1]
//line parser.y:143
		{
			mtailVAL.n = &ast.CondStmt{mtailDollar[1].n, mtailDollar[2].n, mtailDollar[4].n, nil}
		}
	case 15:
		mtailDollar = mtailS[mtailpt-2 : mtailpt+1]
//line parser.y:147
		{
			if mtailDollar[1].n != nil {
				mtailVAL.n = &ast.CondStmt{mtailDollar[1].n, mtailDollar[2].n, nil, nil}
			} else {
				mtailVAL.n = mtailDollar[2].n
			}
		}
	case 16:
		mtailDollar = mtailS[mtailpt-2 : mtailpt+1]
//line parser.y:155
		{
			o := &ast.OtherwiseStmt{tokenpos(mtaillex)}
			mtailVAL.n = &ast.CondStmt{o, mtailDollar[2].n, nil, nil}
		}
	case 17:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:163
		{
			mtailVAL.n = nil
		}
	case 18:
		mtailDollar = mtailS[mtailpt-2 : mtailpt+1]
//line parser.y:165
		{
			mtailVAL.n = mtailDollar[1].n
		}
	case 19:
		mtailDollar = mtailS[mtailpt-3 : mtailpt+1]
//line parser.y:170
		{
			mtailVAL.n = mtailDollar[2].n
		}
	case 20:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:177
		{
			mtailVAL.n = mtailDollar[1].n
		}
	case 21:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:179
		{
			mtailVAL.n = mtailDollar[1].n
		}
	case 22:
		mtailDollar = mtailS[mtailpt-4 : mtailpt+1]
//line parser.y:184
		{
			mtailVAL.n = &ast.BinaryExpr{Lhs: mtailDollar[1].n, Rhs: mtailDollar[4].n, Op: mtailDollar[2].op}
		}
	case 23:
		mtailDollar = mtailS[mtailpt-4 : mtailpt+1]
//line parser.y:188
		{
			mtailVAL.n = &ast.BinaryExpr{Lhs: mtailDollar[1].n, Rhs: mtailDollar[4].n, Op: mtailDollar[2].op}
		}
	case 24:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:195
		{
			mtailVAL.n = mtailDollar[1].n
		}
	case 25:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:197
		{
			mtailVAL.n = mtailDollar[1].n
		}
	case 26:
		mtailDollar = mtailS[mtailpt-4 : mtailpt+1]
//line parser.y:199
		{
			mtailVAL.n = &ast.BinaryExpr{Lhs: mtailDollar[1].n, Rhs: mtailDollar[4].n, Op: mtailDollar[2].op}
		}
	case 27:
		mtailDollar = mtailS[mtailpt-4 : mtailpt+1]
//line parser.y:203
		{
			mtailVAL.n = &ast.BinaryExpr{Lhs: mtailDollar[1].n, Rhs: mtailDollar[4].n, Op: mtailDollar[2].op}
		}
	case 28:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:210
		{
			mtailVAL.op = mtailDollar[1].op
		}
	case 29:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:212
		{
			mtailVAL.op = mtailDollar[1].op
		}
	case 30:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:217
		{
			mtailVAL.n = mtailDollar[1].n
		}
	case 31:
		mtailDollar = mtailS[mtailpt-4 : mtailpt+1]
//line parser.y:219
		{
			mtailVAL.n = &ast.BinaryExpr{Lhs: mtailDollar[1].n, Rhs: mtailDollar[4].n, Op: mtailDollar[2].op}
		}
	case 32:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:226
		{
			mtailVAL.op = mtailDollar[1].op
		}
	case 33:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:228
		{
			mtailVAL.op = mtailDollar[1].op
		}
	case 34:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:230
		{
			mtailVAL.op = mtailDollar[1].op
		}
	case 35:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:235
		{
			mtailVAL.n = mtailDollar[1].n
		}
	case 36:
		mtailDollar = mtailS[mtailpt-4 : mtailpt+1]
//line parser.y:237
		{
			mtailVAL.n = &ast.BinaryExpr{Lhs: mtailDollar[1].n, Rhs: mtailDollar[4].n, Op: mtailDollar[2].op}
		}
	case 37:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:244
		{
			mtailVAL.op = mtailDollar[1].op
		}
	case 38:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:246
		{
			mtailVAL.op = mtailDollar[1].op
		}
	case 39:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:248
		{
			mtailVAL.op = mtailDollar[1].op
		}
	case 40:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:250
		{
			mtailVAL.op = mtailDollar[1].op
		}
	case 41:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:252
		{
			mtailVAL.op = mtailDollar[1].op
		}
	case 42:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:254
		{
			mtailVAL.op = mtailDollar[1].op
		}
	case 43:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:259
		{
			mtailVAL.n = mtailDollar[1].n
		}
	case 44:
		mtailDollar = mtailS[mtailpt-4 : mtailpt+1]
//line parser.y:261
		{
			mtailVAL.n = &ast.BinaryExpr{Lhs: mtailDollar[1].n, Rhs: mtailDollar[4].n, Op: mtailDollar[2].op}
		}
	case 45:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:268
		{
			mtailVAL.op = mtailDollar[1].op
		}
	case 46:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:270
		{
			mtailVAL.op = mtailDollar[1].op
		}
	case 47:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:275
		{
			mtailVAL.n = mtailDollar[1].n
		}
	case 48:
		mtailDollar = mtailS[mtailpt-4 : mtailpt+1]
//line parser.y:277
		{
			mtailVAL.n = &ast.BinaryExpr{Lhs: mtailDollar[1].n, Rhs: mtailDollar[4].n, Op: mtailDollar[2].op}
		}
	case 49:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:284
		{
			mtailVAL.n = mtailDollar[1].n
		}
	case 50:
		mtailDollar = mtailS[mtailpt-4 : mtailpt+1]
//line parser.y:286
		{
			mtailVAL.n = &ast.BinaryExpr{Lhs: mtailDollar[1].n, Rhs: mtailDollar[4].n, Op: mtailDollar[2].op}
		}
	case 51:
		mtailDollar = mtailS[mtailpt-4 : mtailpt+1]
//line parser.y:290
		{
			mtailVAL.n = &ast.BinaryExpr{Lhs: mtailDollar[1].n, Rhs: mtailDollar[4].n, Op: mtailDollar[2].op}
		}
	case 52:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:297
		{
			mtailVAL.op = mtailDollar[1].op
		}
	case 53:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:299
		{
			mtailVAL.op = mtailDollar[1].op
		}
	case 54:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:304
		{
			mtailVAL.n = &ast.PatternExpr{Expr: mtailDollar[1].n}
		}
	case 55:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:311
		{
			mtailVAL.n = mtailDollar[1].n
		}
	case 56:
		mtailDollar = mtailS[mtailpt-4 : mtailpt+1]
//line parser.y:313
		{
			mtailVAL.n = &ast.BinaryExpr{Lhs: mtailDollar[1].n, Rhs: mtailDollar[4].n, Op: CONCAT}
		}
	case 57:
		mtailDollar = mtailS[mtailpt-4 : mtailpt+1]
//line parser.y:317
		{
			mtailVAL.n = &ast.BinaryExpr{Lhs: mtailDollar[1].n, Rhs: mtailDollar[4].n, Op: CONCAT}
		}
	case 58:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:324
		{
			mtailVAL.op = mtailDollar[1].op
		}
	case 59:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:326
		{
			mtailVAL.op = mtailDollar[1].op
		}
	case 60:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:331
		{
			mtailVAL.n = mtailDollar[1].n
		}
	case 61:
		mtailDollar = mtailS[mtailpt-4 : mtailpt+1]
//line parser.y:333
		{
			mtailVAL.n = &ast.BinaryExpr{Lhs: mtailDollar[1].n, Rhs: mtailDollar[4].n, Op: mtailDollar[2].op}
		}
	case 62:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:340
		{
			mtailVAL.op = mtailDollar[1].op
		}
	case 63:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:342
		{
			mtailVAL.op = mtailDollar[1].op
		}
	case 64:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:344
		{
			mtailVAL.op = mtailDollar[1].op
		}
	case 65:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:346
		{
			mtailVAL.op = mtailDollar[1].op
		}
	case 66:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:351
		{
			mtailVAL.n = mtailDollar[1].n
		}
	case 67:
		mtailDollar = mtailS[mtailpt-2 : mtailpt+1]
//line parser.y:353
		{
			mtailVAL.n = &ast.UnaryExpr{P: tokenpos(mtaillex), Expr: mtailDollar[2].n, Op: mtailDollar[1].op}
		}
	case 68:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:360
		{
			mtailVAL.n = mtailDollar[1].n
		}
	case 69:
		mtailDollar = mtailS[mtailpt-2 : mtailpt+1]
//line parser.y:362
		{
			mtailVAL.n = &ast.UnaryExpr{P: tokenpos(mtaillex), Expr: mtailDollar[1].n, Op: mtailDollar[2].op}
		}
	case 70:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:369
		{
			mtailVAL.op = mtailDollar[1].op
		}
	case 71:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:371
		{
			mtailVAL.op = mtailDollar[1].op
		}
	case 72:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:376
		{
			mtailVAL.n = mtailDollar[1].n
		}
	case 73:
		mtailDollar = mtailS[mtailpt-3 : mtailpt+1]
//line parser.y:378
		{
			mtailVAL.n = &ast.BuiltinExpr{P: tokenpos(mtaillex), Name: mtailDollar[1].text, Args: nil}
		}
	case 74:
		mtailDollar = mtailS[mtailpt-4 : mtailpt+1]
//line parser.y:382
		{
			mtailVAL.n = &ast.BuiltinExpr{P: tokenpos(mtaillex), Name: mtailDollar[1].text, Args: mtailDollar[3].n}
		}
	case 75:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:386
		{
			mtailVAL.n = &ast.CaprefTerm{tokenpos(mtaillex), mtailDollar[1].text, false, nil}
		}
	case 76:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:390
		{
			mtailVAL.n = &ast.CaprefTerm{tokenpos(mtaillex), mtailDollar[1].text, true, nil}
		}
	case 77:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:394
		{
			mtailVAL.n = &ast.StringLit{tokenpos(mtaillex), mtailDollar[1].text}
		}
	case 78:
		mtailDollar = mtailS[mtailpt-3 : mtailpt+1]
//line parser.y:398
		{
			mtailVAL.n = mtailDollar[2].n
		}
	case 79:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:402
		{
			mtailVAL.n = &ast.IntLit{tokenpos(mtaillex), mtailDollar[1].intVal}
		}
	case 80:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:406
		{
			mtailVAL.n = &ast.FloatLit{tokenpos(mtaillex), mtailDollar[1].floatVal}
		}
	case 81:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:413
		{
			mtailVAL.n = &ast.IndexedExpr{Lhs: mtailDollar[1].n, Index: &ast.ExprList{}}
		}
	case 82:
		mtailDollar = mtailS[mtailpt-4 : mtailpt+1]
//line parser.y:417
		{
			mtailVAL.n = mtailDollar[1].n
			mtailVAL.n.(*ast.IndexedExpr).Index.(*ast.ExprList).Children = append(
				mtailVAL.n.(*ast.IndexedExpr).Index.(*ast.ExprList).Children,
				mtailDollar[3].n.(*ast.ExprList).Children...)
		}
	case 83:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:427
		{
			mtailVAL.n = &ast.IdTerm{tokenpos(mtaillex), mtailDollar[1].text, nil, false}
		}
	case 84:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:434
		{
			mtailVAL.n = &ast.ExprList{}
			mtailVAL.n.(*ast.ExprList).Children = append(mtailVAL.n.(*ast.ExprList).Children, mtailDollar[1].n)
		}
	case 85:
		mtailDollar = mtailS[mtailpt-3 : mtailpt+1]
//line parser.y:439
		{
			mtailVAL.n = mtailDollar[1].n
			mtailVAL.n.(*ast.ExprList).Children = append(mtailVAL.n.(*ast.ExprList).Children, mtailDollar[3].n)
		}
	case 86:
		mtailDollar = mtailS[mtailpt-5 : mtailpt+1]
//line parser.y:447
		{
			mp := markedpos(mtaillex)
			tp := tokenpos(mtaillex)
			pos := ast.MergePosition(&mp, &tp)
			mtailVAL.n = &ast.PatternLit{P: *pos, Pattern: mtailDollar[4].text}
		}
	case 87:
		mtailDollar = mtailS[mtailpt-3 : mtailpt+1]
//line parser.y:457
		{
			mtailVAL.n = mtailDollar[3].n
			d := mtailVAL.n.(*ast.VarDecl)
			d.Kind = mtailDollar[2].kind
			d.Hidden = mtailDollar[1].flag
		}
	case 88:
		mtailDollar = mtailS[mtailpt-0 : mtailpt+1]
//line parser.y:467
		{
			mtailVAL.flag = false
		}
	case 89:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:471
		{
			mtailVAL.flag = true
		}
	case 90:
		mtailDollar = mtailS[mtailpt-2 : mtailpt+1]
//line parser.y:478
		{
			mtailVAL.n = mtailDollar[1].n
			mtailVAL.n.(*ast.VarDecl).Keys = mtailDollar[2].texts
		}
	case 91:
		mtailDollar = mtailS[mtailpt-2 : mtailpt+1]
//line parser.y:483
		{
			mtailVAL.n = mtailDollar[1].n
			mtailVAL.n.(*ast.VarDecl).ExportedName = mtailDollar[2].text
		}
	case 92:
		mtailDollar = mtailS[mtailpt-2 : mtailpt+1]
//line parser.y:488
		{
			mtailVAL.n = mtailDollar[1].n
			mtailVAL.n.(*ast.VarDecl).Buckets = mtailDollar[2].floats
		}
	case 93:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:493
		{
			mtailVAL.n = mtailDollar[1].n
		}
	case 94:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:500
		{
			mtailVAL.n = &ast.VarDecl{P: tokenpos(mtaillex), Name: mtailDollar[1].text}
		}
	case 95:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:504
		{
			mtailVAL.n = &ast.VarDecl{P: tokenpos(mtaillex), Name: mtailDollar[1].text}
		}
	case 96:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:511
		{
			mtailVAL.kind = metrics.Counter
		}
	case 97:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:515
		{
			mtailVAL.kind = metrics.Gauge
		}
	case 98:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:519
		{
			mtailVAL.kind = metrics.Timer
		}
	case 99:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:523
		{
			mtailVAL.kind = metrics.Text
		}
	case 100:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:527
		{
			mtailVAL.kind = metrics.Histogram
		}
	case 101:
		mtailDollar = mtailS[mtailpt-2 : mtailpt+1]
//line parser.y:534
		{
			mtailVAL.texts = mtailDollar[2].texts
		}
	case 102:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:541
		{
			mtailVAL.texts = make([]string, 0)
			mtailVAL.texts = append(mtailVAL.texts, mtailDollar[1].text)
		}
	case 103:
		mtailDollar = mtailS[mtailpt-3 : mtailpt+1]
//line parser.y:546
		{
			mtailVAL.texts = mtailDollar[1].texts
			mtailVAL.texts = append(mtailVAL.texts, mtailDollar[3].text)
		}
	case 104:
		mtailDollar = mtailS[mtailpt-2 : mtailpt+1]
//line parser.y:554
		{
			mtailVAL.text = mtailDollar[2].text
		}
	case 105:
		mtailDollar = mtailS[mtailpt-2 : mtailpt+1]
//line parser.y:561
		{
			mtailVAL.floats = mtailDollar[2].floats
		}
	case 106:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:567
		{
			mtailVAL.floats = make([]float64, 0)
			mtailVAL.floats = append(mtailVAL.floats, mtailDollar[1].floatVal)
		}
	case 107:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:572
		{
			mtailVAL.floats = make([]float64, 0)
			mtailVAL.floats = append(mtailVAL.floats, float64(mtailDollar[1].intVal))
		}
	case 108:
		mtailDollar = mtailS[mtailpt-3 : mtailpt+1]
//line parser.y:577
		{
			mtailVAL.floats = mtailDollar[1].floats
			mtailVAL.floats = append(mtailVAL.floats, mtailDollar[3].floatVal)
		}
	case 109:
		mtailDollar = mtailS[mtailpt-3 : mtailpt+1]
//line parser.y:582
		{
			mtailVAL.floats = mtailDollar[1].floats
			mtailVAL.floats = append(mtailVAL.floats, float64(mtailDollar[3].intVal))
		}
	case 110:
		mtailDollar = mtailS[mtailpt-4 : mtailpt+1]
//line parser.y:589
		{
			mtailVAL.n = &ast.DecoDecl{P: markedpos(mtaillex), Name: mtailDollar[3].text, Block: mtailDollar[4].n}
		}
	case 111:
		mtailDollar = mtailS[mtailpt-3 : mtailpt+1]
//line parser.y:596
		{
			mtailVAL.n = &ast.DecoStmt{markedpos(mtaillex), mtailDollar[2].text, mtailDollar[3].n, nil, nil}
		}
	case 112:
		mtailDollar = mtailS[mtailpt-4 : mtailpt+1]
//line parser.y:603
		{
			mtailVAL.n = &ast.DelStmt{P: tokenpos(mtaillex), N: mtailDollar[2].n, Expiry: mtailDollar[4].duration}
		}
	case 113:
		mtailDollar = mtailS[mtailpt-2 : mtailpt+1]
//line parser.y:607
		{
			mtailVAL.n = &ast.DelStmt{P: tokenpos(mtaillex), N: mtailDollar[2].n}
		}
	case 114:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:613
		{
			mtailVAL.text = mtailDollar[1].text
		}
	case 115:
		mtailDollar = mtailS[mtailpt-1 : mtailpt+1]
//line parser.y:617
		{
			mtailVAL.text = mtailDollar[1].text
		}
	case 116:
		mtailDollar = mtailS[mtailpt-0 : mtailpt+1]
//line parser.y:627
		{
			glog.V(2).Infof("position marked at %v", tokenpos(mtaillex))
			mtaillex.(*parser).pos = tokenpos(mtaillex)
		}
	case 117:
		mtailDollar = mtailS[mtailpt-0 : mtailpt+1]
//line parser.y:637
		{
			mtaillex.(*parser).inRegex()
		}
	}
	goto mtailstack /* stack new state and value */
}
