/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

class TarInputStream
extends FilterInputStream {
    private TarEntry currentEntry;
    private long remaining;
    private long reminder;
    private final byte[] buf = new byte[512];

    TarInputStream(InputStream in) {
        super(in);
    }

    public TarEntry getNextEntry() throws IOException {
        boolean notFile;
        int read;
        if (this.currentEntry != null) {
            this.skipN(this.remaining);
            if (this.reminder != 0L) {
                this.skipN(512L - this.reminder);
            }
        }
        if ((read = this.in.readNBytes(this.buf, 0, 512)) == 0) {
            return null;
        }
        if (read != 512) {
            throw new EOFException();
        }
        if (Arrays.compare(this.buf, new byte[512]) == 0) {
            return null;
        }
        String name = this.getString(0, 100);
        boolean bl = notFile = this.buf[156] != 0 && this.buf[156] != 48 || name.endsWith("/");
        if (notFile) {
            this.remaining = 0L;
            this.reminder = 0L;
        } else {
            String sizeString = this.getString(124, 12);
            this.remaining = sizeString.isEmpty() ? 0L : Long.parseLong(sizeString, 8);
            this.reminder = this.remaining % 512L;
        }
        this.currentEntry = new TarEntry(name, notFile);
        return this.currentEntry;
    }

    @Override
    public int read() throws IOException {
        if (this.remaining == 0L) {
            return -1;
        }
        --this.remaining;
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.remaining <= 0L) {
            return -1;
        }
        int read = this.in.read(b, off, this.remaining > Integer.MAX_VALUE ? len : (int)Math.min((long)len, this.remaining));
        this.remaining -= (long)read;
        return read;
    }

    private String getString(int offset, int maxLen) {
        return new String(this.buf, offset, maxLen, StandardCharsets.UTF_8).trim();
    }

    private void skipN(long n) throws IOException {
        while (n > 0L) {
            long skip = this.in.skip(n);
            if (skip < n) {
                int read = this.in.read();
                if (read == -1) {
                    throw new EOFException();
                }
                --n;
            }
            n -= skip;
        }
    }

    record TarEntry(String name, boolean notFile) {
    }
}

