/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.stats;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.ml.dataframe.stats.AnalysisStats;
import org.elasticsearch.xpack.core.ml.dataframe.stats.common.DataCounts;
import org.elasticsearch.xpack.core.ml.dataframe.stats.common.MemoryUsage;
import org.elasticsearch.xpack.core.ml.utils.PhaseProgress;
import org.elasticsearch.xpack.ml.dataframe.stats.DataCountsTracker;
import org.elasticsearch.xpack.ml.dataframe.stats.ProgressTracker;

public class StatsHolder {
    private volatile ProgressTracker progressTracker;
    private final AtomicReference<MemoryUsage> memoryUsageHolder;
    private final AtomicReference<AnalysisStats> analysisStatsHolder;
    private final DataCountsTracker dataCountsTracker;

    public StatsHolder(List<PhaseProgress> progress, @Nullable MemoryUsage memoryUsage, @Nullable AnalysisStats analysisStats, DataCounts dataCounts) {
        this.progressTracker = new ProgressTracker(progress);
        this.memoryUsageHolder = new AtomicReference<MemoryUsage>(memoryUsage);
        this.analysisStatsHolder = new AtomicReference<AnalysisStats>(analysisStats);
        this.dataCountsTracker = new DataCountsTracker(dataCounts);
    }

    public void adjustProgressTracker(List<String> analysisPhases, boolean hasInferencePhase) {
        int reindexingProgressPercent = this.progressTracker.getReindexingProgressPercent();
        boolean areAllPhasesBeforeInferenceComplete = this.progressTracker.areAllPhasesExceptInferenceComplete();
        this.progressTracker = ProgressTracker.fromZeroes(analysisPhases, hasInferencePhase);
        if (reindexingProgressPercent > 0 && reindexingProgressPercent < 100) {
            this.progressTracker.updateReindexingProgress(1);
        } else {
            this.progressTracker.updateReindexingProgress(reindexingProgressPercent);
        }
        if (hasInferencePhase && areAllPhasesBeforeInferenceComplete) {
            this.progressTracker.resetForInference();
        }
    }

    public void resetProgressTracker(List<String> analysisPhases, boolean hasInferencePhase) {
        this.progressTracker = ProgressTracker.fromZeroes(analysisPhases, hasInferencePhase);
        this.progressTracker.updateReindexingProgress(1);
    }

    public ProgressTracker getProgressTracker() {
        return this.progressTracker;
    }

    public void setMemoryUsage(MemoryUsage memoryUsage) {
        this.memoryUsageHolder.set(memoryUsage);
    }

    public MemoryUsage getMemoryUsage() {
        return this.memoryUsageHolder.get();
    }

    public void setAnalysisStats(AnalysisStats analysisStats) {
        this.analysisStatsHolder.set(analysisStats);
    }

    public AnalysisStats getAnalysisStats() {
        return this.analysisStatsHolder.get();
    }

    public DataCountsTracker getDataCountsTracker() {
        return this.dataCountsTracker;
    }
}

