/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.ltr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.script.GeneralScriptException;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.script.mustache.MustacheInvalidParameterException;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.LearningToRankConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ltr.LearningToRankFeatureExtractorBuilder;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ltr.QueryExtractorBuilder;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObject;
import org.elasticsearch.xpack.core.ml.utils.QueryProvider;
import org.elasticsearch.xpack.ml.inference.loadingservice.LocalModel;
import org.elasticsearch.xpack.ml.inference.loadingservice.ModelLoadingService;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelProvider;

public class LearningToRankService {
    private static final Map<String, String> SCRIPT_OPTIONS = Map.ofEntries(Map.entry("detect_missing_params", Boolean.TRUE.toString()));
    private final ModelLoadingService modelLoadingService;
    private final TrainedModelProvider trainedModelProvider;
    private final ScriptService scriptService;
    private final XContentParserConfiguration parserConfiguration;

    public LearningToRankService(ModelLoadingService modelLoadingService, TrainedModelProvider trainedModelProvider, ScriptService scriptService, NamedXContentRegistry xContentRegistry) {
        this(modelLoadingService, trainedModelProvider, scriptService, XContentParserConfiguration.EMPTY.withRegistry(xContentRegistry));
    }

    LearningToRankService(ModelLoadingService modelLoadingService, TrainedModelProvider trainedModelProvider, ScriptService scriptService, XContentParserConfiguration parserConfiguration) {
        this.modelLoadingService = modelLoadingService;
        this.scriptService = scriptService;
        this.trainedModelProvider = trainedModelProvider;
        this.parserConfiguration = parserConfiguration;
    }

    public void loadLocalModel(String modelId, ActionListener<LocalModel> listener) {
        this.modelLoadingService.getModelForLearningToRank(modelId, listener);
    }

    public void loadLearningToRankConfig(String modelId, Map<String, Object> params, ActionListener<LearningToRankConfig> listener) {
        this.trainedModelProvider.getTrainedModel(this.modelLoadingService.getModelId(modelId), GetTrainedModelsAction.Includes.all(), null, (ActionListener<TrainedModelConfig>)ActionListener.wrap(trainedModelConfig -> {
            InferenceConfig patt0$temp = trainedModelConfig.getInferenceConfig();
            if (patt0$temp instanceof LearningToRankConfig) {
                LearningToRankConfig retrievedInferenceConfig = (LearningToRankConfig)patt0$temp;
                listener.onResponse((Object)this.applyParams(retrievedInferenceConfig, params));
                return;
            }
            listener.onFailure((Exception)((Object)ExceptionsHelper.badRequestException((String)Messages.getMessage((String)"Inference config of type [{0}] is invalid, must be of type [{1}]", (Object[])new Object[]{Optional.ofNullable(trainedModelConfig.getInferenceConfig()).map(NamedXContentObject::getName).orElse("null"), LearningToRankConfig.NAME.getPreferredName()}), (Object[])new Object[0])));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private LearningToRankConfig applyParams(LearningToRankConfig config, Map<String, Object> params) throws Exception {
        if (!this.scriptService.isLangSupported("mustache")) {
            return config;
        }
        ArrayList<LearningToRankFeatureExtractorBuilder> featureExtractorBuilders = new ArrayList<LearningToRankFeatureExtractorBuilder>();
        HashMap<String, Object> mergedParams = new HashMap<String, Object>(Objects.requireNonNullElse(params, Map.of()));
        XContentHelper.mergeDefaults(mergedParams, (Map)config.getParamsDefaults());
        for (LearningToRankFeatureExtractorBuilder featureExtractorBuilder : config.getFeatureExtractorBuilders()) {
            featureExtractorBuilders.add(this.applyParams(featureExtractorBuilder, mergedParams));
        }
        return LearningToRankConfig.builder((LearningToRankConfig)config).setLearningToRankFeatureExtractorBuilders(featureExtractorBuilders).build();
    }

    private LearningToRankFeatureExtractorBuilder applyParams(LearningToRankFeatureExtractorBuilder featureExtractorBuilder, Map<String, Object> params) throws Exception {
        if (featureExtractorBuilder instanceof QueryExtractorBuilder) {
            QueryExtractorBuilder queryExtractorBuilder = (QueryExtractorBuilder)featureExtractorBuilder;
            featureExtractorBuilder = this.applyParams(queryExtractorBuilder, params);
        }
        featureExtractorBuilder.validate();
        return featureExtractorBuilder;
    }

    private QueryExtractorBuilder applyParams(QueryExtractorBuilder queryExtractorBuilder, Map<String, Object> params) throws IOException {
        QueryExtractorBuilder queryExtractorBuilder2;
        block10: {
            String templateSource = this.templateSource(queryExtractorBuilder.query());
            if (!templateSource.contains("{{")) {
                return queryExtractorBuilder;
            }
            Script script = new Script(ScriptType.INLINE, "mustache", templateSource, SCRIPT_OPTIONS, Collections.emptyMap());
            String parsedTemplate = ((TemplateScript.Factory)this.scriptService.compile(script, TemplateScript.CONTEXT)).newInstance(params).execute();
            XContentParser parser = XContentType.JSON.xContent().createParser(this.parserConfiguration, parsedTemplate);
            try {
                queryExtractorBuilder2 = new QueryExtractorBuilder(queryExtractorBuilder.featureName(), QueryProvider.fromXContent((XContentParser)parser, (boolean)false, (String)"Inference config query is not parsable"), queryExtractorBuilder.defaultScore());
                if (parser == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (GeneralScriptException e) {
                    if (e.getRootCause().getClass().getName().equals(MustacheInvalidParameterException.class.getName())) {
                        return new QueryExtractorBuilder(queryExtractorBuilder.featureName(), this.defaultQuery(queryExtractorBuilder.defaultScore()), queryExtractorBuilder.defaultScore());
                    }
                    throw e;
                }
            }
            parser.close();
        }
        return queryExtractorBuilder2;
    }

    private String templateSource(QueryProvider queryProvider) throws IOException {
        try (XContentBuilder configSourceBuilder = XContentBuilder.builder((XContent)XContentType.JSON.xContent());){
            String string = BytesReference.bytes((XContentBuilder)queryProvider.toXContent(configSourceBuilder, ToXContent.EMPTY_PARAMS)).utf8ToString();
            return string;
        }
    }

    private QueryProvider defaultQuery(float score) throws IOException {
        MatchNoneQueryBuilder query = score == 0.0f ? new MatchNoneQueryBuilder() : new MatchAllQueryBuilder().boost(score);
        return QueryProvider.fromParsedQuery((QueryBuilder)query);
    }
}

