/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.ql.capabilities.UnresolvedException;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.ql.expression.UnresolvedNamedExpression;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class UnresolvedStar
extends UnresolvedNamedExpression {
    private final UnresolvedAttribute qualifier;

    public UnresolvedStar(Source source, UnresolvedAttribute qualifier) {
        super(source, Collections.emptyList());
        this.qualifier = qualifier;
    }

    @Override
    protected NodeInfo<UnresolvedStar> info() {
        return NodeInfo.create(this, UnresolvedStar::new, this.qualifier);
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        throw new UnsupportedOperationException("this type of node doesn't have any children to replace");
    }

    @Override
    public Nullability nullable() {
        throw new UnresolvedException("nullable", (Object)this);
    }

    public UnresolvedAttribute qualifier() {
        return this.qualifier;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.qualifier);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        UnresolvedStar other = (UnresolvedStar)obj;
        return Objects.equals(this.qualifier, other.qualifier);
    }

    private String message() {
        return (String)(this.qualifier() != null ? this.qualifier().qualifiedName() + "." : "") + "*";
    }

    @Override
    public String unresolvedMessage() {
        return "Cannot determine columns for [" + this.message() + "]";
    }

    @Override
    public String nodeString() {
        return this.toString();
    }

    @Override
    public String toString() {
        return "?" + this.message();
    }
}

