/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.azure;

import java.io.IOException;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.logging.log4j.core.util.Throwables;
import org.elasticsearch.SpecialPermission;

public final class SocketAccess {
    private SocketAccess() {
    }

    public static <T> T doPrivilegedException(PrivilegedExceptionAction<T> operation) {
        SpecialPermission.check();
        try {
            return AccessController.doPrivileged(operation);
        }
        catch (PrivilegedActionException e) {
            Throwables.rethrow((Throwable)e.getCause());
            assert (false) : "always throws";
            return null;
        }
    }

    public static void doPrivilegedVoidException(StorageRunnable action) {
        SpecialPermission.check();
        try {
            AccessController.doPrivileged(() -> {
                action.executeCouldThrow();
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            Throwables.rethrow((Throwable)e.getCause());
        }
    }

    @FunctionalInterface
    public static interface StorageRunnable {
        public void executeCouldThrow() throws URISyntaxException, IOException;
    }
}

