/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.create;

import java.util.Map;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.master.AcknowledgedRequestBuilder;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class CreateIndexRequestBuilder
extends AcknowledgedRequestBuilder<CreateIndexRequest, CreateIndexResponse, CreateIndexRequestBuilder> {
    public CreateIndexRequestBuilder(ElasticsearchClient client) {
        super(client, TransportCreateIndexAction.TYPE, new CreateIndexRequest());
    }

    public CreateIndexRequestBuilder(ElasticsearchClient client, String index) {
        super(client, TransportCreateIndexAction.TYPE, new CreateIndexRequest(index));
    }

    public CreateIndexRequestBuilder setIndex(String index) {
        ((CreateIndexRequest)this.request).index(index);
        return this;
    }

    public CreateIndexRequestBuilder setSettings(Settings settings) {
        ((CreateIndexRequest)this.request).settings(settings);
        return this;
    }

    public CreateIndexRequestBuilder setSettings(Settings.Builder settings) {
        ((CreateIndexRequest)this.request).settings(settings);
        return this;
    }

    public CreateIndexRequestBuilder setSettings(XContentBuilder builder) {
        ((CreateIndexRequest)this.request).settings(builder);
        return this;
    }

    public CreateIndexRequestBuilder setSettings(String source, XContentType xContentType) {
        ((CreateIndexRequest)this.request).settings(source, xContentType);
        return this;
    }

    public CreateIndexRequestBuilder setSettings(Map<String, ?> source) {
        ((CreateIndexRequest)this.request).settings(source);
        return this;
    }

    public CreateIndexRequestBuilder setMapping(String source) {
        ((CreateIndexRequest)this.request).mapping(source);
        return this;
    }

    public CreateIndexRequestBuilder setCause(String cause) {
        ((CreateIndexRequest)this.request).cause(cause);
        return this;
    }

    public CreateIndexRequestBuilder setMapping(XContentBuilder source) {
        ((CreateIndexRequest)this.request).mapping(source);
        return this;
    }

    public CreateIndexRequestBuilder setMapping(Map<String, Object> source) {
        ((CreateIndexRequest)this.request).mapping(source);
        return this;
    }

    public CreateIndexRequestBuilder setMapping(String ... source) {
        ((CreateIndexRequest)this.request).simpleMapping(source);
        return this;
    }

    public CreateIndexRequestBuilder setAliases(Map<String, ?> source) {
        ((CreateIndexRequest)this.request).aliases(source);
        return this;
    }

    public CreateIndexRequestBuilder setAliases(String source) {
        ((CreateIndexRequest)this.request).aliases(source);
        return this;
    }

    public CreateIndexRequestBuilder setAliases(XContentBuilder source) {
        ((CreateIndexRequest)this.request).aliases(source);
        return this;
    }

    public CreateIndexRequestBuilder setAliases(BytesReference source) {
        ((CreateIndexRequest)this.request).aliases(source);
        return this;
    }

    public CreateIndexRequestBuilder addAlias(Alias alias) {
        ((CreateIndexRequest)this.request).alias(alias);
        return this;
    }

    public CreateIndexRequestBuilder setSource(String source, XContentType xContentType) {
        ((CreateIndexRequest)this.request).source(source, xContentType);
        return this;
    }

    public CreateIndexRequestBuilder setSource(BytesReference source, XContentType xContentType) {
        ((CreateIndexRequest)this.request).source(source, xContentType);
        return this;
    }

    public CreateIndexRequestBuilder setSource(byte[] source, XContentType xContentType) {
        ((CreateIndexRequest)this.request).source(source, xContentType);
        return this;
    }

    public CreateIndexRequestBuilder setSource(byte[] source, int offset, int length, XContentType xContentType) {
        ((CreateIndexRequest)this.request).source(source, offset, length, xContentType);
        return this;
    }

    public CreateIndexRequestBuilder setSource(Map<String, ?> source) {
        ((CreateIndexRequest)this.request).source(source, LoggingDeprecationHandler.INSTANCE);
        return this;
    }

    public CreateIndexRequestBuilder setSource(XContentBuilder source) {
        ((CreateIndexRequest)this.request).source(source);
        return this;
    }

    public CreateIndexRequestBuilder setWaitForActiveShards(ActiveShardCount waitForActiveShards) {
        ((CreateIndexRequest)this.request).waitForActiveShards(waitForActiveShards);
        return this;
    }

    public CreateIndexRequestBuilder setWaitForActiveShards(int waitForActiveShards) {
        return this.setWaitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public CreateIndexRequestBuilder setRequireDataStream(boolean requireDataStream) {
        ((CreateIndexRequest)this.request).requireDataStream(requireDataStream);
        return this;
    }
}

