/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.get;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.info.TransportClusterInfoAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetMappingsAction
extends TransportClusterInfoAction<GetMappingsRequest, GetMappingsResponse> {
    private static final Logger logger = LogManager.getLogger(TransportGetMappingsAction.class);
    private final IndicesService indicesService;

    @Inject
    public TransportGetMappingsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
        super("indices:admin/mappings/get", transportService, clusterService, threadPool, actionFilters, GetMappingsRequest::new, indexNameExpressionResolver, GetMappingsResponse::new);
        this.indicesService = indicesService;
    }

    @Override
    protected void doMasterOperation(Task task, GetMappingsRequest request, String[] concreteIndices, ClusterState state, ActionListener<GetMappingsResponse> listener) {
        logger.trace("serving getMapping request based on version {}", (Object)state.version());
        Metadata metadata = state.metadata();
        Map<String, MappingMetadata> mappings = metadata.findMappings(concreteIndices, this.indicesService.getFieldFilter(), () -> TransportGetMappingsAction.checkCancellation(task));
        listener.onResponse(new GetMappingsResponse(mappings));
    }

    private static void checkCancellation(Task task) {
        if (task instanceof CancellableTask) {
            CancellableTask cancellableTask = (CancellableTask)task;
            cancellableTask.ensureNotCancelled();
        }
    }
}

