/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.elasticsearch.action.search.SearchPhaseResults;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.transport.LeakTracker;
import org.elasticsearch.transport.TransportMessage;

class ArraySearchPhaseResults<Result extends SearchPhaseResult>
extends SearchPhaseResults<Result> {
    final AtomicArray<Result> results;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Releasable releasable = LeakTracker.wrap(() -> {
        for (SearchPhaseResult result : this.getAtomicArray().asList()) {
            result.decRef();
        }
    });

    ArraySearchPhaseResults(int size) {
        super(size);
        this.results = new AtomicArray(size);
    }

    @Override
    Stream<Result> getSuccessfulResults() {
        return this.results.asList().stream();
    }

    @Override
    void consumeResult(Result result, Runnable next) {
        assert (this.results.get(((SearchPhaseResult)result).getShardIndex()) == null) : "shardIndex: " + ((SearchPhaseResult)result).getShardIndex() + " is already set";
        this.results.set(((SearchPhaseResult)result).getShardIndex(), result);
        ((TransportMessage)result).incRef();
        next.run();
    }

    public final void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.releasable.close();
            this.doClose();
        }
    }

    protected void doClose() {
    }

    @Override
    boolean hasResult(int shardIndex) {
        return this.results.get(shardIndex) != null;
    }

    @Override
    AtomicArray<Result> getAtomicArray() {
        return this.results;
    }
}

