/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.master;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.master.IsAcknowledgedSupplier;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class AcknowledgedResponse
extends ActionResponse
implements IsAcknowledgedSupplier,
ToXContentObject {
    public static final AcknowledgedResponse TRUE = new AcknowledgedResponse(true);
    public static final AcknowledgedResponse FALSE = new AcknowledgedResponse(false);
    public static final String ACKNOWLEDGED_KEY = "acknowledged";
    protected final boolean acknowledged;

    public static AcknowledgedResponse readFrom(StreamInput in) throws IOException {
        return in.readBoolean() ? TRUE : FALSE;
    }

    protected AcknowledgedResponse(StreamInput in) throws IOException {
        super(in);
        this.acknowledged = in.readBoolean();
    }

    public static AcknowledgedResponse of(boolean acknowledged) {
        return acknowledged ? TRUE : FALSE;
    }

    protected AcknowledgedResponse(boolean acknowledged) {
        this.acknowledged = acknowledged;
    }

    @Override
    public final boolean isAcknowledged() {
        return this.acknowledged;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.acknowledged);
    }

    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ACKNOWLEDGED_KEY, this.isAcknowledged());
        this.addCustomFields(builder, params);
        builder.endObject();
        return builder;
    }

    protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcknowledgedResponse that = (AcknowledgedResponse)o;
        return this.isAcknowledged() == that.isAcknowledged();
    }

    public int hashCode() {
        return Objects.hash(this.isAcknowledged());
    }
}

