/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.bootstrap.ConsoleLoader;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.nativeaccess.NativeAccess;

@SuppressForbidden(reason="exposes read-only view of system properties")
public final class BootstrapInfo {
    private static final SetOnce<ConsoleLoader.Console> console = new SetOnce();
    public static final String UNTRUSTED_CODEBASE = "/untrusted";
    public static final char SERVER_READY_MARKER = '\u0018';
    public static final char SERVER_SHUTDOWN_MARKER = '\u001b';
    private static final Dictionary<Object, Object> SYSTEM_PROPERTIES;

    private BootstrapInfo() {
    }

    public static boolean isMemoryLocked() {
        return NativeAccess.instance().isMemoryLocked();
    }

    @Nullable
    public static ConsoleLoader.Console getConsole() {
        return (ConsoleLoader.Console)console.get();
    }

    public static Dictionary<Object, Object> getSystemProperties() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertyAccess("*");
        }
        return SYSTEM_PROPERTIES;
    }

    public static void init() {
    }

    static void setConsole(@Nullable ConsoleLoader.Console console) {
        BootstrapInfo.console.set((Object)console);
    }

    static {
        final Properties sysprops = System.getProperties();
        SYSTEM_PROPERTIES = new Dictionary<Object, Object>(){

            @Override
            public int size() {
                return sysprops.size();
            }

            @Override
            public boolean isEmpty() {
                return sysprops.isEmpty();
            }

            @Override
            public Enumeration<Object> keys() {
                return sysprops.keys();
            }

            @Override
            public Enumeration<Object> elements() {
                return sysprops.elements();
            }

            @Override
            public Object get(Object key) {
                return sysprops.get(key);
            }

            @Override
            public Object put(Object key, Object value) {
                throw new UnsupportedOperationException("treat system properties as immutable");
            }

            @Override
            public Object remove(Object key) {
                throw new UnsupportedOperationException("treat system properties as immutable");
            }
        };
    }
}

