/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class NodeConnectionsService
extends AbstractLifecycleComponent {
    private static final Logger logger = LogManager.getLogger(NodeConnectionsService.class);
    public static final Setting<TimeValue> CLUSTER_NODE_RECONNECT_INTERVAL_SETTING = Setting.positiveTimeSetting("cluster.nodes.reconnect_interval", TimeValue.timeValueSeconds((long)10L), Setting.Property.NodeScope);
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private final Object mutex = new Object();
    private final Map<DiscoveryNode, ConnectionTarget> targetsByNode = new HashMap<DiscoveryNode, ConnectionTarget>();
    private final TimeValue reconnectInterval;
    private volatile ConnectionChecker connectionChecker;

    @Inject
    public NodeConnectionsService(Settings settings, ThreadPool threadPool, TransportService transportService) {
        this.threadPool = threadPool;
        this.transportService = transportService;
        this.reconnectInterval = CLUSTER_NODE_RECONNECT_INTERVAL_SETTING.get(settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectToNodes(DiscoveryNodes discoveryNodes, Runnable onCompletion) {
        if (discoveryNodes.getSize() == 0) {
            onCompletion.run();
            return;
        }
        ArrayList<Runnable> runnables = new ArrayList<Runnable>(discoveryNodes.getSize());
        try (RefCountingRunnable refs = new RefCountingRunnable(onCompletion);){
            Object object = this.mutex;
            synchronized (object) {
                Iterator iterator = discoveryNodes.mastersFirstStream().iterator();
                while (iterator.hasNext()) {
                    boolean isNewNode;
                    DiscoveryNode discoveryNode = (DiscoveryNode)iterator.next();
                    ConnectionTarget connectionTarget = this.targetsByNode.get(discoveryNode);
                    boolean bl = isNewNode = connectionTarget == null;
                    if (isNewNode) {
                        connectionTarget = new ConnectionTarget(discoveryNode);
                        this.targetsByNode.put(discoveryNode, connectionTarget);
                    }
                    if (isNewNode) {
                        logger.debug("connecting to {}", (Object)discoveryNode);
                        runnables.add(connectionTarget.connect(refs.acquire()));
                        continue;
                    }
                    logger.trace("checking connection to existing node [{}]", (Object)discoveryNode);
                    runnables.add(connectionTarget.connect(null));
                }
            }
        }
        runnables.forEach(Runnable::run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectFromNodesExcept(DiscoveryNodes discoveryNodes) {
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        Object object = this.mutex;
        synchronized (object) {
            HashSet<DiscoveryNode> nodesToDisconnect = new HashSet<DiscoveryNode>(this.targetsByNode.keySet());
            for (DiscoveryNode discoveryNode : discoveryNodes) {
                nodesToDisconnect.remove(discoveryNode);
            }
            for (DiscoveryNode discoveryNode : nodesToDisconnect) {
                runnables.add(this.targetsByNode.remove(discoveryNode)::disconnect);
            }
        }
        runnables.forEach(Runnable::run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureConnections(Runnable onCompletion) {
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        try (RefCountingRunnable refs = new RefCountingRunnable(onCompletion);){
            Object object = this.mutex;
            synchronized (object) {
                logger.trace("ensureConnections: {}", this.targetsByNode);
                for (ConnectionTarget connectionTarget : this.targetsByNode.values()) {
                    runnables.add(connectionTarget.connect(refs.acquire()));
                }
            }
        }
        runnables.forEach(Runnable::run);
    }

    @Override
    protected void doStart() {
        ConnectionChecker connectionChecker;
        this.connectionChecker = connectionChecker = new ConnectionChecker();
        connectionChecker.scheduleNextCheck();
    }

    @Override
    protected void doStop() {
        this.connectionChecker = null;
    }

    @Override
    protected void doClose() {
    }

    public void reconnectToNodes(DiscoveryNodes discoveryNodes, Runnable onCompletion) {
        this.connectToNodes(discoveryNodes, () -> {
            this.disconnectFromNodesExcept(discoveryNodes);
            this.ensureConnections(onCompletion);
        });
    }

    private class ConnectionTarget {
        private final DiscoveryNode discoveryNode;
        private final AtomicInteger consecutiveFailureCount = new AtomicInteger();
        private final AtomicReference<Releasable> connectionRef = new AtomicReference();
        private List<Releasable> pendingRefs;
        private boolean connectionInProgress;
        private static final List<Releasable> NOOP = List.of();

        ConnectionTarget(DiscoveryNode discoveryNode) {
            this.discoveryNode = discoveryNode;
        }

        private void setConnectionRef(Releasable connectionReleasable) {
            Releasables.close((Releasable)this.connectionRef.getAndSet(connectionReleasable));
        }

        Runnable connect(Releasable onCompletion) {
            return () -> {
                this.registerRef(onCompletion);
                this.doConnect();
            };
        }

        private synchronized void registerRef(Releasable ref) {
            if (ref == null) {
                this.pendingRefs = this.pendingRefs == null ? NOOP : this.pendingRefs;
                return;
            }
            if (this.pendingRefs == null || this.pendingRefs == NOOP) {
                this.pendingRefs = new ArrayList<Releasable>();
            }
            this.pendingRefs.add(ref);
        }

        private synchronized Releasable acquireRefs() {
            List<Releasable> refs;
            if (!this.connectionInProgress && (refs = this.pendingRefs) != null) {
                this.pendingRefs = null;
                this.connectionInProgress = true;
                return Releasables.wrap(refs);
            }
            return null;
        }

        private synchronized void releaseListener() {
            assert (this.connectionInProgress);
            this.connectionInProgress = false;
        }

        private void doConnect() {
            final Releasable refs = this.acquireRefs();
            if (refs == null) {
                return;
            }
            final boolean alreadyConnected = NodeConnectionsService.this.transportService.nodeConnected(this.discoveryNode);
            if (alreadyConnected) {
                logger.trace("refreshing connection to {}", (Object)this.discoveryNode);
            } else {
                logger.debug("connecting to {}", (Object)this.discoveryNode);
            }
            NodeConnectionsService.this.transportService.connectToNode(this.discoveryNode, ActionListener.runAfter(new ActionListener<Releasable>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResponse(Releasable connectionReleasable) {
                    boolean isActive;
                    if (alreadyConnected) {
                        logger.trace("refreshed connection to {}", (Object)ConnectionTarget.this.discoveryNode);
                    } else {
                        logger.debug("connected to {}", (Object)ConnectionTarget.this.discoveryNode);
                    }
                    ConnectionTarget.this.consecutiveFailureCount.set(0);
                    ConnectionTarget.this.setConnectionRef(connectionReleasable);
                    Object object = NodeConnectionsService.this.mutex;
                    synchronized (object) {
                        isActive = NodeConnectionsService.this.targetsByNode.get(ConnectionTarget.this.discoveryNode) == ConnectionTarget.this;
                    }
                    if (!isActive) {
                        logger.debug("connected to stale {} - releasing stale connection", (Object)ConnectionTarget.this.discoveryNode);
                        ConnectionTarget.this.setConnectionRef(null);
                    }
                    Releasables.closeExpectNoException((Releasable)refs);
                }

                @Override
                public void onFailure(Exception e) {
                    int currentFailureCount = ConnectionTarget.this.consecutiveFailureCount.incrementAndGet();
                    Level level = currentFailureCount % 6 == 1 ? Level.WARN : Level.DEBUG;
                    logger.log(level, () -> Strings.format((String)"failed to connect to %s (tried [%s] times)", (Object[])new Object[]{ConnectionTarget.this.discoveryNode, currentFailureCount}), (Throwable)e);
                    ConnectionTarget.this.setConnectionRef(null);
                    Releasables.closeExpectNoException((Releasable)refs);
                }
            }, () -> {
                this.releaseListener();
                NodeConnectionsService.this.threadPool.generic().execute(new Runnable(){

                    @Override
                    public void run() {
                        ConnectionTarget.this.doConnect();
                    }

                    public String toString() {
                        return "ensure connection to " + String.valueOf(ConnectionTarget.this.discoveryNode);
                    }
                });
            }));
        }

        void disconnect() {
            this.setConnectionRef(null);
            logger.debug("disconnected from {}", (Object)this.discoveryNode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = NodeConnectionsService.this.mutex;
            synchronized (object) {
                return "ConnectionTarget{discoveryNode=" + String.valueOf(this.discoveryNode) + "}";
            }
        }
    }

    class ConnectionChecker
    extends AbstractRunnable {
        ConnectionChecker() {
        }

        @Override
        protected void doRun() {
            if (NodeConnectionsService.this.connectionChecker == this) {
                NodeConnectionsService.this.ensureConnections(this::scheduleNextCheck);
            }
        }

        void scheduleNextCheck() {
            if (NodeConnectionsService.this.connectionChecker == this) {
                NodeConnectionsService.this.threadPool.scheduleUnlessShuttingDown(NodeConnectionsService.this.reconnectInterval, NodeConnectionsService.this.threadPool.generic(), this);
            }
        }

        @Override
        public void onFailure(Exception e) {
            logger.warn("unexpected error while checking for node reconnects", (Throwable)e);
            this.scheduleNextCheck();
        }

        public String toString() {
            return "periodic reconnection checker";
        }
    }
}

