/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.AbstractBigByteArray;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BigLongArray;
import org.elasticsearch.common.util.DoubleArray;

final class BigDoubleArray
extends AbstractBigByteArray
implements DoubleArray {
    private static final BigDoubleArray ESTIMATOR = new BigDoubleArray(0L, BigArrays.NON_RECYCLING_INSTANCE, false);
    static final VarHandle VH_PLATFORM_NATIVE_DOUBLE = MethodHandles.byteArrayViewVarHandle(double[].class, ByteOrder.nativeOrder());
    private static final int PAGE_SHIFT = Integer.numberOfTrailingZeros(2048);

    BigDoubleArray(long size, BigArrays bigArrays, boolean clearOnResize) {
        super(2048, bigArrays, clearOnResize, size);
    }

    @Override
    public double get(long index) {
        int pageIndex = BigDoubleArray.pageIdx(index);
        int indexInPage = BigDoubleArray.idxInPage(index);
        return VH_PLATFORM_NATIVE_DOUBLE.get(this.pages[pageIndex], indexInPage << 3);
    }

    @Override
    public void set(long index, double value) {
        int pageIndex = BigDoubleArray.pageIdx(index);
        int indexInPage = BigDoubleArray.idxInPage(index);
        byte[] page = this.getPageForWriting(pageIndex);
        VH_PLATFORM_NATIVE_DOUBLE.set(page, indexInPage << 3, value);
    }

    @Override
    public double increment(long index, double inc) {
        int pageIndex = BigDoubleArray.pageIdx(index);
        int indexInPage = BigDoubleArray.idxInPage(index);
        byte[] page = this.getPageForWriting(pageIndex);
        double newVal = VH_PLATFORM_NATIVE_DOUBLE.get(page, indexInPage << 3) + inc;
        VH_PLATFORM_NATIVE_DOUBLE.set(page, indexInPage << 3, newVal);
        return newVal;
    }

    @Override
    protected int numBytesPerElement() {
        return 4;
    }

    @Override
    public void fill(long fromIndex, long toIndex, double value) {
        int toPage;
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int fromPage = BigDoubleArray.pageIdx(fromIndex);
        if (fromPage == (toPage = BigDoubleArray.pageIdx(toIndex - 1L))) {
            BigDoubleArray.fill(this.getPageForWriting(fromPage), BigDoubleArray.idxInPage(fromIndex), BigDoubleArray.idxInPage(toIndex - 1L) + 1, value);
        } else {
            BigDoubleArray.fill(this.getPageForWriting(fromPage), BigDoubleArray.idxInPage(fromIndex), 2048, value);
            for (int i = fromPage + 1; i < toPage; ++i) {
                BigDoubleArray.fill(this.getPageForWriting(i), 0, 2048, value);
            }
            BigDoubleArray.fill(this.getPageForWriting(toPage), 0, BigDoubleArray.idxInPage(toIndex - 1L) + 1, value);
        }
    }

    public static void fill(byte[] page, int from, int to, double value) {
        if (from < to) {
            VH_PLATFORM_NATIVE_DOUBLE.set(page, from << 3, value);
            BigDoubleArray.fillBySelfCopy(page, from << 3, to << 3, 8);
        }
    }

    @Override
    public void fillWith(StreamInput in) throws IOException {
        this.readPages(in);
    }

    public static long estimateRamBytes(long size) {
        return ESTIMATOR.ramBytesEstimated(size);
    }

    @Override
    public void set(long index, byte[] buf, int offset, int len) {
        this.set(index, buf, offset, len, 3);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        BigLongArray.writePages(out, this.size, this.pages, 8);
    }

    private static int pageIdx(long index) {
        return (int)(index >>> PAGE_SHIFT);
    }

    private static int idxInPage(long index) {
        return (int)(index & 0x7FFL);
    }
}

