/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.NamedMatches;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.SuggestingErrorOnUnknown;
import org.elasticsearch.index.query.CoordinatorRewriteContext;
import org.elasticsearch.index.query.InnerHitContextBuilder;
import org.elasticsearch.index.query.InnerHitsRewriteContext;
import org.elasticsearch.index.query.InterceptedQueryBuilderWrapper;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.QueryValidationException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.plugins.internal.rewriter.QueryRewriteInterceptor;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.xcontent.AbstractObjectParser;
import org.elasticsearch.xcontent.FilterXContentParserWrapper;
import org.elasticsearch.xcontent.NamedObjectNotFoundException;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;

public abstract class AbstractQueryBuilder<QB extends AbstractQueryBuilder<QB>>
implements QueryBuilder {
    public static final float DEFAULT_BOOST = 1.0f;
    public static final ParseField NAME_FIELD = new ParseField("_name", new String[0]);
    public static final ParseField BOOST_FIELD = new ParseField("boost", new String[0]);
    private static int maxNestedDepth = SearchModule.INDICES_MAX_NESTED_DEPTH_SETTING.getDefault(Settings.EMPTY);
    protected String queryName;
    protected float boost = 1.0f;

    protected AbstractQueryBuilder() {
    }

    protected AbstractQueryBuilder(StreamInput in) throws IOException {
        this.boost = in.readFloat();
        this.checkNegativeBoost(this.boost);
        this.queryName = in.readOptionalString();
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeFloat(this.boost);
        out.writeOptionalString(this.queryName);
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.doXContent(builder, params);
        builder.endObject();
        return builder;
    }

    protected abstract void doXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    @Deprecated
    protected final void printBoostAndQueryName(XContentBuilder builder) throws IOException {
        builder.field(BOOST_FIELD.getPreferredName(), this.boost);
        if (this.queryName != null) {
            builder.field(NAME_FIELD.getPreferredName(), this.queryName);
        }
    }

    protected final void boostAndQueryNameToXContent(XContentBuilder builder) throws IOException {
        if (this.boost != 1.0f) {
            builder.field(BOOST_FIELD.getPreferredName(), this.boost);
        }
        if (this.queryName != null) {
            builder.field(NAME_FIELD.getPreferredName(), this.queryName);
        }
    }

    @Override
    public final Query toQuery(SearchExecutionContext context) throws IOException {
        Query query = this.doToQuery(context);
        if (query != null) {
            if (this.boost != 1.0f && !(query instanceof MatchNoDocsQuery)) {
                query = new BoostQuery(query, this.boost);
            }
            if (this.queryName != null) {
                if (context.rewriteToNamedQuery()) {
                    query = NamedMatches.wrapQuery((String)this.queryName, (Query)query);
                }
                context.addNamedQuery(this.queryName, query);
            }
        }
        return query;
    }

    protected abstract Query doToQuery(SearchExecutionContext var1) throws IOException;

    public final QB queryName(String queryName) {
        this.queryName = queryName;
        return (QB)this;
    }

    @Override
    public final String queryName() {
        return this.queryName;
    }

    @Override
    public final float boost() {
        return this.boost;
    }

    protected final void checkNegativeBoost(float boost) {
        if (Float.compare(boost, 0.0f) < 0) {
            throw new IllegalArgumentException("negative [boost] are not allowed in [" + this.toString() + "], use a value between 0 and 1 to deboost");
        }
    }

    public final QB boost(float boost) {
        this.checkNegativeBoost(boost);
        this.boost = boost;
        return (QB)this;
    }

    protected final QueryValidationException addValidationError(String validationError, QueryValidationException validationException) {
        return QueryValidationException.addValidationError(this.getName(), validationError, validationException);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractQueryBuilder other = (AbstractQueryBuilder)obj;
        return Objects.equals(this.queryName, other.queryName) && Objects.equals(Float.valueOf(this.boost), Float.valueOf(other.boost)) && this.doEquals(other);
    }

    protected abstract boolean doEquals(QB var1);

    public final int hashCode() {
        return Objects.hash(this.getClass(), this.queryName, Float.valueOf(this.boost), this.doHashCode());
    }

    protected abstract int doHashCode();

    static Object maybeConvertToBytesRef(Object obj) {
        if (obj instanceof String) {
            String v = (String)obj;
            return BytesRefs.checkIndexableLength(BytesRefs.toExactSizedBytesRef(v));
        }
        if (obj instanceof CharBuffer) {
            CharBuffer v = (CharBuffer)obj;
            return BytesRefs.checkIndexableLength(new BytesRef((CharSequence)v));
        }
        if (obj instanceof BigInteger) {
            BigInteger v = (BigInteger)obj;
            return BytesRefs.toBytesRef(v);
        }
        return obj;
    }

    static Object maybeConvertToString(Object obj) {
        if (obj instanceof BytesRef) {
            return ((BytesRef)obj).utf8ToString();
        }
        if (obj instanceof CharBuffer) {
            return new BytesRef((CharSequence)((CharBuffer)obj)).utf8ToString();
        }
        return obj;
    }

    static Collection<Query> toQueries(Collection<QueryBuilder> queryBuilders, SearchExecutionContext context) throws QueryShardException, IOException {
        ArrayList<Query> queries = new ArrayList<Query>(queryBuilders.size());
        for (QueryBuilder queryBuilder : queryBuilders) {
            Query query = queryBuilder.rewrite(context).toQuery(context);
            if (query == null) continue;
            queries.add(query);
        }
        return queries;
    }

    @Override
    public String getName() {
        return this.getWriteableName();
    }

    protected static void writeQueries(StreamOutput out, List<? extends QueryBuilder> queries) throws IOException {
        out.writeVInt(queries.size());
        for (QueryBuilder queryBuilder : queries) {
            out.writeNamedWriteable(queryBuilder);
        }
    }

    protected static List<QueryBuilder> readQueries(StreamInput in) throws IOException {
        return in.readNamedWriteableCollectionAsList(QueryBuilder.class);
    }

    @Override
    public final QueryBuilder rewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        QueryBuilder rewritten;
        QueryRewriteInterceptor queryRewriteInterceptor = queryRewriteContext.getQueryRewriteInterceptor();
        if (queryRewriteInterceptor != null && (rewritten = queryRewriteInterceptor.interceptAndRewrite(queryRewriteContext, this)) != this) {
            return new InterceptedQueryBuilderWrapper(rewritten);
        }
        rewritten = this.doRewrite(queryRewriteContext);
        if (rewritten == this) {
            return rewritten;
        }
        if (this.queryName() != null && rewritten.queryName() == null) {
            rewritten.queryName(this.queryName());
        }
        if (this.boost() != 1.0f && rewritten.boost() == 1.0f) {
            rewritten.boost(this.boost());
        }
        return rewritten;
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        if (queryRewriteContext == null) {
            return this;
        }
        InnerHitsRewriteContext ihrc = queryRewriteContext.convertToInnerHitsRewriteContext();
        if (ihrc != null) {
            return this.doInnerHitsRewrite(ihrc);
        }
        CoordinatorRewriteContext crc = queryRewriteContext.convertToCoordinatorRewriteContext();
        if (crc != null) {
            return this.doCoordinatorRewrite(crc);
        }
        SearchExecutionContext sec = queryRewriteContext.convertToSearchExecutionContext();
        if (sec != null) {
            return this.doSearchRewrite(sec);
        }
        QueryRewriteContext context = queryRewriteContext.convertToIndexMetadataContext();
        if (context != null) {
            return this.doIndexMetadataRewrite(context);
        }
        return this;
    }

    protected QueryBuilder doCoordinatorRewrite(CoordinatorRewriteContext coordinatorRewriteContext) {
        return this;
    }

    protected QueryBuilder doSearchRewrite(SearchExecutionContext searchExecutionContext) throws IOException {
        return this.doIndexMetadataRewrite(searchExecutionContext);
    }

    protected QueryBuilder doIndexMetadataRewrite(QueryRewriteContext context) throws IOException {
        return this;
    }

    protected QueryBuilder doInnerHitsRewrite(InnerHitsRewriteContext context) throws IOException {
        return this;
    }

    protected void extractInnerHitBuilders(Map<String, InnerHitContextBuilder> innerHits) {
    }

    public static QueryBuilder parseTopLevelQuery(XContentParser parser) throws IOException {
        return AbstractQueryBuilder.parseTopLevelQuery(parser, queryName -> {});
    }

    public static QueryBuilder parseTopLevelQuery(XContentParser parser, final Consumer<String> queryNameConsumer) throws IOException {
        FilterXContentParserWrapper parserWrapper = new FilterXContentParserWrapper(parser){
            int nestedDepth;

            public <T> T namedObject(Class<T> categoryClass, String name, Object context) throws IOException {
                if (categoryClass.equals(QueryBuilder.class)) {
                    ++this.nestedDepth;
                    if (this.nestedDepth > maxNestedDepth) {
                        throw new IllegalArgumentException("The nested depth of the query exceeds the maximum nested depth for queries set in [" + SearchModule.INDICES_MAX_NESTED_DEPTH_SETTING.getKey() + "]");
                    }
                }
                Object namedObject = this.getXContentRegistry().parseNamedObject(categoryClass, name, (XContentParser)this, context);
                if (categoryClass.equals(QueryBuilder.class)) {
                    queryNameConsumer.accept(name);
                    --this.nestedDepth;
                }
                return (T)namedObject;
            }
        };
        return AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)parserWrapper);
    }

    protected static QueryBuilder parseInnerQueryBuilder(XContentParser parser) throws IOException {
        QueryBuilder result;
        if (parser.currentToken() != XContentParser.Token.START_OBJECT && parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "[_na] query malformed, must start with start_object", new Object[0]);
        }
        if (parser.nextToken() == XContentParser.Token.END_OBJECT) {
            throw new IllegalArgumentException("query malformed, empty clause found at [" + String.valueOf(parser.getTokenLocation()) + "]");
        }
        if (parser.currentToken() != XContentParser.Token.FIELD_NAME) {
            throw new ParsingException(parser.getTokenLocation(), "[_na] query malformed, no field after start_object", new Object[0]);
        }
        String queryName = parser.currentName();
        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "[" + queryName + "] query malformed, no start_object after query name", new Object[0]);
        }
        try {
            result = (QueryBuilder)parser.namedObject(QueryBuilder.class, queryName, null);
        }
        catch (NamedObjectNotFoundException e) {
            String message = String.format(Locale.ROOT, "unknown query [%s]%s", queryName, SuggestingErrorOnUnknown.suggest(queryName, e.getCandidates()));
            throw new ParsingException(new XContentLocation(e.getLineNumber(), e.getColumnNumber()), message, e, new Object[0]);
        }
        if (parser.currentToken() != XContentParser.Token.END_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "[" + queryName + "] malformed query, expected [END_OBJECT] but found [" + String.valueOf(parser.currentToken()) + "]", new Object[0]);
        }
        if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "[" + queryName + "] malformed query, expected [END_OBJECT] but found [" + String.valueOf(parser.currentToken()) + "]", new Object[0]);
        }
        return result;
    }

    protected static <T> T requireValue(T value, String message) {
        if (value == null) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    protected static void throwParsingExceptionOnMultipleFields(String queryName, XContentLocation contentLocation, String processedFieldName, String currentFieldName) {
        if (processedFieldName != null) {
            throw new ParsingException(contentLocation, "[" + queryName + "] query doesn't support multiple fields, found [" + processedFieldName + "] and [" + currentFieldName + "]", new Object[0]);
        }
    }

    protected static void declareStandardFields(AbstractObjectParser<? extends QueryBuilder, ?> parser) {
        parser.declareFloat(QueryBuilder::boost, BOOST_FIELD);
        parser.declareString(QueryBuilder::queryName, NAME_FIELD);
    }

    public static void setMaxNestedDepth(int maxNestedDepth) {
        if (maxNestedDepth < 1) {
            throw new IllegalArgumentException("maxNestedDepth must be >= 1");
        }
        AbstractQueryBuilder.maxNestedDepth = maxNestedDepth;
    }

    public static int getMaxNestedDepth() {
        return maxNestedDepth;
    }

    public final String toString() {
        return Strings.toString((ToXContent)this, true, true);
    }
}

